/*
 * Decompiled with CFR 0.152.
 */
package com.fe.scheduler.group;

import com.fe.Config;
import com.fe.client.ClientErrorMgmt;
import com.fe.scheduler.MyRengine;
import com.fe.scheduler.MyRengineCallbacks;
import com.fe.scheduler.StackFrame;
import com.fe.scheduler.engines.REngineWindows;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.StringReader;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.Random;
import org.apache.log4j.Logger;
import org.quartz.JobExecutionException;
import org.rosuda.JRI.REXP;

public class RScriptScheduledTask
extends REngineWindows {
    protected static MyRengine re = null;
    private Logger log = Logger.getLogger(RScriptScheduledTask.class);
    private StackFrame stackframe = null;
    private static String rVersion = null;
    private static boolean jriCompatible = false;
    private static String packageVersions = null;

    public RScriptScheduledTask(String string, String string2) {
        super(string, string2);
    }

    public static String getRVersion() {
        if (rVersion == null) {
            // empty if block
        }
        return rVersion;
    }

    public static String getRPackageVersion() {
        if (packageVersions == null) {
            // empty if block
        }
        return packageVersions;
    }

    public static boolean getJRICompatible() {
        if (rVersion == null) {
            // empty if block
        }
        return jriCompatible;
    }

    public static void updatePackageVersion() {
    }

    public void executeScript(StackFrame stackFrame) throws JobExecutionException, Exception {
        if (Config.getString("p2p.ignorejri") != null && Config.getString("p2p.ignorejri").equalsIgnoreCase("true")) {
            throw new Exception("JRI is not enalbed");
        }
        this.stackframe = stackFrame;
        Map map = stackFrame.getData();
        String string = (String)map.get("script");
        Number number = (Number)map.get("restart");
        Number number2 = (Number)map.get("script_id");
        if (string == null) {
            throw new JobExecutionException("Task Failed because no R script found or empty");
        }
        MyRengineCallbacks myRengineCallbacks = new MyRengineCallbacks();
        if (re != null && number.intValue() == 1) {
            re.end();
            this.log.debug((Object)"interupting R thread....");
            re = null;
            try {
                Thread.sleep(2000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (re == null) {
            this.log.debug((Object)"Rengine is null, creating one.......");
            re = new MyRengine(null, false, myRengineCallbacks);
            re.setStackFrame(stackFrame);
        } else {
            re.setStackFrame(stackFrame);
        }
        if (string != null && !string.equals("")) {
            try {
                String string2;
                BufferedReader bufferedReader = new BufferedReader(new StringReader(string));
                StringBuffer stringBuffer = new StringBuffer();
                String string3 = System.getProperty("java.io.tmpdir");
                File file = new File(string3 + File.separator + "rscript" + new SimpleDateFormat("mmddyyy_hh_mmss_").format(new Date()) + new Random().nextInt() + ".R");
                BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
                while ((string2 = bufferedReader.readLine()) != null) {
                    if (string2 == null || string2.equals("")) continue;
                    bufferedWriter.write(string2 + "\n");
                }
                bufferedWriter.close();
                bufferedReader.close();
                String string4 = file.getPath().replaceAll("\\\\", "\\\\\\\\");
                REXP rEXP = re.eval("source(\"" + string4 + "\")");
                this.log.debug((Object)("x1:" + rEXP));
                file.delete();
                if (rEXP == null) {
                    throw new Exception("R script:" + map.get("name") + " failed");
                }
                stackFrame.setTasklog(null);
                re.setStackFrame(null);
            }
            catch (Exception exception) {
                ClientErrorMgmt.reportError(exception, null);
                throw exception;
            }
        }
        this.log.debug((Object)"~~~~~~~~~~~R Script finishing execution...");
    }

    public static String codeInjectConcatenate(String string, String string2, String string3) throws Exception {
        String string4 = "";
        if (string != null && !string.equals("")) {
            string4 = string4 + "## Default Header Code ##\n";
            string4 = string4 + string + "\n";
            string4 = string4 + "## --------------------## \n";
        }
        if (string3 != null && !string3.equals("")) {
            string4 = string4 + "\n\n## Injected Code ##\n";
            string4 = string4 + string3 + "\n";
            string4 = string4 + "## --------------## \n";
        }
        if (string2 != null && !string2.equals("")) {
            string4 = string4 + string2 + "\n";
        }
        return string4;
    }
}

