/*
 * Decompiled with CFR 0.152.
 */
package com.fe.scheduler.rserve;

import com.fe.p2p.peer.PeerSpecificConfigurations;
import com.fe.scheduler.rserve.RServeSession;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.rosuda.REngine.Rserve.RConnection;

public class RServeConnectionPool {
    private static ConcurrentLinkedQueue<RServeSession> sessions = new ConcurrentLinkedQueue();
    private static ConcurrentLinkedQueue<RServeSession> sessInUse = new ConcurrentLinkedQueue();
    private static final Semaphore sessLock = new Semaphore(1, true);
    private static long TIMEOUT_MS = 2000L;

    private static void acquireLock() {
        try {
            Date date = new Date();
            sessLock.tryAcquire(TIMEOUT_MS, TimeUnit.MILLISECONDS);
        }
        catch (Exception exception) {
            Logger.getLogger(RServeConnectionPool.class).error((Object)("acquireLock() error:" + exception.getMessage()));
        }
    }

    private static void releaseLock() {
        try {
            sessLock.release();
        }
        catch (Exception exception) {
            Logger.getLogger(RServeConnectionPool.class).error((Object)("acquireLock() error:" + exception.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized RServeSession getRSession(String string) throws Exception {
        RServeConnectionPool.acquireLock();
        try {
            RServeSession rServeSession = null;
            if (sessions.size() > 0) {
                rServeSession = sessions.poll();
                sessInUse.add(rServeSession);
            } else {
                RConnection rConnection = null;
                for (int i = 0; rConnection == null && i < 10; ++i) {
                    try {
                        rConnection = new RConnection();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        Thread.sleep(200L);
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (rConnection != null) {
                    rServeSession = new RServeSession();
                    rConnection.assign(".r_session_id", rServeSession.getUid());
                    if (string != null && !string.trim().equals("")) {
                        try {
                            rConnection.parseAndEval(string);
                        }
                        catch (Exception exception) {
                            throw new Exception("Not able to load Rnint at RServeConnectionPool.getRsession(), for rinit: " + string);
                        }
                    }
                    int n = rConnection.eval("Sys.getpid()").asInteger();
                    rServeSession.setProcessid(n);
                    rServeSession.setRconnection(rConnection);
                    sessInUse.add(rServeSession);
                }
            }
            if (rServeSession != null) {
                rServeSession.setNoexecutions(rServeSession.getNoexecutions() + 1);
            }
            RServeSession rServeSession2 = rServeSession;
            return rServeSession2;
        }
        finally {
            RServeConnectionPool.releaseLock();
        }
    }

    public static List<RServeSession> getAllSessions() {
        ArrayList<RServeSession> arrayList = new ArrayList<RServeSession>();
        for (RServeSession rServeSession : sessions) {
            arrayList.add(rServeSession);
        }
        for (RServeSession rServeSession : sessInUse) {
            arrayList.add(rServeSession);
        }
        return arrayList;
    }

    public static void remove(RServeSession rServeSession) {
        if (sessInUse.contains(rServeSession)) {
            sessInUse.remove(rServeSession);
        }
        if (sessions.contains(rServeSession)) {
            sessions.remove(rServeSession);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void done(RServeSession rServeSession) throws Exception {
        RServeConnectionPool.acquireLock();
        try {
            int n = 0;
            String string = PeerSpecificConfigurations.getProperties().getProperty("rserve.max.executions.in.session");
            if (string != null && !string.trim().equals("")) {
                n = Integer.parseInt(string);
            }
            if (n > 0 && rServeSession.getNoexecutions() >= n) {
                Process process = Runtime.getRuntime().exec("kill -9 " + rServeSession.getProcessid());
                RServeConnectionPool.processOutput(process);
                RServeConnectionPool.remove(rServeSession);
            } else {
                sessInUse.remove(rServeSession);
                sessions.add(rServeSession);
            }
        }
        finally {
            RServeConnectionPool.releaseLock();
        }
    }

    private static void processOutput(Process process) throws Exception {
        String string;
        InputStream inputStream = process.getInputStream();
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        while ((string = bufferedReader.readLine()) != null) {
        }
    }
}

