/*
 * Decompiled with CFR 0.152.
 */
package com.fe.xls.current;

import com.fe.data.Contract;
import com.fe.xls.listener.CurrentFundamentalRowListener;
import com.fe.xls.listener.CurrentSheetListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TreeMap;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

public class XLSCurrentFundamentalReader {
    private File file;
    private int sheetscount = 0;
    private static int CONTRACT_TITLE_ROW = 1;
    private static int COMMODITYNAME_ROW = 0;
    private static int CONTRACT_TITLE_CELL_START_AT = 2;
    private static int COMMODITYNAME_CELL_START_AT = 2;
    private static int CONTRACT_DATE_CELL = 0;
    private static int DATA_ROW_START_AT = 3;
    private static int CURRENT_FIELD_ROW = 0;
    private static int CURRENT_FIELD_COL = 0;
    private Logger log = Logger.getLogger(XLSCurrentFundamentalReader.class);

    public XLSCurrentFundamentalReader(File file) {
        this.file = file;
    }

    public void processFile(CurrentSheetListener currentSheetListener, CurrentFundamentalRowListener currentFundamentalRowListener) throws Exception {
        int n;
        FileInputStream fileInputStream = new FileInputStream(this.file);
        HSSFWorkbook hSSFWorkbook = new HSSFWorkbook((InputStream)fileInputStream);
        this.sheetscount = hSSFWorkbook.getNumberOfSheets();
        String[] stringArray = new String[hSSFWorkbook.getNumberOfSheets()];
        for (n = 0; n < hSSFWorkbook.getNumberOfSheets(); ++n) {
            stringArray[n] = hSSFWorkbook.getSheetName(n);
        }
        currentSheetListener.sheetsBegin(this.file.getName(), stringArray);
        for (n = 0; n < hSSFWorkbook.getNumberOfSheets(); ++n) {
            Date date;
            HSSFSheet hSSFSheet = hSSFWorkbook.getSheetAt(n);
            String string = this.getCurrentField(hSSFSheet);
            if (string == null) continue;
            Vector vector = this.getContractTitles(hSSFSheet);
            Vector vector2 = this.getCommodityNames(hSSFSheet);
            this.log.debug((Object)("currrent :" + string));
            boolean bl = false;
            if (vector.size() != vector2.size()) {
                n = hSSFWorkbook.getNumberOfSheets();
                bl = true;
            }
            if (!currentSheetListener.excecute(date = null, hSSFWorkbook.getSheetName(n), vector, n) || bl || string == null) continue;
            for (int i = DATA_ROW_START_AT; i < hSSFSheet.getLastRowNum(); ++i) {
                HSSFRow hSSFRow = hSSFSheet.getRow(i);
                HSSFCell hSSFCell = hSSFRow.getCell(CONTRACT_DATE_CELL);
                Date date2 = this.getCurrentDate(hSSFCell);
                TreeMap<String, Contract> treeMap = this.getContracts(hSSFRow, vector, vector2, date2);
                if (currentFundamentalRowListener.excecuteContinue(hSSFWorkbook.getSheetName(n), string, treeMap, i)) continue;
                i = hSSFSheet.getLastRowNum() + 1;
            }
        }
        currentSheetListener.sheetsEnd();
        ((InputStream)fileInputStream).close();
    }

    private TreeMap<String, Contract> getContracts(HSSFRow hSSFRow, Vector vector, Vector vector2, Date date) {
        TreeMap<String, Contract> treeMap = new TreeMap<String, Contract>();
        int n = hSSFRow.getLastCellNum() > CONTRACT_TITLE_CELL_START_AT + vector.size() ? CONTRACT_TITLE_CELL_START_AT + vector.size() : hSSFRow.getLastCellNum();
        for (int i = CONTRACT_TITLE_CELL_START_AT; i < n; ++i) {
            HSSFCell hSSFCell = hSSFRow.getCell(i);
            if (hSSFCell == null || hSSFCell.getCellType() != 0 || i - CONTRACT_TITLE_CELL_START_AT >= vector.size() || vector.get(i - CONTRACT_TITLE_CELL_START_AT) == null) continue;
            Contract contract = new Contract();
            contract.setCdate(date);
            contract.setName((String)vector.get(i - CONTRACT_TITLE_CELL_START_AT));
            contract.setValue(hSSFCell.getNumericCellValue());
            treeMap.put((String)vector2.get(i - CONTRACT_TITLE_CELL_START_AT), contract);
        }
        return treeMap;
    }

    private Vector getContractTitles(HSSFSheet hSSFSheet) throws Exception {
        Vector<String> vector = new Vector<String>();
        HSSFRow hSSFRow = hSSFSheet.getRow(CONTRACT_TITLE_ROW);
        for (int i = CONTRACT_TITLE_CELL_START_AT; i < hSSFRow.getLastCellNum(); ++i) {
            HSSFCell hSSFCell = hSSFRow.getCell(i);
            if (hSSFCell == null || hSSFCell.getCellType() != 1) continue;
            vector.add(hSSFCell.getStringCellValue());
        }
        return vector;
    }

    private Vector getCommodityNames(HSSFSheet hSSFSheet) throws Exception {
        Vector<String> vector = new Vector<String>();
        HSSFRow hSSFRow = hSSFSheet.getRow(COMMODITYNAME_ROW);
        for (int i = COMMODITYNAME_CELL_START_AT; i < hSSFRow.getLastCellNum(); ++i) {
            HSSFCell hSSFCell = hSSFRow.getCell(i);
            if (hSSFCell == null || hSSFCell.getCellType() != 1) continue;
            vector.add(hSSFCell.getStringCellValue());
        }
        return vector;
    }

    private String getCurrentField(HSSFSheet hSSFSheet) throws Exception {
        HSSFCell hSSFCell;
        String string = null;
        HSSFRow hSSFRow = hSSFSheet.getRow(CURRENT_FIELD_ROW);
        if (hSSFRow != null && (hSSFCell = hSSFRow.getCell(CURRENT_FIELD_COL)) != null && hSSFCell.getCellType() == 1) {
            string = hSSFCell.getStringCellValue();
        }
        return string;
    }

    private Date getCurrentDate(HSSFCell hSSFCell) throws Exception {
        Date date = null;
        if (hSSFCell.getCellType() == 1) {
            String string = hSSFCell.getStringCellValue();
            this.log.debug((Object)("raw date1:" + string));
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd/MM/yy");
            date = simpleDateFormat.parse(string);
        } else if (hSSFCell.getCellType() == 0) {
            date = hSSFCell.getDateCellValue();
        }
        return date;
    }
}

