/*
 * Decompiled with CFR 0.152.
 */
package com.fe.xls.current;

import com.fe.data.Strategy;
import com.fe.xls.listener.CurrentSheetListener;
import com.fe.xls.listener.CurrentStrategyRowListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TreeMap;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

public class XLSCurrentStrgyContractReader {
    private File file;
    private int sheetscount = 0;
    private static int CONTRACT_TITLE_ROW = 1;
    private static int COMMODITYNAME_ROW = 0;
    private static int CONTRACT_TITLE_CELL_START_AT = 2;
    private static int COMMODITYNAME_CELL_START_AT = 2;
    private static int CONTRACT_FIELD_CELL = 0;
    private static int DATA_ROW_START_AT = 3;
    private static int CURRENT_DATE_ROW = 0;
    private static int CURRENT_DATE_COL = 0;
    private Logger log = Logger.getLogger(XLSCurrentStrgyContractReader.class);

    public XLSCurrentStrgyContractReader(File file) {
        this.file = file;
    }

    public void processFile(CurrentSheetListener currentSheetListener, CurrentStrategyRowListener currentStrategyRowListener) throws Exception {
        int n;
        FileInputStream fileInputStream = new FileInputStream(this.file);
        HSSFWorkbook hSSFWorkbook = new HSSFWorkbook((InputStream)fileInputStream);
        this.sheetscount = hSSFWorkbook.getNumberOfSheets();
        String[] stringArray = new String[hSSFWorkbook.getNumberOfSheets()];
        for (n = 0; n < hSSFWorkbook.getNumberOfSheets(); ++n) {
            stringArray[n] = hSSFWorkbook.getSheetName(n);
        }
        currentSheetListener.sheetsBegin(this.file.getName(), stringArray);
        for (n = 0; n < hSSFWorkbook.getNumberOfSheets(); ++n) {
            HSSFSheet hSSFSheet = hSSFWorkbook.getSheetAt(n);
            Date date = this.getCurrentDate(hSSFSheet);
            Vector vector = this.getContractTitles(hSSFSheet);
            Vector vector2 = this.getCommodityNames(hSSFSheet);
            this.log.debug((Object)("currrent :" + date));
            boolean bl = false;
            if (vector.size() != vector2.size()) {
                n = hSSFWorkbook.getNumberOfSheets();
                bl = true;
            }
            if (!currentSheetListener.excecute(date, hSSFWorkbook.getSheetName(n), vector, n) || bl) continue;
            for (int i = DATA_ROW_START_AT; i < hSSFSheet.getLastRowNum(); ++i) {
                HSSFRow hSSFRow = hSSFSheet.getRow(i);
                HSSFCell hSSFCell = hSSFRow.getCell(CONTRACT_FIELD_CELL);
                String string = null;
                if (hSSFCell != null) {
                    try {
                        string = hSSFCell.getStringCellValue();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                TreeMap<String, Strategy> treeMap = this.getContracts(hSSFRow, vector, vector2, date);
                if (currentStrategyRowListener.excecuteContinue(hSSFWorkbook.getSheetName(n), string, treeMap, i)) continue;
                i = hSSFSheet.getLastRowNum() + 1;
            }
        }
        currentSheetListener.sheetsEnd();
        ((InputStream)fileInputStream).close();
    }

    private TreeMap<String, Strategy> getContracts(HSSFRow hSSFRow, Vector vector, Vector vector2, Date date) {
        TreeMap<String, Strategy> treeMap = new TreeMap<String, Strategy>();
        int n = hSSFRow.getLastCellNum() > CONTRACT_TITLE_CELL_START_AT + vector.size() ? CONTRACT_TITLE_CELL_START_AT + vector.size() : hSSFRow.getLastCellNum();
        for (int i = CONTRACT_TITLE_CELL_START_AT; i < n; ++i) {
            Strategy strategy;
            HSSFCell hSSFCell = hSSFRow.getCell(i);
            if (hSSFCell == null) continue;
            if (hSSFCell.getCellType() == 0 && i - CONTRACT_TITLE_CELL_START_AT < vector.size() && vector.get(i - CONTRACT_TITLE_CELL_START_AT) != null) {
                strategy = new Strategy();
                strategy.setCdate(date);
                strategy.setName((String)vector.get(i - CONTRACT_TITLE_CELL_START_AT));
                strategy.setValue(hSSFCell.getNumericCellValue());
                treeMap.put((String)vector2.get(i - CONTRACT_TITLE_CELL_START_AT), strategy);
            }
            if (hSSFCell.getCellType() != 1 || hSSFCell.getStringCellValue() == null || i - CONTRACT_TITLE_CELL_START_AT >= vector.size() || vector.get(i - CONTRACT_TITLE_CELL_START_AT) == null) continue;
            strategy = new Strategy();
            strategy.setCdate(date);
            strategy.setName((String)vector.get(i - CONTRACT_TITLE_CELL_START_AT));
            strategy.setSvalue(hSSFCell.getStringCellValue());
            treeMap.put((String)vector2.get(i - CONTRACT_TITLE_CELL_START_AT), strategy);
        }
        return treeMap;
    }

    private Vector getContractTitles(HSSFSheet hSSFSheet) throws Exception {
        Vector<String> vector = new Vector<String>();
        HSSFRow hSSFRow = hSSFSheet.getRow(CONTRACT_TITLE_ROW);
        for (int i = CONTRACT_TITLE_CELL_START_AT; i < hSSFRow.getLastCellNum(); ++i) {
            HSSFCell hSSFCell = hSSFRow.getCell(i);
            if (hSSFCell == null || hSSFCell.getCellType() != 1) continue;
            vector.add(hSSFCell.getStringCellValue());
        }
        return vector;
    }

    private Vector getCommodityNames(HSSFSheet hSSFSheet) throws Exception {
        Vector<String> vector = new Vector<String>();
        HSSFRow hSSFRow = hSSFSheet.getRow(COMMODITYNAME_ROW);
        for (int i = COMMODITYNAME_CELL_START_AT; i < hSSFRow.getLastCellNum(); ++i) {
            HSSFCell hSSFCell = hSSFRow.getCell(i);
            if (hSSFCell == null || hSSFCell.getCellType() != 1) continue;
            vector.add(hSSFCell.getStringCellValue());
        }
        return vector;
    }

    private Date getCurrentDate(HSSFSheet hSSFSheet) throws Exception {
        Date date = null;
        HSSFRow hSSFRow = hSSFSheet.getRow(CURRENT_DATE_ROW);
        HSSFCell hSSFCell = hSSFRow.getCell(CURRENT_DATE_COL);
        if (hSSFCell != null) {
            if (hSSFCell.getCellType() == 1) {
                String string = hSSFCell.getStringCellValue();
                this.log.debug((Object)("raw date1:" + string));
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd/MM/yy");
                date = simpleDateFormat.parse(string);
            } else if (hSSFCell.getCellType() == 0) {
                date = hSSFCell.getDateCellValue();
            }
        }
        return date;
    }
}

