/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcs.auxiliary.remote;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.rmi.RMISecurityManager;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.server.RMISocketFactory;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RemoteUtils {
    private static final Log log = LogFactory.getLog((Class)RemoteUtils.class);

    private RemoteUtils() {
    }

    public static int createRegistry(int port) throws RemoteException {
        if (log.isInfoEnabled()) {
            log.info((Object)"createRegistry> setting security manager");
        }
        System.setSecurityManager(new RMISecurityManager());
        if (port < 1024) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Port chosen was less than 1024, will use default [1099] instead.");
            }
            port = 1099;
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("createRegistry> creating registry on port [" + port + "]"));
        }
        LocateRegistry.createRegistry(port);
        return port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadProps(String propFile) throws IOException {
        InputStream is = RemoteUtils.class.getResourceAsStream(propFile);
        Properties props = new Properties();
        try {
            props.load(is);
            if (log.isDebugEnabled()) {
                log.debug((Object)("props.size=" + props.size()));
            }
            if (log.isDebugEnabled()) {
                if (props != null) {
                    Enumeration<Object> en = props.keys();
                    StringBuffer buf = new StringBuffer();
                    while (en.hasMoreElements()) {
                        String key = (String)en.nextElement();
                        buf.append("\n" + key + " = " + props.getProperty(key));
                    }
                    log.debug((Object)buf.toString());
                } else {
                    log.debug((Object)"props is null");
                }
            }
        }
        catch (Exception ex) {
            log.error((Object)("Error loading remote properties, for file name [" + propFile + "]"), (Throwable)ex);
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        return props;
    }

    public static void configureGlobalCustomSocketFactory(final int timeoutMillis) {
        block4: {
            try {
                if (timeoutMillis > 0) {
                    if (log.isInfoEnabled()) {
                        log.info((Object)("RmiSocketFactoryTimeoutMillis [" + timeoutMillis + "]. " + " Configuring a custom socket factory."));
                    }
                    RMISocketFactory.setSocketFactory(new RMISocketFactory(){

                        public Socket createSocket(String host, int port) throws IOException {
                            Socket socket = new Socket();
                            socket.setSoTimeout(timeoutMillis);
                            socket.setSoLinger(false, 0);
                            socket.connect(new InetSocketAddress(host, port), timeoutMillis);
                            return socket;
                        }

                        public ServerSocket createServerSocket(int port) throws IOException {
                            return new ServerSocket(port);
                        }
                    });
                }
            }
            catch (Exception e) {
                RMISocketFactory factoryInUse = RMISocketFactory.getSocketFactory();
                if (factoryInUse == null || factoryInUse.getClass().getName().startsWith("org.apache.jcs")) break block4;
                log.info((Object)("Could not create new custom socket factory. " + e.getMessage() + " Factory in use = " + RMISocketFactory.getSocketFactory()));
            }
        }
    }
}

