/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcs.engine;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jcs.engine.behavior.ICacheListener;
import org.apache.jcs.engine.behavior.ICacheObserver;

public class CacheWatchRepairable
implements ICacheObserver {
    private static final Log log = LogFactory.getLog((Class)CacheWatchRepairable.class);
    private ICacheObserver cacheWatch;
    private Map cacheMap = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCacheWatch(ICacheObserver cacheWatch) {
        this.cacheWatch = cacheWatch;
        Map map = this.cacheMap;
        synchronized (map) {
            Iterator itr = this.cacheMap.entrySet().iterator();
            while (itr.hasNext()) {
                Map.Entry entry = itr.next();
                String cacheName = (String)entry.getKey();
                Set listenerSet = (Set)entry.getValue();
                Iterator itr2 = listenerSet.iterator();
                while (itr2.hasNext()) {
                    ICacheListener listener = (ICacheListener)itr2.next();
                    try {
                        if (log.isInfoEnabled()) {
                            log.info((Object)("Adding listener to cache watch. ICacheListener = " + listener + " | ICacheObserver = " + cacheWatch));
                        }
                        cacheWatch.addCacheListener(cacheName, listener);
                    }
                    catch (IOException ex) {
                        log.error((Object)("Problem adding listener. ICacheListener = " + listener + " | ICacheObserver = " + cacheWatch), (Throwable)ex);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCacheListener(String cacheName, ICacheListener obj) throws IOException {
        Map map = this.cacheMap;
        synchronized (map) {
            HashSet<ICacheListener> listenerSet = (HashSet<ICacheListener>)this.cacheMap.get(cacheName);
            if (listenerSet == null) {
                listenerSet = new HashSet<ICacheListener>();
                this.cacheMap.put(cacheName, listenerSet);
            }
            listenerSet.add(obj);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Adding listener to cache watch. ICacheListener = " + obj + " | ICacheObserver = " + this.cacheWatch + " | cacheName = " + cacheName));
        }
        this.cacheWatch.addCacheListener(cacheName, obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCacheListener(ICacheListener obj) throws IOException {
        Map map = this.cacheMap;
        synchronized (map) {
            Iterator itr = this.cacheMap.values().iterator();
            while (itr.hasNext()) {
                Set listenerSet = (Set)itr.next();
                listenerSet.add(obj);
            }
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Adding listener to cache watch. ICacheListener = " + obj + " | ICacheObserver = " + this.cacheWatch));
        }
        this.cacheWatch.addCacheListener(obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCacheListener(String cacheName, ICacheListener obj) throws IOException {
        if (log.isInfoEnabled()) {
            log.info((Object)("removeCacheListener, cacheName [" + cacheName + "]"));
        }
        Map map = this.cacheMap;
        synchronized (map) {
            Set listenerSet = (Set)this.cacheMap.get(cacheName);
            if (listenerSet != null) {
                listenerSet.remove(obj);
            }
        }
        this.cacheWatch.removeCacheListener(cacheName, obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCacheListener(ICacheListener obj) throws IOException {
        if (log.isInfoEnabled()) {
            log.info((Object)("removeCacheListener, ICacheListener [" + obj + "]"));
        }
        Map map = this.cacheMap;
        synchronized (map) {
            Iterator itr = this.cacheMap.values().iterator();
            while (itr.hasNext()) {
                Set listenerSet = (Set)itr.next();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Before removing [" + obj + "] the listenerSet = " + listenerSet));
                }
                listenerSet.remove(obj);
            }
        }
        this.cacheWatch.removeCacheListener(obj);
    }
}

