/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcs.auxiliary.lateral.socket.tcp;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jcs.auxiliary.lateral.LateralCacheInfo;
import org.apache.jcs.auxiliary.lateral.LateralElementDescriptor;
import org.apache.jcs.auxiliary.lateral.behavior.ILateralCacheObserver;
import org.apache.jcs.auxiliary.lateral.behavior.ILateralCacheService;
import org.apache.jcs.auxiliary.lateral.socket.tcp.LateralTCPSender;
import org.apache.jcs.auxiliary.lateral.socket.tcp.TCPLateralCacheAttributes;
import org.apache.jcs.auxiliary.lateral.socket.tcp.behavior.ITCPLateralCacheAttributes;
import org.apache.jcs.engine.CacheElement;
import org.apache.jcs.engine.behavior.ICacheElement;
import org.apache.jcs.engine.behavior.ICacheListener;

public class LateralTCPService
implements ILateralCacheService,
ILateralCacheObserver {
    private static final Log log = LogFactory.getLog((Class)LateralTCPService.class);
    private ITCPLateralCacheAttributes tcpLateralCacheAttributes;
    private LateralTCPSender sender;
    private long listenerId = LateralCacheInfo.listenerId;

    public LateralTCPService(ITCPLateralCacheAttributes lca) throws IOException {
        this.setTcpLateralCacheAttributes(lca);
        try {
            log.debug((Object)("creating sender, attributes = " + this.getTcpLateralCacheAttributes()));
            this.sender = new LateralTCPSender(lca);
            if (log.isInfoEnabled()) {
                log.debug((Object)("Created sender to [" + lca.getTcpServer() + "]"));
            }
        }
        catch (IOException e) {
            log.error((Object)("Could not create sender to [" + lca.getTcpServer() + "] -- " + e.getMessage()));
            throw e;
        }
    }

    public void update(ICacheElement item) throws IOException {
        this.update(item, this.getListenerId());
    }

    public void update(ICacheElement item, long requesterId) throws IOException {
        if (!this.getTcpLateralCacheAttributes().isAllowPut() && !this.getTcpLateralCacheAttributes().isIssueRemoveOnPut()) {
            return;
        }
        if (!this.getTcpLateralCacheAttributes().isIssueRemoveOnPut()) {
            LateralElementDescriptor led = new LateralElementDescriptor(item);
            led.requesterId = requesterId;
            led.command = 1;
            this.sender.send(led);
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Issuing a remove for a put");
            }
            CacheElement ce = new CacheElement(item.getCacheName(), item.getKey(), null);
            LateralElementDescriptor led = new LateralElementDescriptor(ce);
            led.requesterId = requesterId;
            led.command = 2;
            led.valHashCode = item.getVal().hashCode();
            this.sender.send(led);
        }
    }

    public void remove(String cacheName, Serializable key) throws IOException {
        this.remove(cacheName, key, this.getListenerId());
    }

    public void remove(String cacheName, Serializable key, long requesterId) throws IOException {
        CacheElement ce = new CacheElement(cacheName, key, null);
        LateralElementDescriptor led = new LateralElementDescriptor(ce);
        led.requesterId = requesterId;
        led.command = 2;
        this.sender.send(led);
    }

    public void release() throws IOException {
    }

    public void dispose(String cacheName) throws IOException {
        this.sender.dispose(cacheName);
    }

    public Serializable get(String key) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("balking at get for key [" + key + "]"));
        }
        return null;
    }

    public ICacheElement get(String cacheName, Serializable key) throws IOException {
        if (this.getTcpLateralCacheAttributes().isAllowGet()) {
            CacheElement ce = new CacheElement(cacheName, key, null);
            LateralElementDescriptor led = new LateralElementDescriptor(ce);
            led.command = 5;
            Object response = this.sender.sendAndReceive(led);
            if (response != null) {
                return (ICacheElement)response;
            }
            return null;
        }
        return null;
    }

    public Map getMatching(String cacheName, String pattern) throws IOException {
        if (this.getTcpLateralCacheAttributes().isAllowGet()) {
            CacheElement ce = new CacheElement(cacheName, (Serializable)((Object)pattern), null);
            LateralElementDescriptor led = new LateralElementDescriptor(ce);
            led.command = 6;
            Object response = this.sender.sendAndReceive(led);
            if (response != null) {
                return (Map)response;
            }
            return Collections.EMPTY_MAP;
        }
        return null;
    }

    public Map getMultiple(String cacheName, Set keys) throws IOException {
        HashMap<Serializable, ICacheElement> elements = new HashMap<Serializable, ICacheElement>();
        if (keys != null && !keys.isEmpty()) {
            Iterator iterator = keys.iterator();
            while (iterator.hasNext()) {
                Serializable key = (Serializable)iterator.next();
                ICacheElement element = this.get(cacheName, key);
                if (element == null) continue;
                elements.put(key, element);
            }
        }
        return elements;
    }

    public Set getGroupKeys(String cacheName, String group) {
        throw new UnsupportedOperationException("Groups not implemented.");
    }

    public void removeAll(String cacheName) throws IOException {
        this.removeAll(cacheName, this.getListenerId());
    }

    public void removeAll(String cacheName, long requesterId) throws IOException {
        CacheElement ce = new CacheElement(cacheName, (Serializable)((Object)"ALL"), null);
        LateralElementDescriptor led = new LateralElementDescriptor(ce);
        led.requesterId = requesterId;
        led.command = 3;
        this.sender.send(led);
    }

    public static void main(String[] args) {
        try {
            LateralTCPSender sender = new LateralTCPSender(new TCPLateralCacheAttributes());
            boolean notDone = true;
            String message = null;
            BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
            while (notDone) {
                System.out.println("enter mesage:");
                message = br.readLine();
                CacheElement ce = new CacheElement("test", (Serializable)((Object)"test"), (Serializable)((Object)message));
                LateralElementDescriptor led = new LateralElementDescriptor(ce);
                sender.send(led);
            }
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
    }

    public void addCacheListener(String cacheName, ICacheListener obj) throws IOException {
    }

    public void addCacheListener(ICacheListener obj) throws IOException {
    }

    public void removeCacheListener(String cacheName, ICacheListener obj) throws IOException {
    }

    public void removeCacheListener(ICacheListener obj) throws IOException {
    }

    protected void setListenerId(long listernId) {
        this.listenerId = listernId;
    }

    protected long getListenerId() {
        return this.listenerId;
    }

    public void setTcpLateralCacheAttributes(ITCPLateralCacheAttributes tcpLateralCacheAttributes) {
        this.tcpLateralCacheAttributes = tcpLateralCacheAttributes;
    }

    public ITCPLateralCacheAttributes getTcpLateralCacheAttributes() {
        return this.tcpLateralCacheAttributes;
    }
}

