/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcs.auxiliary.remote;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jcs.auxiliary.remote.AbstractRemoteAuxiliaryCache;
import org.apache.jcs.auxiliary.remote.RemoteCacheFactory;
import org.apache.jcs.auxiliary.remote.RemoteCacheMonitor;
import org.apache.jcs.auxiliary.remote.RemoteCacheNoWaitFacade;
import org.apache.jcs.auxiliary.remote.RemoteUtils;
import org.apache.jcs.auxiliary.remote.ZombieRemoteCacheService;
import org.apache.jcs.auxiliary.remote.behavior.IRemoteCacheAttributes;
import org.apache.jcs.auxiliary.remote.behavior.IRemoteCacheListener;
import org.apache.jcs.auxiliary.remote.behavior.IRemoteCacheService;
import org.apache.jcs.engine.stats.StatElement;
import org.apache.jcs.engine.stats.Stats;
import org.apache.jcs.engine.stats.behavior.IStatElement;
import org.apache.jcs.engine.stats.behavior.IStats;

public class RemoteCache
extends AbstractRemoteAuxiliaryCache {
    private static final long serialVersionUID = -5329231850422826460L;
    private static final Log log = LogFactory.getLog((Class)RemoteCache.class);

    public RemoteCache(IRemoteCacheAttributes cattr, IRemoteCacheService remote, IRemoteCacheListener listener) {
        super(cattr, remote, listener);
        RemoteUtils.configureGlobalCustomSocketFactory(this.getRemoteCacheAttributes().getRmiSocketFactoryTimeoutMillis());
    }

    public IStats getStatistics() {
        Stats stats = new Stats();
        stats.setTypeName("Remote Cache No Wait");
        ArrayList<IStatElement> elems = new ArrayList<IStatElement>();
        StatElement se = null;
        se = new StatElement();
        se.setName("Remote Host:Port");
        se.setData(this.getIPAddressForService());
        elems.add(se);
        se = new StatElement();
        se.setName("Remote Type");
        se.setData(this.getRemoteCacheAttributes().getRemoteTypeName() + "");
        elems.add(se);
        if (this.getRemoteCacheAttributes().getRemoteType() == 1) {
            // empty if block
        }
        IStats sStats = super.getStatistics();
        IStatElement[] sSEs = sStats.getStatElements();
        List<IStatElement> sL = Arrays.asList(sSEs);
        elems.addAll(sL);
        IStatElement[] ses = elems.toArray(new StatElement[0]);
        stats.setStatElements(ses);
        return stats;
    }

    protected void handleException(Exception ex, String msg, String eventName) throws IOException {
        String message = "Disabling remote cache due to error: " + msg;
        this.logError(this.cacheName, "", message);
        log.error((Object)message, (Throwable)ex);
        if (this.getRemoteCacheService() == null || !(this.getRemoteCacheService() instanceof ZombieRemoteCacheService)) {
            this.setRemoteCacheService(new ZombieRemoteCacheService(this.getRemoteCacheAttributes().getZombieQueueMaxSize()));
        }
        RemoteCacheMonitor.getInstance().notifyError();
        RemoteCacheNoWaitFacade rcnwf = (RemoteCacheNoWaitFacade)RemoteCacheFactory.getFacades().get(this.getRemoteCacheAttributes().getCacheName());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Initiating failover, rcnf = " + rcnwf));
        }
        if (rcnwf != null && rcnwf.remoteCacheAttributes.getRemoteType() == 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Found facade, calling failover");
            }
            rcnwf.failover(0);
        }
        if (ex instanceof IOException) {
            throw (IOException)ex;
        }
        throw new IOException(ex.getMessage());
    }

    public String toString() {
        return "RemoteCache: " + this.cacheName + " attributes = " + this.getRemoteCacheAttributes();
    }

    public String getEventLoggingExtraInfo() {
        return this.getIPAddressForService();
    }

    protected String getIPAddressForService() {
        String ipAddress = this.getRemoteCacheAttributes().getRemoteHost() + ":" + this.getRemoteCacheAttributes().getRemotePort();
        return ipAddress;
    }
}

