/*
 * Decompiled with CFR 0.152.
 */
package com.fe.client;

import com.fe.client.ClientErrorMgmt;
import com.fe.client.MigrationMgmt;
import com.fe.data.Strategy;
import com.fe.db.ConstructQueryDB;
import com.fe.db.ContractDB;
import com.fe.db.SuperDB;
import com.fe.db.UtilDB;
import com.fe.migrate.historical.HistoricalFundamentalData;
import com.fe.migrate.historical.HistoricalMarketData;
import com.fe.migrate.historical.HistoricalModelData;
import com.fe.migrate.historical.HistoricalSecuritiesData;
import com.fe.migrate.historical.HistoricalStrgyAllocationData;
import com.fe.migrate.historical.HistoricalStrgyContractData;
import com.fe.migrate.historical.HistoricalStrgyIndicatorData;
import com.fe.migrate.historical.HistoricalTankerData;
import com.fe.migrate.historical.HistoricalWeatherData;
import com.fe.util.PasswordService;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.directwebremoting.WebContextFactory;

public class AdminMgmt {
    protected static String LOGGED_IN_ATTRIBUTE = "adminLoggedOn";
    protected static String LOGGED_IN_USERNAME = "adminLoggedUsername";
    public static String DB_USER_PROPERTY_FILE = "dbadmin.properties";
    private HttpServletRequest request = null;
    Logger log = Logger.getLogger(AdminMgmt.class);

    public AdminMgmt(HttpServletRequest httpServletRequest) throws Exception {
        this.request = httpServletRequest;
        String string = (String)this.getRequest().getSession().getAttribute(LOGGED_IN_ATTRIBUTE);
        if (string == null || string.equalsIgnoreCase("true")) {
            // empty if block
        }
    }

    public AdminMgmt() throws Exception {
        String string = (String)this.getRequest().getSession().getAttribute(LOGGED_IN_ATTRIBUTE);
        if (string == null || string.equalsIgnoreCase("true")) {
            // empty if block
        }
    }

    public boolean changePassword(String string, String string2) throws Exception {
        Properties properties = new Properties();
        properties.load(new FileInputStream(DB_USER_PROPERTY_FILE));
        String string3 = PasswordService.getInstance().encrypt(string);
        String string4 = PasswordService.getInstance().encrypt(string2);
        boolean bl = false;
        if (properties.getProperty(this.getLoggedInUser()) != null && properties.getProperty(this.getLoggedInUser().toLowerCase()).equals(string3)) {
            bl = true;
        }
        if (!bl) {
            throw new Exception("Invalid current password");
        }
        properties.setProperty(this.getLoggedInUser(), string4);
        properties.store(new FileOutputStream(DB_USER_PROPERTY_FILE), null);
        return true;
    }

    public Map deleteContract(String string, String string2, String string3) throws Exception {
        try {
            UtilDB utilDB = new SuperDB().getUtilDB(string);
            utilDB.connectDB(string);
            utilDB.deleteContracts(utilDB.connection(), string2, string3);
            Vector vector = utilDB.getUniqueContracts(utilDB.connection(), string2);
            utilDB.closeDB();
            HashMap<String, Vector> hashMap = new HashMap<String, Vector>();
            hashMap.put("contracts", vector);
            return hashMap;
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, "db:" + string + ",fieldtable:" + string2);
            throw exception;
        }
    }

    public Map getFieldDetails(String string, String string2) throws Exception {
        try {
            UtilDB utilDB = new SuperDB().getUtilDB(string);
            utilDB.connectDB(string);
            Vector vector = utilDB.getUniqueContracts(utilDB.connection(), string2);
            utilDB.closeDB();
            HashMap<String, Vector> hashMap = new HashMap<String, Vector>();
            hashMap.put("contracts", vector);
            return hashMap;
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, "db:" + string + ",fieldtable:" + string2);
            throw exception;
        }
    }

    public boolean removeFieldTable(String string, String string2) throws Exception {
        try {
            UtilDB utilDB = new SuperDB().getUtilDB(string);
            utilDB.connectDB(string);
            boolean bl = utilDB.removeFieldTable(utilDB.connection(), string2);
            utilDB.closeDB();
            return bl;
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, "db:" + string + ",fieldtable:" + string2);
            throw exception;
        }
    }

    public boolean renameFieldTable(String string, String string2, String string3) throws Exception {
        try {
            UtilDB utilDB = new SuperDB().getUtilDB(string);
            utilDB.connectDB(string);
            boolean bl = utilDB.renameFieldTable(utilDB.connection(), string2, string3);
            utilDB.closeDB();
            return true;
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, "db:" + string + ",fieldtable:" + string2);
            throw exception;
        }
    }

    public Map getRecords4Commodity(String string, String string2) throws Exception {
        try {
            List list;
            UtilDB utilDB = new SuperDB().getUtilDB(string);
            utilDB.connectDB(string);
            TreeMap<String, Object> treeMap = new TreeMap<String, Object>();
            if (string2 != null && !string2.equals("")) {
                list = utilDB.listAllUniqueFields(utilDB.connection(), string2);
                if (list.size() > 0) {
                    treeMap.put("preview", "true");
                    treeMap.put("ticker", string2);
                }
            } else {
                list = utilDB.listAllUniqueFields(utilDB.connection());
            }
            treeMap.put("data", list);
            treeMap.put("db", new HistoricalStrgyAllocationData(new MigrationMgmt()).getDB());
            utilDB.closeDB();
            return treeMap;
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, "db:" + string + ",commodity:" + string2);
            throw exception;
        }
    }

    public List getRecords4Contracts(String string, String string2, String string3) throws Exception {
        this.log.debug((Object)"getRecords4Contracts() called");
        try {
            UtilDB utilDB = new SuperDB().getUtilDB(string);
            utilDB.connectDB(string);
            List list = utilDB.getRecordCount4Contracts(utilDB.connection(), string2, string3);
            utilDB.closeDB();
            return list;
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, "db:" + string + ",commodity:" + string2);
            throw exception;
        }
    }

    public Vector getCommodityRawData(Map map, String string, String string2, String string3) throws Exception {
        try {
            UtilDB utilDB = new SuperDB().getUtilDB(string);
            utilDB.connectDB(string);
            String string4 = ConstructQueryDB.getConstructQueryDB().constructDateInputQuery(map);
            Vector vector = utilDB.getRawData(string4, utilDB.connection(), string2, string3);
            utilDB.closeDB();
            return vector;
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, "db:" + string + ",commodity:" + string3);
            throw exception;
        }
    }

    public Map getCommodityRawData2(Map map, String string, String string2, String string3) throws Exception {
        try {
            UtilDB utilDB = new SuperDB().getUtilDB(string);
            utilDB.connectDB(string);
            String string4 = ConstructQueryDB.getConstructQueryDB().constructDateInputQuery(map);
            Map map2 = utilDB.getRawData3(string4, utilDB.connection(), string2, string3);
            utilDB.closeDB();
            return map2;
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, "db:" + string + ",commodity:" + string3);
            throw exception;
        }
    }

    public Map getCommodityRawData2Contrat(Map map, String string, String string2, String string3, String string4) throws Exception {
        try {
            UtilDB utilDB = new SuperDB().getUtilDB(string);
            utilDB.connectDB(string);
            String string5 = ConstructQueryDB.getConstructQueryDB().constructDateInputQuery(map);
            Map map2 = utilDB.getRawData2Contract(string5, utilDB.connection(), string2, string3, string4);
            utilDB.closeDB();
            return map2;
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, "db:" + string + ",commodity:" + string4);
            throw exception;
        }
    }

    public boolean addRawData(String string, String string2, String string3, String string4, String string5, String string6) throws Exception {
        try {
            Date date = new SimpleDateFormat("dd/MM/yyyy").parse(string3);
            Strategy strategy = new Strategy();
            strategy.setCdate(date);
            strategy.setName(string6);
            ContractDB contractDB = new SuperDB().getContractDB(string2, string);
            contractDB.connectDB(string);
            if (contractDB.checkSValueFieldTypeExist(contractDB.connection()) && string5 != null && !string5.equals("")) {
                strategy.setSvalue(string5);
                Vector<Strategy> vector = new Vector<Strategy>();
                vector.add(strategy);
                contractDB.addSValRecords(contractDB.connection(), vector);
            } else {
                strategy.setValue(Double.parseDouble(string4));
                Vector<Strategy> vector = new Vector<Strategy>();
                vector.add(strategy);
                contractDB.addRecords(contractDB.connection(), vector);
            }
            contractDB.closeDB();
            return true;
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, null);
            throw exception;
        }
    }

    public int checkTableDataType(String string, String string2) throws Exception {
        ContractDB contractDB = new SuperDB().getContractDB(string2, string);
        try {
            contractDB.connectDB(string);
            boolean bl = contractDB.checkSValueFieldTypeExist(contractDB.connection());
            int n = 0;
            if (bl) {
                n = contractDB.checkSValueField(contractDB.connection()) > 0 ? 3 : 2;
                if (contractDB.countRecords(contractDB.connection()) < 1) {
                    n = 0;
                }
            } else {
                n = 1;
            }
            int n2 = n;
            return n2;
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, null);
            throw exception;
        }
        finally {
            contractDB.closeDB();
        }
    }

    public boolean deleteRawData(String string, String string2, Map map) throws Exception {
        UtilDB utilDB = new SuperDB().getUtilDB(string);
        try {
            this.log.debug((Object)("deleteRawData called, db:" + string + " tablename:" + string2 + " data:" + map));
            utilDB.connectDB(string);
            if (map.get("contract") != null && map.get("cdate1") != null) {
                utilDB.deleteRawData(utilDB.connection(), string2, map);
                this.log.debug((Object)"delete method in utildb exec uted");
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, null);
            throw exception;
        }
        finally {
            utilDB.closeDB();
        }
    }

    public boolean setUpdateRawData(String string, String string2, Map map, Map map2) throws Exception {
        UtilDB utilDB = new SuperDB().getUtilDB(string);
        try {
            this.log.debug((Object)("setUpdateRawData called, db:" + string + " tablename:" + string2 + " old:" + map + " new:" + map2));
            utilDB.connectDB(string);
            if (map.get("contract") != null && map.get("cdate1") != null) {
                utilDB.updateRawData(utilDB.connection(), string2, map, map2);
                this.log.debug((Object)"update method in utildb exec uted");
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, null);
            throw exception;
        }
        finally {
            utilDB.closeDB();
        }
    }

    public boolean removCommodity(String string, String string2) throws Exception {
        try {
            UtilDB utilDB = new SuperDB().getUtilDB(string);
            utilDB.connectDB(string);
            boolean bl = utilDB.removeCommodityAndFields(utilDB.connection(), string2);
            utilDB.closeDB();
            return bl;
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, "db:" + string + ",commodity:" + string2);
            throw exception;
        }
    }

    private String getLoggedInUser() throws Exception {
        return (String)this.getRequest().getSession().getAttribute(LOGGED_IN_USERNAME);
    }

    public Map getMarketDBStruct() throws Exception {
        try {
            TreeMap<String, Cloneable> treeMap = new TreeMap<String, Cloneable>();
            String string = new HistoricalMarketData(new MigrationMgmt()).getDB();
            String string2 = new HistoricalSecuritiesData(new MigrationMgmt()).getDB();
            String string3 = new HistoricalStrgyContractData(new MigrationMgmt()).getDB();
            String string4 = new HistoricalStrgyAllocationData(new MigrationMgmt()).getDB();
            String string5 = new HistoricalStrgyIndicatorData(new MigrationMgmt()).getDB();
            String string6 = new HistoricalFundamentalData(new MigrationMgmt()).getDB();
            String string7 = new HistoricalModelData(new MigrationMgmt()).getDB();
            String string8 = new HistoricalTankerData(new MigrationMgmt()).getDB();
            String string9 = new HistoricalWeatherData(new MigrationMgmt()).getDB();
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put(string, "market_contract_dbpane");
            hashMap.put(string2, "market_security_dbpane");
            hashMap.put(string3, "strategy_dbpane");
            hashMap.put(string4, "strategya_dbpane");
            hashMap.put(string5, "strategyi_dbpane");
            hashMap.put(string6, "fundamental_dbpane");
            hashMap.put(string7, "model_dbpane");
            hashMap.put(string8, "tanker_dbpane");
            hashMap.put(string9, "weather_dbpane");
            treeMap.put("dbpane", hashMap);
            HashMap<String, String> hashMap2 = new HashMap<String, String>();
            hashMap2.put(string, "Market Contracts");
            hashMap2.put(string2, "Market Securities");
            hashMap2.put(string3, "Strategy Contracts");
            hashMap2.put(string4, "Strategy Allocation");
            hashMap2.put(string5, "Strategy Indicator");
            hashMap2.put(string6, "Fundamental");
            hashMap2.put(string7, "Model");
            hashMap2.put(string8, "Tanker");
            hashMap2.put(string9, "Weather");
            treeMap.put("db", hashMap2);
            Vector<String> vector = new Vector<String>();
            vector.add(string2);
            vector.add(string);
            vector.add(string3);
            vector.add(string4);
            vector.add(string5);
            vector.add(string6);
            vector.add(string7);
            vector.add(string8);
            vector.add(string9);
            treeMap.put("order", vector);
            this.log.debug((Object)("order:" + vector));
            return treeMap;
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, null);
            throw exception;
        }
    }

    public Map getNodeInfo(String string) throws Exception {
        TreeMap<String, Object> treeMap = new TreeMap<String, Object>();
        UtilDB utilDB = new SuperDB().getUtilDB(string);
        utilDB.connectDB(string);
        Map map = utilDB.listAllCommoditiesAndFields(utilDB.connection());
        if (map.size() <= 5000) {
            List<Map> list = utilDB.listAllOrphanedAssets(utilDB.connection());
            treeMap.put(string + "_err", list);
        }
        treeMap.put(string, map);
        utilDB.closeDB();
        return treeMap;
    }

    public Map getMarketDBStruct1() throws Exception {
        try {
            TreeMap<String, Object> treeMap = new TreeMap<String, Object>();
            String string = new HistoricalMarketData(new MigrationMgmt()).getDB();
            UtilDB utilDB = new SuperDB().getUtilDB(string);
            utilDB.connectDB(string);
            Map map = utilDB.listAllCommoditiesAndFields(utilDB.connection());
            List<Map> list = utilDB.listAllOrphanedAssets(utilDB.connection());
            treeMap.put(string + "_err", list);
            treeMap.put(string, map);
            utilDB.closeDB();
            utilDB = null;
            this.log.debug((Object)"0");
            String string2 = new HistoricalSecuritiesData(new MigrationMgmt()).getDB();
            utilDB = new SuperDB().getUtilDB(string2);
            utilDB.connectDB(string2);
            Map map2 = utilDB.listAllCommoditiesAndFields(utilDB.connection());
            treeMap.put(string2, map2);
            List<Map> list2 = utilDB.listAllOrphanedAssets(utilDB.connection());
            treeMap.put(string2 + "_err", list2);
            utilDB.closeDB();
            this.log.debug((Object)"1");
            String string3 = new HistoricalStrgyContractData(new MigrationMgmt()).getDB();
            utilDB = new SuperDB().getUtilDB(string3);
            utilDB.connectDB(string3);
            Map map3 = utilDB.listAllCommoditiesAndFields(utilDB.connection());
            treeMap.put(string3, map3);
            List<Map> list3 = utilDB.listAllOrphanedAssets(utilDB.connection());
            treeMap.put(string3 + "_err", list3);
            utilDB.closeDB();
            this.log.debug((Object)"2");
            String string4 = new HistoricalStrgyAllocationData(new MigrationMgmt()).getDB();
            utilDB = new SuperDB().getUtilDB(string4);
            utilDB.connectDB(string4);
            Map map4 = utilDB.listAllCommoditiesAndFields(utilDB.connection());
            treeMap.put(string4, map4);
            List<Map> list4 = utilDB.listAllOrphanedAssets(utilDB.connection());
            treeMap.put(string4 + "_err", list4);
            utilDB.closeDB();
            this.log.debug((Object)"3");
            String string5 = new HistoricalStrgyIndicatorData(new MigrationMgmt()).getDB();
            utilDB = new SuperDB().getUtilDB(string5);
            utilDB.connectDB(string5);
            Map map5 = utilDB.listAllCommoditiesAndFields(utilDB.connection());
            treeMap.put(string5, map5);
            List<Map> list5 = utilDB.listAllOrphanedAssets(utilDB.connection());
            treeMap.put(string5 + "_err", list5);
            utilDB.closeDB();
            this.log.debug((Object)"4");
            String string6 = new HistoricalFundamentalData(new MigrationMgmt()).getDB();
            utilDB = new SuperDB().getUtilDB(string6);
            utilDB.connectDB(string6);
            Map map6 = utilDB.listAllCommoditiesAndFields(utilDB.connection());
            List<Map> list6 = utilDB.listAllOrphanedAssets(utilDB.connection());
            treeMap.put(string6, map6);
            treeMap.put(string6 + "_err", list6);
            utilDB.closeDB();
            utilDB = null;
            this.log.debug((Object)"5");
            String string7 = new HistoricalModelData(new MigrationMgmt()).getDB();
            utilDB = new SuperDB().getUtilDB(string7);
            utilDB.connectDB(string7);
            Map map7 = utilDB.listAllCommoditiesAndFields(utilDB.connection());
            treeMap.put(string7, map7);
            List<Map> list7 = utilDB.listAllOrphanedAssets(utilDB.connection());
            treeMap.put(string7 + "_err", list7);
            utilDB.closeDB();
            this.log.debug((Object)"6");
            String string8 = new HistoricalTankerData(new MigrationMgmt()).getDB();
            utilDB = new SuperDB().getUtilDB(string8);
            utilDB.connectDB(string8);
            Map map8 = utilDB.listAllCommoditiesAndFields(utilDB.connection());
            treeMap.put(string8, map8);
            List<Map> list8 = utilDB.listAllOrphanedAssets(utilDB.connection());
            treeMap.put(string8 + "_err", list8);
            utilDB.closeDB();
            this.log.debug((Object)"7");
            String string9 = new HistoricalWeatherData(new MigrationMgmt()).getDB();
            utilDB = new SuperDB().getUtilDB(string9);
            utilDB.connectDB(string9);
            Map map9 = utilDB.listAllCommoditiesAndFields(utilDB.connection());
            treeMap.put(string9, map9);
            List<Map> list9 = utilDB.listAllOrphanedAssets(utilDB.connection());
            treeMap.put(string9 + "_err", list9);
            utilDB.closeDB();
            this.log.debug((Object)"8");
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put(string, "Market Contracts");
            hashMap.put(string2, "Market Securities");
            hashMap.put(string3, "Strategy Contracts");
            hashMap.put(string4, "Strategy Allocation");
            hashMap.put(string5, "Strategy Indicator");
            hashMap.put(string6, "Fundamental");
            hashMap.put(string7, "Model");
            hashMap.put(string8, "Tanker");
            hashMap.put(string9, "Weather");
            treeMap.put("db", hashMap);
            HashMap<String, String> hashMap2 = new HashMap<String, String>();
            hashMap2.put(string, "market_contract_dbpane");
            hashMap2.put(string2, "market_security_dbpane");
            hashMap2.put(string3, "strategy_dbpane");
            hashMap2.put(string4, "strategya_dbpane");
            hashMap2.put(string5, "strategyi_dbpane");
            hashMap2.put(string6, "fundamental_dbpane");
            hashMap2.put(string7, "model_dbpane");
            hashMap2.put(string8, "tanker_dbpane");
            hashMap2.put(string9, "weather_dbpane");
            treeMap.put("dbpane", hashMap2);
            Vector<String> vector = new Vector<String>();
            vector.add(string2);
            vector.add(string);
            vector.add(string3);
            vector.add(string4);
            vector.add(string5);
            vector.add(string6);
            vector.add(string7);
            vector.add(string8);
            vector.add(string9);
            treeMap.put("order", vector);
            this.log.debug((Object)("order:" + vector));
            return treeMap;
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, null);
            throw exception;
        }
    }

    public Map deleteOrphans(String string) throws Exception {
        UtilDB utilDB = new SuperDB().getUtilDB(string);
        utilDB.connectDB(string);
        utilDB.removeAllOrphanedAssets(utilDB.connection());
        return this.getMarketDBStruct();
    }

    private HttpServletRequest getRequest() throws Exception {
        return this.request == null && WebContextFactory.get() != null ? WebContextFactory.get().getHttpServletRequest() : this.request;
    }
}

