/*
 * Decompiled with CFR 0.152.
 */
package com.fe.db.mariadb;

import com.fe.Config;
import com.fe.data.SchedulerTrigger;
import com.fe.db.GeneralUtilDB;
import com.fe.db.SchedulerDB;
import com.fe.lucene.LuceneCrawler;
import com.fe.lucene.MyIndexer;
import com.fe.lucene.SearchSession;
import com.fe.lucene.TickerIndexRecord;
import com.fe.lucene.TokenCollectorFactory;
import com.fe.p2p.P2PService;
import com.fe.scheduler.ScheduledTask;
import com.fe.scheduler.ScheduledTaskFactory;
import com.fe.scheduler.ScheduledTaskField;
import com.fe.svn.SVNSchedulerCommitInfo;
import com.fe.svn.SVNSync;
import java.net.InetAddress;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import org.apache.log4j.Logger;

public class SchedulerDBMariaDB
extends SchedulerDB {
    private Logger log = Logger.getLogger(SchedulerDBMariaDB.class);

    @Override
    public List listScheduler() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Select a.*,b.folder_name,c.tagname as owner_tag,(select CONCAT(GROUP_CONCAT(cast(tags.tagname as CHAR(8000)) order by tags.tagname SEPARATOR ', '), ', ') from scheduler_tags as st  left outer join tags on tags.id=st.tag_id WHERE st.scheduler_id=a.id ) as stags ");
        stringBuffer.append("FROM scheduler as a ");
        stringBuffer.append("LEFT join scheduler_folder as b on a.folder_id=b.id ");
        stringBuffer.append("left join tags as c on c.id=a.owner_tag_id ");
        stringBuffer.append("WHERE  a.deleted IS NULL OR a.deleted<>1 ");
        stringBuffer.append("ORDER by a.name ");
        PreparedStatement preparedStatement = this.connection().prepareStatement(stringBuffer.toString());
        ResultSet resultSet = preparedStatement.executeQuery();
        Vector<Map<String, Object>> vector = new Vector<Map<String, Object>>();
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n = resultSetMetaData.getColumnCount();
        while (resultSet.next()) {
            vector.add(GeneralUtilDB.resultsetToMap(resultSet));
        }
        resultSet.close();
        preparedStatement.close();
        return vector;
    }

    @Override
    public List listSchedulerTaskUIDJoin() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Select a.*,b.folder_name,c.tagname as owner_tag,(select CONCAT(GROUP_CONCAT(cast(tags.tagname as CHAR(8000)) order by tags.tagname SEPARATOR ', '), ', ') from scheduler_tags as st  left outer join tags on tags.id=st.tag_id   where st.scheduler_id=a.id ) as stags ");
        stringBuffer.append("from scheduler as a ");
        stringBuffer.append("left outer join scheduler_folder as b on a.folder_id=b.id AND a.taskuid = b.taskuid ");
        stringBuffer.append("left outer join tags as c on c.id=a.owner_tag_id ");
        stringBuffer.append("WHERE a.deleted IS NULL OR a.deleted<>1 ");
        stringBuffer.append("order by a.name ");
        PreparedStatement preparedStatement = this.connection().prepareStatement(stringBuffer.toString());
        ResultSet resultSet = preparedStatement.executeQuery();
        Vector<Map<String, Object>> vector = new Vector<Map<String, Object>>();
        while (resultSet.next()) {
            vector.add(GeneralUtilDB.resultsetToMap(resultSet));
        }
        resultSet.close();
        preparedStatement.close();
        return vector;
    }

    @Override
    public void fixSchBrokenFolders() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("update scheduler set folder_id=0 where id in ( select id from ( ");
        stringBuffer.append("select a.id from scheduler as a ");
        stringBuffer.append("left outer join scheduler_folder as f on a.folder_id = f.id and a.taskuid = f.taskuid ");
        stringBuffer.append("where f.folder_name is null and a.folder_id >0 ) temp_table ) ");
        PreparedStatement preparedStatement = this.connection().prepareStatement(stringBuffer.toString());
        preparedStatement.executeUpdate();
        preparedStatement.close();
    }

    @Override
    public List listScheduler(List<String> list) throws Exception {
        String string = "";
        for (String object2 : list) {
            string = string + (string.equals("") ? "'thm-" + object2 + "'" : ",'thm-" + object2 + "'");
        }
        this.log.debug((Object)("thms:" + string));
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Select a.*,b.folder_name,c.tagname as owner_tag,(select CONCAT(GROUP_CONCAT(cast(tags.tagname as CHAR(8000)) order by tags.tagname SEPARATOR ', '), ', ') from scheduler_tags as st  left outer join tags on tags.id=st.tag_id   where st.scheduler_id=a.id ) as stags ");
        stringBuffer.append("from scheduler as a ");
        stringBuffer.append("left outer join scheduler_folder as b on a.folder_id=b.id AND a.taskuid = b.taskuid ");
        stringBuffer.append("left outer join tags as c on c.id=a.owner_tag_id ");
        stringBuffer.append("WHERE (a.deleted IS NULL OR a.deleted<>1 ) ");
        if (!string.equals("")) {
            stringBuffer.append("AND a.id IN(select scheduler_id from scheduler_tags as a1   left outer join tags as a2 on a1.tag_id = a2.id  where a2.tagname in (" + string + ")) ");
        } else {
            stringBuffer.append("AND a.id=0 ");
        }
        stringBuffer.append("order by a.name ");
        this.log.debug((Object)("query:" + stringBuffer.toString()));
        PreparedStatement preparedStatement = this.connection().prepareStatement(stringBuffer.toString());
        ResultSet resultSet = preparedStatement.executeQuery();
        Vector<Map<String, Object>> vector = new Vector<Map<String, Object>>();
        while (resultSet.next()) {
            vector.add(GeneralUtilDB.resultsetToMap(resultSet));
        }
        resultSet.close();
        preparedStatement.close();
        return vector;
    }

    @Override
    public List listTrashedScheduler() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT a.*,IFNULL(TIMESTAMPDIFF(day,date(a.deletedon),now()),7) as deleteddays,b.folder_name,(select CONCAT(GROUP_CONCAT(cast(tags.tagname as CHAR(8000)) order by tags.tagname SEPARATOR ', '), ', ') from scheduler_tags as st  left outer join tags on tags.id=st.tag_id WHERE st.scheduler_id=a.id ) as stags ");
        stringBuffer.append("FROM scheduler as a ");
        stringBuffer.append("LEFT outer join scheduler_folder as b on a.folder_id=b.id ");
        stringBuffer.append("WHERE  a.deleted=1 ");
        stringBuffer.append("ORDER by a.deletedon DESC ");
        PreparedStatement preparedStatement = this.connection().prepareStatement(stringBuffer.toString());
        ResultSet resultSet = preparedStatement.executeQuery();
        Vector<Map<String, Object>> vector = new Vector<Map<String, Object>>();
        while (resultSet.next()) {
            Map<String, Object> map = GeneralUtilDB.resultsetToMap(resultSet);
            Object object = map.get("deletedon");
            if (object != null) {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd-MMM-yyyy HH:mm");
                map.put("deletedon_format", simpleDateFormat.format((Date)object));
            }
            vector.add(map);
        }
        resultSet.close();
        preparedStatement.close();
        return vector;
    }

    @Override
    public List searchScheduler(String string) throws Exception {
        MyIndexer myIndexer = new MyIndexer(LuceneCrawler.INDEX_SCHEDULER);
        SearchSession searchSession = new SearchSession(myIndexer);
        Vector vector = searchSession.results(string, 0);
        if (vector != null && vector.size() > 0) {
            String string2 = "";
            for (String string3 : vector) {
                string2 = string2 + (string2.equals("") ? string3 : "," + string3);
            }
            Vector vector2 = new Vector();
            if (!string2.equals("")) {
                String string3;
                string3 = "Select a.*,b.folder_name from scheduler as a left outer join scheduler_folder as b on a.folder_id=b.id ";
                string3 = string3 + " WHERE a.id IN(" + string2 + ") ";
                string3 = string3 + " AND  (a.deleted IS NULL OR a.deleted<>1) ";
                PreparedStatement preparedStatement = this.connection().prepareStatement(string3);
                ResultSet resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    vector2.add(GeneralUtilDB.resultsetToMap(resultSet));
                }
                resultSet.close();
                preparedStatement.close();
            }
            return vector2;
        }
        return null;
    }

    @Override
    public List listAllTasksByUID(String string) throws Exception {
        String string2 = "SELECT a.*,b.folder_name FROM scheduler AS a LEFT OUTER JOIN scheduler_folder AS b ON a.folder_id=b.id ";
        string2 = string2 + " WHERE a.taskuid=? ";
        string2 = string2 + " AND  (a.deleted IS NULL OR a.deleted<>1) ";
        string2 = string2 + " ORDER BY a.name ";
        PreparedStatement preparedStatement = this.connection().prepareStatement(string2);
        preparedStatement.setString(1, string);
        ResultSet resultSet = preparedStatement.executeQuery();
        Vector<Map<String, Object>> vector = new Vector<Map<String, Object>>();
        while (resultSet.next()) {
            vector.add(GeneralUtilDB.resultsetToMap(resultSet));
        }
        resultSet.close();
        preparedStatement.close();
        return vector;
    }

    @Override
    public Map listSchedulerItem(long l) throws Exception {
        PreparedStatement preparedStatement = this.connection().prepareStatement("SELECT a.*,b.folder_name FROM scheduler AS a LEFT OUTER JOIN scheduler_folder AS b ON a.folder_id=b.id where a.id=? ORDER BY a.name");
        preparedStatement.setLong(1, l);
        ResultSet resultSet = preparedStatement.executeQuery();
        Map<String, Object> map = null;
        if (resultSet.next()) {
            map = GeneralUtilDB.resultsetToMap(resultSet);
        }
        resultSet.close();
        preparedStatement.close();
        return map;
    }

    @Override
    public List folderTasks(int n) throws Exception {
        String string = "Select * from scheduler WHERE folder_id=? ";
        string = string + " AND  (deleted IS NULL OR deleted<>1) ";
        PreparedStatement preparedStatement = this.connection().prepareStatement(string);
        preparedStatement.setInt(1, n);
        ResultSet resultSet = preparedStatement.executeQuery();
        Vector<Map<String, Object>> vector = new Vector<Map<String, Object>>();
        while (resultSet.next()) {
            vector.add(GeneralUtilDB.resultsetToMap(resultSet));
        }
        resultSet.close();
        preparedStatement.close();
        return vector;
    }

    @Override
    public List searchScheduler(String string, int n) throws Exception {
        Vector<Map<String, Object>> vector = new Vector<Map<String, Object>>();
        String string2 = null;
        string2 = string != null && !string.equals("") && n > 0 ? "Select a.*,b.folder_name from scheduler as a left outer join scheduler_folder as b on a.folder_id=b.id WHERE a.name LIKE '%" + string + "%' AND a.id IN(select scheduler_id from scheduler_tags  WHERE tag_id=" + n + ") AND  (a.deleted IS NULL OR a.deleted<>1)" : (string != null && !string.equals("") ? "Select a.*,b.folder_name from scheduler as a left outer join scheduler_folder as b on a.folder_id=b.id WHERE a.name LIKE '%" + string + "%' AND  (a.deleted IS NULL OR a.deleted<>1)" : (n > 0 ? "Select a.*,b.folder_name from scheduler as a left outer join scheduler_folder as b on a.folder_id=b.id WHERE a.id IN(select scheduler_id from scheduler_tags  WHERE tag_id=" + n + ") AND  (a.deleted IS NULL OR a.deleted<>1)" : "Select a.*,b.folder_name from scheduler as a left outer join scheduler_folder as b on a.folder_id=b.id WHERE a.deleted IS NULL OR a.deleted<>1 "));
        PreparedStatement preparedStatement = this.connection().prepareStatement(string2);
        ResultSet resultSet = preparedStatement.executeQuery();
        while (resultSet.next()) {
            vector.add(GeneralUtilDB.resultsetToMap(resultSet));
        }
        resultSet.close();
        preparedStatement.close();
        return vector;
    }

    @Override
    public boolean isNameExisting(String string, int n) throws Exception {
        PreparedStatement preparedStatement = this.connection().prepareStatement("Select * FROM scheduler where name=? AND id<>?");
        preparedStatement.setString(1, string);
        preparedStatement.setInt(2, n);
        ResultSet resultSet = preparedStatement.executeQuery();
        boolean bl = false;
        if (resultSet.next()) {
            bl = true;
        }
        resultSet.close();
        preparedStatement.close();
        return bl;
    }

    @Override
    public List listOfFolders(String string) throws Exception {
        PreparedStatement preparedStatement = null;
        if (string != null) {
            preparedStatement = this.connection().prepareStatement("Select * FROM scheduler_folder where taskuid=? ORDER BY folder_name");
            preparedStatement.setString(1, string);
        } else {
            preparedStatement = this.connection().prepareStatement("Select * FROM scheduler_folder ORDER BY folder_name");
        }
        ResultSet resultSet = preparedStatement.executeQuery();
        Vector<Map<String, Object>> vector = new Vector<Map<String, Object>>();
        while (resultSet.next()) {
            vector.add(GeneralUtilDB.resultsetToMap(resultSet));
        }
        resultSet.close();
        preparedStatement.close();
        return vector;
    }

    @Override
    public List listofMyFolders(List<String> list) throws Exception {
        String string = "";
        for (String object2 : list) {
            string = string + (string.equals("") ? "'thm-" + object2 + "'" : ",'thm-" + object2 + "'");
        }
        Object object3 = "";
        object3 = (String)object3 + "Select * FROM scheduler_folder WHERE id in(select folder_id from scheduler where id in( ";
        object3 = (String)object3 + "  Select scheduler_id from scheduler_tags as a1 ";
        object3 = (String)object3 + "  left outer join tags as a2 on a1.tag_id = a2.id ";
        object3 = string != null && !string.equals("") ? (String)object3 + "  where a2.tagname in (" + string + ") ) " : (String)object3 + " )";
        object3 = (String)object3 + ") ORDER BY folder_name ";
        PreparedStatement preparedStatement = this.connection().prepareStatement((String)object3);
        ResultSet resultSet = preparedStatement.executeQuery();
        Vector<Map<String, Object>> vector = new Vector<Map<String, Object>>();
        while (resultSet.next()) {
            vector.add(GeneralUtilDB.resultsetToMap(resultSet));
        }
        resultSet.close();
        preparedStatement.close();
        return vector;
    }

    @Override
    public String getFolderTaskUID(int n) throws Exception {
        PreparedStatement preparedStatement = null;
        preparedStatement = this.connection().prepareStatement("Select taskuid FROM scheduler_folder where id=?");
        preparedStatement.setInt(1, n);
        ResultSet resultSet = preparedStatement.executeQuery();
        String string = null;
        while (resultSet.next()) {
            string = resultSet.getString("taskuid");
        }
        resultSet.close();
        preparedStatement.close();
        return string;
    }

    @Override
    public void updateTaskFolder(int n, int n2) throws Exception {
        PreparedStatement preparedStatement = this.connection().prepareStatement("update scheduler SET folder_id=? where id=?");
        preparedStatement.setInt(1, n2);
        preparedStatement.setInt(2, n);
        preparedStatement.executeUpdate();
        preparedStatement.close();
        PreparedStatement preparedStatement2 = this.connection().prepareStatement("update scheduler_taskdata SET val=? WHERE field_shortname=? AND scheduler_id=?");
        if (n2 > 0) {
            preparedStatement2.setString(1, n2 + "");
        } else {
            preparedStatement2.setString(1, "");
        }
        preparedStatement2.setString(2, "folder_id");
        preparedStatement2.setInt(3, n);
        preparedStatement2.executeUpdate();
        preparedStatement2.close();
    }

    @Override
    public void updateCallingAnotherScript(int n, int n2) throws Exception {
        PreparedStatement preparedStatement = this.connection().prepareStatement("update scheduler SET calling_another_script=? WHERE id=?");
        preparedStatement.setInt(1, n2);
        preparedStatement.setInt(2, n);
        preparedStatement.executeUpdate();
        preparedStatement.close();
    }

    @Override
    public void moveTasks(String string, int n, String string2, int n2) throws Exception {
        PreparedStatement preparedStatement = this.connection().prepareStatement("update scheduler SET taskuid=?,folder_id=? WHERE taskuid=? AND folder_id=?");
        preparedStatement.setString(1, string);
        preparedStatement.setInt(2, n);
        preparedStatement.setString(3, string2);
        preparedStatement.setInt(4, n2);
        preparedStatement.executeUpdate();
        PreparedStatement preparedStatement2 = this.connection().prepareStatement("update scheduler_taskdata SET val=? WHERE field_shortname='folder_id' AND scheduler_id IN (SELECT id FROM scheduler WHERE folder_id=?)");
        preparedStatement2.setString(1, n + "");
        preparedStatement2.setInt(2, n);
        preparedStatement2.executeUpdate();
        preparedStatement2.close();
        preparedStatement.close();
    }

    @Override
    public void renameFolder(String string, String string2, String string3) throws Exception {
        if (!string2.equals(string3)) {
            this.checkFolderExisting(string, string3);
        }
        PreparedStatement preparedStatement = this.connection().prepareStatement("update scheduler_folder set folder_name=replace(folder_name,?,?)  where (folder_name LIKE ? OR folder_name=?) AND taskuid=?");
        preparedStatement.setString(1, string2);
        preparedStatement.setString(2, string3);
        preparedStatement.setString(3, string2 + "/%");
        preparedStatement.setString(4, string2);
        preparedStatement.setString(5, string);
        preparedStatement.executeUpdate();
        preparedStatement.close();
    }

    @Override
    public void moveItemToRootOrGroup(int n, String string, int n2) throws Exception {
        this.connection().setAutoCommit(false);
        try {
            String string2 = "UPDATE scheduler SET taskuid=?,folder_id=?  WHERE id=?";
            PreparedStatement preparedStatement = this.connection().prepareStatement(string2);
            preparedStatement.setString(1, string);
            preparedStatement.setInt(2, n2);
            preparedStatement.setInt(3, n);
            preparedStatement.executeUpdate();
            PreparedStatement preparedStatement2 = this.connection().prepareStatement("update scheduler_taskdata SET val=? WHERE field_shortname=? AND scheduler_id=?");
            if (n2 > 0) {
                preparedStatement2.setString(1, n2 + "");
            } else {
                preparedStatement2.setString(1, "");
            }
            preparedStatement2.setString(2, "folder_id");
            preparedStatement2.setInt(3, n);
            preparedStatement2.executeUpdate();
            preparedStatement2.close();
            this.connection().commit();
        }
        catch (Exception exception) {
            this.connection().rollback();
            throw exception;
        }
        finally {
            this.connection().setAutoCommit(true);
        }
    }

    @Override
    public ArrayList<Integer> moveItems(String string, String string2, String string3, String string4, String string5) throws Exception {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        if (string3 != null && !string3.equals("") && !string3.endsWith("/")) {
            string3 = string3 + "/";
        }
        if (string5 != null && !string5.equals("") && !string5.endsWith("/")) {
            string5 = string5 + "/";
        }
        this.checkFolderExisting(string4, string5 + string);
        this.connection().setAutoCommit(false);
        try {
            Object object;
            String string6 = "WHERE folder_id IN(SELECT id from scheduler_folder\tWHERE (folder_name LIKE ?\tOR folder_name=?)\tAND taskuid=?)";
            PreparedStatement preparedStatement = this.connection().prepareStatement("SELECT id from scheduler " + string6);
            preparedStatement.setString(1, string3 + string + "/%");
            preparedStatement.setString(2, string3 + string);
            preparedStatement.setString(3, string2);
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                object = resultSet.getInt("id");
                arrayList.add((Integer)object);
            }
            resultSet.close();
            preparedStatement.close();
            object = "UPDATE scheduler SET taskuid=? " + string6;
            PreparedStatement preparedStatement2 = this.connection().prepareStatement((String)object);
            preparedStatement2.setString(1, string4);
            preparedStatement2.setString(2, string3 + string + "/%");
            preparedStatement2.setString(3, string3 + string);
            preparedStatement2.setString(4, string2);
            preparedStatement2.executeUpdate();
            String string7 = "UPDATE scheduler_folder SET folder_name=replace(folder_name,?,?), taskuid=? WHERE (folder_name LIKE ? OR folder_name=?) AND taskuid=?";
            PreparedStatement preparedStatement3 = this.connection().prepareStatement(string7);
            preparedStatement3.setString(1, string3 + string);
            preparedStatement3.setString(2, string5 + string);
            preparedStatement3.setString(3, string4);
            preparedStatement3.setString(4, string3 + string + "/%");
            preparedStatement3.setString(5, string3 + string);
            preparedStatement3.setString(6, string2);
            preparedStatement3.executeUpdate();
            this.connection().commit();
            ArrayList<Integer> arrayList2 = arrayList;
            return arrayList2;
        }
        catch (Exception exception) {
            this.connection().rollback();
            throw exception;
        }
        finally {
            this.connection().setAutoCommit(true);
        }
    }

    @Override
    public void deleteFolder(int n) throws Exception {
        AutoCloseable autoCloseable;
        PreparedStatement preparedStatement;
        block13: {
            PreparedStatement preparedStatement2 = this.connection().prepareStatement("select folder_name,taskuid from scheduler_folder where id=?");
            preparedStatement2.setInt(1, n);
            ResultSet resultSet = preparedStatement2.executeQuery();
            try {
                if (!resultSet.next()) break block13;
                preparedStatement = null;
                autoCloseable = null;
                try {
                    String string = resultSet.getString("folder_name");
                    String string2 = resultSet.getString("taskuid");
                    preparedStatement = this.connection().prepareStatement("select * from scheduler_folder where left(folder_name,length(?))=? AND id<>? AND taskuid=? ");
                    preparedStatement.setString(1, string);
                    preparedStatement.setString(2, string);
                    preparedStatement.setInt(3, n);
                    preparedStatement.setString(4, string2);
                    autoCloseable = preparedStatement.executeQuery();
                    if (autoCloseable.next()) {
                        throw new Exception("You can't delete this folder as it has Sub folder:" + autoCloseable.getString("folder_name") + ". Please delete that first");
                    }
                }
                catch (Exception exception) {
                    throw exception;
                }
                finally {
                    if (autoCloseable != null) {
                        autoCloseable.close();
                    }
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
            }
            catch (Exception exception) {
                throw exception;
            }
            finally {
                resultSet.close();
                preparedStatement2.close();
            }
        }
        preparedStatement = this.connection().prepareStatement("delete from scheduler_folder where id=?");
        preparedStatement.setInt(1, n);
        preparedStatement.executeUpdate();
        autoCloseable = this.connection().prepareStatement("update scheduler SET folder_id=null where folder_id=?");
        autoCloseable.setInt(1, n);
        autoCloseable.executeUpdate();
        autoCloseable.close();
    }

    @Override
    public long addFolder(String string, String string2) throws Exception {
        Object object;
        Object object2;
        this.checkFolderExisting(string, string2);
        long l = 0L;
        if (string2.contains("/")) {
            object2 = string2.split("/");
            object = string2.substring(0, string2.lastIndexOf((String)object2[((String[])object2).length - 1]));
            if (((String)object).contains("/")) {
                object = ((String)object).substring(0, ((String)object).lastIndexOf("/"));
            }
            PreparedStatement preparedStatement = this.connection().prepareStatement("select folder_name from scheduler_folder WHERE folder_name=? AND taskuid=?");
            preparedStatement.setString(1, (String)object);
            preparedStatement.setString(2, string);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (!resultSet.next()) {
                throw new Exception("Parent folder:" + (String)object + " does not exist, Please create parent folder inclusive of all root folders");
            }
        }
        object2 = this.connection().prepareStatement("insert into scheduler_folder(taskuid,folder_name) values(?,?)", 1);
        object2.setString(1, string);
        object2.setString(2, string2);
        object2.executeUpdate();
        object = object2.getGeneratedKeys();
        if (object.next()) {
            l = object.getLong(1);
        }
        object.close();
        object2.close();
        return l;
    }

    private void checkFolderExisting(String string, String string2) throws Exception {
        PreparedStatement preparedStatement = this.connection().prepareStatement("select folder_name from scheduler_folder where  taskuid=? AND folder_name=? ");
        preparedStatement.setString(1, string);
        preparedStatement.setString(2, string2);
        ResultSet resultSet = preparedStatement.executeQuery();
        if (resultSet.next()) {
            resultSet.close();
            throw new Exception("Folder name already existing!");
        }
        resultSet.close();
    }

    @Override
    public void deleteScheduler(int n) throws Exception {
        PreparedStatement preparedStatement = this.connection().prepareStatement("UPDATE scheduler SET deleted=1, deletedon=? WHERE id=?");
        preparedStatement.setTimestamp(1, new Timestamp(new Date().getTime()));
        preparedStatement.setInt(2, n);
        preparedStatement.executeUpdate();
        preparedStatement.close();
    }

    @Override
    public void putBackScheduler(int n) throws Exception {
        PreparedStatement preparedStatement = this.connection().prepareStatement("UPDATE scheduler SET deleted=NULL, deletedon=NULL WHERE id=?");
        preparedStatement.setInt(1, n);
        preparedStatement.executeUpdate();
        preparedStatement.close();
    }

    @Override
    public void purgeScheduler(int n) throws Exception {
        PreparedStatement preparedStatement = this.connection().prepareStatement("delete  from scheduler_taskdata WHERE scheduler_id=?");
        preparedStatement.setInt(1, n);
        preparedStatement.executeUpdate();
        preparedStatement.close();
        PreparedStatement preparedStatement2 = this.connection().prepareStatement("delete  from scheduler_logs WHERE scheduler_id=?");
        preparedStatement2.setInt(1, n);
        preparedStatement2.executeUpdate();
        preparedStatement2.close();
        PreparedStatement preparedStatement3 = this.connection().prepareStatement("delete  from scheduler_queuelogs WHERE scheduler_id=?");
        preparedStatement3.setInt(1, n);
        preparedStatement3.executeUpdate();
        preparedStatement3.close();
        PreparedStatement preparedStatement4 = this.connection().prepareStatement("delete   from scheduler_tags WHERE scheduler_id=?");
        preparedStatement4.setInt(1, n);
        preparedStatement4.executeUpdate();
        preparedStatement4.close();
        PreparedStatement preparedStatement5 = this.connection().prepareStatement("delete   from scheduler WHERE id=?");
        preparedStatement5.setInt(1, n);
        preparedStatement5.executeUpdate();
        preparedStatement5.close();
    }

    @Override
    public Map getScheduler(int n) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Select a.*,b.folder_name,c.tagname as owner_tag,( ");
        stringBuffer.append("  select CONCAT(GROUP_CONCAT(cast(tags.tagname as CHAR(8000)) order by tags.tagname SEPARATOR ', '), ', ') ");
        stringBuffer.append("  from scheduler_tags as st ");
        stringBuffer.append("  left outer join tags on tags.id=st.tag_id ");
        stringBuffer.append("  where st.scheduler_id=a.id ");
        stringBuffer.append(") as stags ");
        stringBuffer.append("FROM scheduler as a ");
        stringBuffer.append("LEFT OUTER JOIN scheduler_folder as b on a.folder_id=b.id left outer join tags as c on c.id=a.owner_tag_id ");
        stringBuffer.append("WHERE a.id=? ");
        PreparedStatement preparedStatement = this.connection().prepareStatement(stringBuffer.toString(), 1007);
        preparedStatement.setInt(1, n);
        ResultSet resultSet = preparedStatement.executeQuery();
        Map<String, Object> map = null;
        if (resultSet.next()) {
            map = GeneralUtilDB.resultsetToMap(resultSet);
        }
        if (map != null) {
            PreparedStatement preparedStatement2 = this.connection().prepareStatement("Select * from scheduler_taskdata WHERE scheduler_id=?", 1007);
            preparedStatement2.setInt(1, n);
            ResultSet resultSet2 = preparedStatement2.executeQuery();
            while (resultSet2.next()) {
                String string = resultSet2.getString("field_shortname");
                String string2 = resultSet2.getString("val");
                map.put(string, string2);
            }
            resultSet2.close();
            preparedStatement2.close();
        }
        resultSet.close();
        preparedStatement.close();
        return map;
    }

    @Override
    public int addSchedulerLog(int n, Date date, Date date2, String string, String string2, String string3) throws Exception {
        PreparedStatement preparedStatement = this.connection().prepareStatement("INSERT INTO scheduler_logs(scheduler_id,start_time,end_time,timezone,status,messages) VALUES(?,?,?,?,?,?)", 1);
        preparedStatement.setInt(1, n);
        preparedStatement.setTimestamp(2, new Timestamp(date.getTime()));
        preparedStatement.setTimestamp(3, new Timestamp(date2.getTime()));
        preparedStatement.setString(4, string);
        preparedStatement.setString(5, string2);
        preparedStatement.setString(6, string3);
        preparedStatement.executeUpdate();
        ResultSet resultSet = preparedStatement.getGeneratedKeys();
        int n2 = 0;
        if (resultSet.next()) {
            n2 = resultSet.getInt(1);
        }
        preparedStatement.close();
        return n2;
    }

    @Override
    public void updateSchedulerLogMsg(int n, String string) throws Exception {
        PreparedStatement preparedStatement = this.connection().prepareStatement("Update scheduler_logs SET messages=? WHERE id=?");
        preparedStatement.setString(1, string);
        preparedStatement.setInt(2, n);
        preparedStatement.executeUpdate();
        preparedStatement.close();
    }

    @Override
    public Map getQueueLog(int n, long l) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("select * from scheduler_queuelogs WHERE scheduler_id=? AND trigger_time=?; ");
        this.connection().setTransactionIsolation(1);
        PreparedStatement preparedStatement = this.connection().prepareStatement(stringBuffer.toString());
        preparedStatement.setInt(1, n);
        preparedStatement.setLong(2, l);
        ResultSet resultSet = preparedStatement.executeQuery();
        this.connection().setTransactionIsolation(4);
        Map<String, Object> map = null;
        if (resultSet.next()) {
            map = GeneralUtilDB.resultsetToMap(resultSet);
        }
        resultSet.close();
        preparedStatement.close();
        return map;
    }

    @Override
    public synchronized List listOfQueueLogs(String string, long l) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        if (string == null) {
            stringBuffer.append("select a.host, a.scheduler_id, a.trigger_time, a.status, a.db_insert, a.db_update, a.db_delete, a.is_triggered, a.start_time, a.end_time, a.db_connection_ids, a.response_code, ");
            stringBuffer.append("cast(c.val as char(200)) as dependencies,b.name,b.calling_another_script,b.taskuid,b.timezone,LENGTH(d.console_message) AS console_message_size from ( ");
            stringBuffer.append("  select host, scheduler_id, trigger_time, status, db_insert, db_update, db_delete, is_triggered, start_time, end_time, db_connection_ids, response_code ");
            stringBuffer.append("  from scheduler_queuelogs ");
            stringBuffer.append("  WHERE ID in ( select id from ( ");
            stringBuffer.append("    select id from scheduler_queuelogs ");
            stringBuffer.append("    where trigger_time<=" + l);
            stringBuffer.append("    order by trigger_time desc limit 0 ) temp_table ");
            stringBuffer.append("  )\tunion all ");
            stringBuffer.append("  select host, scheduler_id, trigger_time, status, db_insert, db_update, db_delete, is_triggered, start_time, end_time, db_connection_ids, response_code ");
            stringBuffer.append("  from scheduler_queuelogs ");
            stringBuffer.append("  where status is null and trigger_time>" + l);
            stringBuffer.append(")  as a ");
            stringBuffer.append("left outer join scheduler as  b on a.scheduler_id=b.id ");
            stringBuffer.append("left outer join scheduler_taskdata as c  on c.scheduler_id=b.id and c.field_shortname ='dependentids' ");
            stringBuffer.append("left outer join scheduler_queuelogs_cmessage as d  on d.scheduler_id =a.scheduler_id and d.trigger_time = a.trigger_time ");
            stringBuffer.append("ORDER BY a.trigger_time asc,a.start_time,a.scheduler_id; ");
        } else {
            stringBuffer.append("select a.host, a.scheduler_id, a.trigger_time, a.status, a.db_insert, a.db_update, a.db_delete, a.is_triggered, a.start_time, a.end_time, a.db_connection_ids, a.response_code, ");
            stringBuffer.append("cast(c.val as char(200)) as dependencies,b.name,b.calling_another_script,b.taskuid,b.timezone,LENGTH(d.console_message) AS console_message_size from ( ");
            stringBuffer.append("  select host, scheduler_id, trigger_time, status, db_insert, db_update, db_delete, is_triggered, start_time, end_time, db_connection_ids, response_code ");
            stringBuffer.append("  from scheduler_queuelogs ");
            stringBuffer.append("  WHERE ID in ( ");
            stringBuffer.append("    select id from scheduler_queuelogs ");
            stringBuffer.append("    where concat(scheduler_id, concat('_',trigger_time) ) IN (" + string + ") and is_triggered<>1 ");
            stringBuffer.append("    AND status IS NULL  ");
            stringBuffer.append("  )\tunion  all ");
            stringBuffer.append("  select host, scheduler_id, trigger_time, status, db_insert, db_update, db_delete, is_triggered, start_time, end_time, db_connection_ids, response_code ");
            stringBuffer.append("  from scheduler_queuelogs ");
            stringBuffer.append("  where status is null and trigger_time>=" + l);
            stringBuffer.append(")  as a ");
            stringBuffer.append("left outer join scheduler as  b  on a.scheduler_id=b.id ");
            stringBuffer.append("left outer join scheduler_taskdata as c  on c.scheduler_id=b.id and c.field_shortname ='dependentids' ");
            stringBuffer.append("left outer join scheduler_queuelogs_cmessage as d on d.scheduler_id =a.scheduler_id and d.trigger_time = a.trigger_time ");
            stringBuffer.append("ORDER BY a.trigger_time asc,a.start_time,a.scheduler_id; ");
        }
        this.log.debug((Object)("query:" + stringBuffer.toString()));
        boolean bl = this.isReadOnly();
        this.setReadOnly(true);
        this.connection().setTransactionIsolation(1);
        PreparedStatement preparedStatement = this.connection().prepareStatement(stringBuffer.toString());
        ResultSet resultSet = preparedStatement.executeQuery();
        this.connection().setTransactionIsolation(4);
        Vector<Map<String, Object>> vector = new Vector<Map<String, Object>>();
        while (resultSet.next()) {
            Map<String, Object> map = GeneralUtilDB.resultsetToMap(resultSet);
            map.remove("inject_code");
            map.remove("executed_code");
            vector.add(map);
        }
        this.setReadOnly(bl);
        resultSet.close();
        preparedStatement.close();
        return vector;
    }

    @Override
    public synchronized Map listOfQueueLog(int n, long l) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("select a.*,b.name,b.taskuid,b.timezone from scheduler_queuelogs  as a ");
        stringBuffer.append("left outer join scheduler as  b on a.scheduler_id=b.id ");
        stringBuffer.append("WHERE a.scheduler_id=? and trigger_time=? ");
        stringBuffer.append("ORDER BY a.trigger_time asc,a.start_time,a.scheduler_id; ");
        this.connection().setTransactionIsolation(1);
        PreparedStatement preparedStatement = this.connection().prepareStatement(stringBuffer.toString());
        preparedStatement.setInt(1, n);
        preparedStatement.setLong(2, l);
        ResultSet resultSet = preparedStatement.executeQuery();
        this.connection().setTransactionIsolation(4);
        Map<String, Object> map = null;
        if (resultSet.next()) {
            map = GeneralUtilDB.resultsetToMap(resultSet);
        }
        resultSet.close();
        preparedStatement.close();
        return map;
    }

    @Override
    public synchronized List listOfLast15Logs(long l, int n) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("select a.*,LENGTH(inject_code) as executed_code_length,LENGTH(inject_code) as inject_code_length,b.*,c.id as error_logid,a.id as qlog_id ");
        stringBuffer.append("from scheduler_queuelogs as a ");
        stringBuffer.append("left join scheduler as b on a.scheduler_id=b.id ");
        stringBuffer.append("left join scheduler_logs as c on a.log_id=c.id AND c.messages is not null ");
        stringBuffer.append("where a.trigger_time<" + l + " AND a.scheduler_id=" + n + " ");
        stringBuffer.append("order by a.trigger_time desc,a.start_time desc limit 50; ");
        this.connection().setTransactionIsolation(1);
        PreparedStatement preparedStatement = this.connection().prepareStatement(stringBuffer.toString());
        ResultSet resultSet = preparedStatement.executeQuery();
        this.connection().setTransactionIsolation(4);
        Vector<Map<String, Object>> vector = new Vector<Map<String, Object>>();
        while (resultSet.next()) {
            Map<String, Object> map = GeneralUtilDB.resultsetToMap(resultSet);
            map.remove("inject_code");
            map.remove("executed_code");
            vector.add(map);
        }
        this.log.debug((Object)"listOfHistoryQueueLogs() called:");
        resultSet.close();
        preparedStatement.close();
        return vector;
    }

    @Override
    public String getConsoleMsg(int n, long l) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Select console_message from scheduler_queuelogs_cmessage WHERE scheduler_id=? and trigger_time=? ");
        this.connection().setTransactionIsolation(1);
        PreparedStatement preparedStatement = this.connection().prepareStatement(stringBuffer.toString());
        preparedStatement.setInt(1, n);
        preparedStatement.setLong(2, l);
        ResultSet resultSet = preparedStatement.executeQuery();
        this.connection().setTransactionIsolation(4);
        String string = null;
        if (resultSet.next()) {
            string = resultSet.getString("console_message");
        }
        resultSet.close();
        preparedStatement.close();
        return string;
    }

    @Override
    public synchronized List listOfHistoryQueueLogs(long l, String string) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("select a.host, a.scheduler_id, a.trigger_time, a.status, a.db_insert, a.db_update, a.db_delete, a.is_triggered, a.start_time, a.end_time, a.db_connection_ids, a.response_code, ");
        stringBuffer.append("LENGTH(a.inject_code) as executed_code_length,LENGTH(a.inject_code) as inject_code_length, ");
        stringBuffer.append("b.timezone, b.taskuid, b.name, ");
        stringBuffer.append("c.id as error_logid,a.id as qlog_id,LENGTH(d.console_message) AS console_message_size ");
        stringBuffer.append("from scheduler_queuelogs as a ");
        stringBuffer.append("left join scheduler as b on a.scheduler_id=b.id ");
        stringBuffer.append("left join scheduler_logs as c on a.log_id=c.id AND c.messages is not null ");
        stringBuffer.append("left join scheduler_queuelogs_cmessage as d on d.scheduler_id =a.scheduler_id and d.trigger_time = a.trigger_time ");
        stringBuffer.append("where a.trigger_time<" + l + " AND " + string + " order by a.trigger_time desc,a.start_time desc,a.scheduler_id; ");
        this.connection().setTransactionIsolation(1);
        PreparedStatement preparedStatement = this.connection().prepareStatement(stringBuffer.toString());
        ResultSet resultSet = preparedStatement.executeQuery();
        this.connection().setTransactionIsolation(4);
        Vector<Map<String, Object>> vector = new Vector<Map<String, Object>>();
        while (resultSet.next()) {
            Map<String, Object> map = GeneralUtilDB.resultsetToMap(resultSet);
            map.remove("inject_code");
            map.remove("executed_code");
            vector.add(map);
        }
        this.log.debug((Object)"listOfHistoryQueueLogs() called:");
        resultSet.close();
        preparedStatement.close();
        return vector;
    }

    @Override
    public void removeQueueLogs(long l, String string) throws Exception {
        if (string != null && !"".equals(string)) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("delete from scheduler_queuelogs ");
            stringBuffer.append("where id in( select * from ( ");
            stringBuffer.append("select sq.id from scheduler_queuelogs  as sq ");
            stringBuffer.append("left outer join scheduler as s on s.id=sq.scheduler_id ");
            stringBuffer.append("where s.taskuid IN (" + string + ") ");
            stringBuffer.append(") table_temp ) AND trigger_time>? ");
            PreparedStatement preparedStatement = this.connection().prepareStatement(stringBuffer.toString());
            preparedStatement.setLong(1, l);
            preparedStatement.executeUpdate();
            preparedStatement.close();
        }
    }

    @Override
    public void removeQueueLog(long l, int n) throws Exception {
        PreparedStatement preparedStatement = this.connection().prepareStatement("DELETE from scheduler_queuelogs WHERE trigger_time>? AND  scheduler_id=?");
        preparedStatement.setLong(1, l);
        preparedStatement.setInt(2, n);
        preparedStatement.executeUpdate();
        preparedStatement.close();
    }

    @Override
    public void updateQueueLogStatus(int n, String string) throws Exception {
        PreparedStatement preparedStatement = this.connection().prepareStatement("UPDATE scheduler_queuelogs SET status=?,log_insertedby=? where id=?");
        preparedStatement.setString(1, string);
        preparedStatement.setString(2, P2PService.getComputerName());
        preparedStatement.setInt(3, n);
        preparedStatement.executeUpdate();
        preparedStatement.close();
    }

    @Override
    public void updateQueueLogStatus(int n, long l, String string) throws Exception {
        PreparedStatement preparedStatement = this.connection().prepareStatement("UPDATE scheduler_queuelogs SET status=?,log_insertedby=? WHERE scheduler_id=? AND trigger_time=?");
        preparedStatement.setString(1, string);
        preparedStatement.setString(2, P2PService.getComputerName());
        preparedStatement.setInt(3, n);
        preparedStatement.setLong(4, l);
        preparedStatement.executeUpdate();
        preparedStatement.close();
    }

    @Override
    public void updateQueueNullStatus(int n, long l, String string) throws Exception {
        PreparedStatement preparedStatement = this.connection().prepareStatement("UPDATE scheduler_queuelogs SET status=? WHERE scheduler_id=? AND trigger_time=? AND  (status is null OR status ='')");
        preparedStatement.setString(1, string);
        preparedStatement.setInt(2, n);
        preparedStatement.setLong(3, l);
        preparedStatement.executeUpdate();
        preparedStatement.close();
    }

    @Override
    public void updateResponseCode(int n, long l, int n2) throws Exception {
        PreparedStatement preparedStatement = this.connection().prepareStatement("UPDATE scheduler_queuelogs SET response_code=? WHERE scheduler_id=? AND trigger_time=?");
        preparedStatement.setInt(1, n2);
        preparedStatement.setInt(2, n);
        preparedStatement.setLong(3, l);
        preparedStatement.executeUpdate();
        preparedStatement.close();
    }

    @Override
    public void updateServerStartEnd(int n, long l, Date date, Date date2) throws Exception {
        PreparedStatement preparedStatement = this.connection().prepareStatement("UPDATE scheduler_queuelogs SET start_time=?,end_time=?,timebyserver=? WHERE scheduler_id=? AND trigger_time=?");
        preparedStatement.setTimestamp(1, new Timestamp(date.getTime()));
        preparedStatement.setTimestamp(2, new Timestamp(date2.getTime()));
        preparedStatement.setInt(3, 1);
        preparedStatement.setInt(4, n);
        preparedStatement.setLong(5, l);
        preparedStatement.executeUpdate();
        preparedStatement.close();
    }

    @Override
    public void updateHostAndStarted(int n, long l, Date date, String string) throws Exception {
        PreparedStatement preparedStatement = this.connection().prepareStatement("UPDATE scheduler_queuelogs SET start_time=?,host=? WHERE scheduler_id=? AND trigger_time=?");
        preparedStatement.setTimestamp(1, new Timestamp(date.getTime()));
        preparedStatement.setString(2, string);
        preparedStatement.setInt(3, n);
        preparedStatement.setLong(4, l);
        preparedStatement.executeUpdate();
        preparedStatement.close();
    }

    @Override
    public String getHostName() throws Exception {
        return InetAddress.getLocalHost().getHostName();
    }

    @Override
    public void updateExecutedCodeQLog(int n, long l, String string) throws Exception {
        String string2 = "UPDATE scheduler_queuelogs SET executed_code=? WHERE scheduler_id=? and trigger_time=?";
        PreparedStatement preparedStatement = this.connection().prepareStatement(string2);
        preparedStatement.setString(1, string);
        preparedStatement.setInt(2, n);
        preparedStatement.setLong(3, l);
        preparedStatement.executeUpdate();
        preparedStatement.close();
    }

    @Override
    public void updateQueueLog(Collection collection, Vector vector) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT  * from scheduler_queuelogs WHERE scheduler_id=? AND trigger_time=? ");
        PreparedStatement preparedStatement = this.connection().prepareStatement(stringBuffer.toString());
        String string = "INSERT INTO scheduler_queuelogs(is_triggered,start_time,end_time,status,log_id,host,log_insertedby,db_insert,db_update,db_delete,inject_code,scheduler_id,trigger_time) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?)";
        String string2 = "UPDATE scheduler_queuelogs SET is_triggered=?,start_time=?,end_time=?,status=?,log_id=?,host=?,log_insertedby=?,db_insert=?,db_update=?,db_delete=?,inject_code=? WHERE scheduler_id=? AND trigger_time=?";
        Number number = null;
        Number number2 = null;
        for (Object object : collection) {
            PreparedStatement preparedStatement2;
            Number number3 = (Number)object.get("scheduler_id");
            Number number4 = (Number)object.get("trigger_time");
            if (number2 == null && number4 != null) {
                number2 = number4;
            }
            if (number == null && number3 != null) {
                number = number3;
            }
            if (number3 == null || number4 == null || number4.longValue() <= 0L || number3.intValue() <= 0) continue;
            PreparedStatement preparedStatement3 = null;
            preparedStatement.setInt(1, number3.intValue());
            preparedStatement.setLong(2, number4.longValue());
            this.connection().setTransactionIsolation(1);
            ResultSet resultSet = preparedStatement.executeQuery();
            this.connection().setTransactionIsolation(4);
            String string3 = (String)object.get("status");
            String string4 = null;
            if (resultSet.next()) {
                preparedStatement3 = this.connection().prepareStatement(string2);
                if (resultSet.getString("status") != null && (string3 == null || string3 != null && string3.equals(""))) {
                    string3 = resultSet.getString("status");
                }
                if (resultSet.getString("inject_code") != null) {
                    string4 = resultSet.getString("inject_code");
                }
            } else {
                preparedStatement3 = this.connection().prepareStatement(string);
            }
            resultSet.close();
            int n = object.get("is_triggered") == null ? 0 : ((Number)object.get("is_triggered")).intValue();
            Date date = (Date)object.get("start_time");
            Date date2 = (Date)object.get("end_time");
            Integer n2 = 0;
            try {
                n2 = (Integer)object.get("log_id");
            }
            catch (Exception exception) {
                // empty catch block
            }
            preparedStatement3.setInt(1, n);
            if (date != null) {
                preparedStatement3.setTimestamp(2, new Timestamp(date.getTime()));
            } else {
                preparedStatement3.setTimestamp(2, null);
            }
            if (date2 != null) {
                preparedStatement3.setTimestamp(3, new Timestamp(date2.getTime()));
            } else {
                preparedStatement3.setTimestamp(3, null);
            }
            preparedStatement3.setString(4, string3);
            if (n2 == null) {
                preparedStatement3.setInt(5, 0);
            } else {
                preparedStatement3.setInt(5, n2);
            }
            String string5 = (String)object.get("host");
            if (string5 != null) {
                preparedStatement3.setString(6, string5);
            } else {
                preparedStatement3.setString(6, null);
            }
            String string6 = P2PService.getComputerName();
            if (string6 != null) {
                preparedStatement3.setString(7, string6);
            } else {
                preparedStatement3.setString(7, null);
            }
            Integer n3 = (Integer)object.get("db_insert");
            if (n3 != null) {
                preparedStatement3.setInt(8, n3);
            } else {
                preparedStatement3.setObject(8, null);
            }
            Integer n4 = (Integer)object.get("db_update");
            if (n4 != null) {
                preparedStatement3.setInt(9, n4);
            } else {
                preparedStatement3.setObject(9, null);
            }
            Integer n5 = (Integer)object.get("db_delete");
            if (n5 != null) {
                preparedStatement3.setInt(10, n5);
            } else {
                preparedStatement3.setObject(10, null);
            }
            String string7 = (String)object.get("inject_code");
            if (string7 != null && !string7.equals("")) {
                preparedStatement3.setString(11, string7);
            } else {
                preparedStatement3.setString(11, string4);
            }
            preparedStatement3.setInt(12, number3.intValue());
            preparedStatement3.setLong(13, number4.longValue());
            preparedStatement3.executeUpdate();
            preparedStatement3.close();
            String string8 = (String)object.get("console_message");
            if (string8 == null) continue;
            PreparedStatement preparedStatement4 = this.connection().prepareStatement("select scheduler_id from scheduler_queuelogs_cmessage where scheduler_id=? and trigger_time=? ");
            preparedStatement4.setInt(1, number3.intValue());
            preparedStatement4.setLong(2, number4.longValue());
            ResultSet resultSet2 = preparedStatement4.executeQuery();
            if (resultSet2.next()) {
                preparedStatement2 = this.connection().prepareStatement("DELETE FROM scheduler_queuelogs_cmessage where scheduler_id=? and trigger_time=? ");
                preparedStatement2.setInt(1, number3.intValue());
                preparedStatement2.setLong(2, number4.longValue());
                preparedStatement2.executeUpdate();
                preparedStatement2.close();
            }
            resultSet2.close();
            preparedStatement4.close();
            preparedStatement2 = this.connection().prepareStatement("INSERT INTO scheduler_queuelogs_cmessage(scheduler_id,trigger_time,console_message) VALUES(?,?,?)");
            preparedStatement2.setInt(1, number3.intValue());
            preparedStatement2.setLong(2, number4.longValue());
            preparedStatement2.setString(3, string8);
            preparedStatement2.executeUpdate();
        }
        preparedStatement.close();
        this.log.debug((Object)("scheduelr_id1:" + number + " connection_ids:" + vector + " trigger_time1:" + number2));
        if (number != null && number.intValue() > 0 && vector != null && vector.size() > 0 && number2 != null && number2.longValue() > 0L) {
            Object object;
            PreparedStatement preparedStatement5 = this.connection().prepareStatement("INSERT INTO scheduler_auditlog(scheduler_id,trigger_time,connection_id) VALUES(?,?,?)");
            object = vector.iterator();
            while (object.hasNext()) {
                preparedStatement5.setInt(1, number.intValue());
                preparedStatement5.setLong(2, number2.longValue());
                preparedStatement5.setString(3, (String)object.next());
                preparedStatement5.executeUpdate();
            }
        }
    }

    @Override
    public Map getDBLogSummary(String string) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("select ");
        stringBuffer.append("  CASE action ");
        stringBuffer.append("    WHEN 'I' THEN 'db_insert' ");
        stringBuffer.append("    WHEN 'D' THEN 'db_delete' ");
        stringBuffer.append("    WHEN 'N' OR 'NU' THEN 'db_update' ");
        stringBuffer.append("  END   as action_t ");
        stringBuffer.append(",count(*) as count_t ");
        stringBuffer.append("from audit_logs.gen_logs ");
        stringBuffer.append("where connection_id IN(" + string + ") ");
        stringBuffer.append("and action<>'O' ");
        stringBuffer.append("group by action ");
        this.log.debug((Object)("~~~getDBLogSummary():query:" + stringBuffer.toString()));
        PreparedStatement preparedStatement = this.connection().prepareStatement(stringBuffer.toString());
        ResultSet resultSet = preparedStatement.executeQuery();
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        while (resultSet.next()) {
            String string2 = resultSet.getString("action_t");
            Integer n = resultSet.getInt("count_t");
            if (string2 == null || n == null) continue;
            hashMap.put(string2, n);
        }
        resultSet.close();
        preparedStatement.close();
        return hashMap;
    }

    @Override
    public Vector getDataLogHistory(int n, long l) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("select ");
        stringBuffer.append("dbase+'_'+tablename+'_'+connection_id as uid, ");
        stringBuffer.append("STR_TO_DATE(cdate,'%d-%m-%Y') as cdate1, ");
        stringBuffer.append("STR_TO_DATE(trans_date,'%d-%m-%Y %H:%i:%s') as trans_date1, ");
        stringBuffer.append("trans_date,tablename,dbase,cdate,contract,val,sval, ");
        stringBuffer.append("case action ");
        stringBuffer.append("when 'O' then 'N1' ");
        stringBuffer.append("else action ");
        stringBuffer.append("end as action_t ");
        stringBuffer.append("from audit_logs.gen_logs ");
        stringBuffer.append("where connection_id IN (select connection_id from bbsync.scheduler_auditlog where scheduler_id=? and trigger_time=?) ");
        stringBuffer.append("order by connection_id,dbase,tablename,trans_date,action_t DESC,contract,cdate,val,sval ");
        PreparedStatement preparedStatement = this.connection().prepareStatement(stringBuffer.toString());
        preparedStatement.setInt(1, n);
        preparedStatement.setLong(2, l);
        Vector<Map<String, Object>> vector = new Vector<Map<String, Object>>();
        ResultSet resultSet = preparedStatement.executeQuery();
        while (resultSet.next()) {
            vector.add(GeneralUtilDB.resultsetToMap(resultSet));
        }
        resultSet.close();
        preparedStatement.close();
        return vector;
    }

    @Override
    public String getLogMessages(int n) throws Exception {
        PreparedStatement preparedStatement = this.connection().prepareStatement("Select messages from scheduler_logs WHERE id=?");
        preparedStatement.setInt(1, n);
        String string = null;
        ResultSet resultSet = preparedStatement.executeQuery();
        while (resultSet.next()) {
            string = resultSet.getString("messages");
        }
        resultSet.close();
        preparedStatement.close();
        return string;
    }

    @Override
    public int toggleActive(int n) throws Exception {
        PreparedStatement preparedStatement = this.connection().prepareStatement("update scheduler set active=CASE active WHEN -1 THEN 0 ELSE -1 END where id=?");
        preparedStatement.setInt(1, n);
        preparedStatement.executeUpdate();
        preparedStatement.close();
        PreparedStatement preparedStatement2 = this.connection().prepareStatement("Select active from scheduler WHERE id=?");
        preparedStatement2.setInt(1, n);
        ResultSet resultSet = preparedStatement2.executeQuery();
        Object var5_5 = null;
        int n2 = 0;
        if (resultSet.next()) {
            n2 = resultSet.getInt("active");
        }
        resultSet.close();
        preparedStatement2.close();
        return n2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public SVNSchedulerCommitInfo addOrUpdateScheduler(int n, Map<String, String> map, String string, String string2, String string3) throws Exception {
        Object object;
        Object object3;
        Object object4;
        Object object5;
        PreparedStatement preparedStatement;
        Integer n2 = null;
        boolean bl = false;
        if (n > 0) {
            bl = true;
            preparedStatement = this.connection().prepareStatement("UPDATE scheduler SET name=?,exp_second=?,exp_minute=?,exp_hour=?,exp_day=?,exp_week=?,exp_month=?,timezone=?,taskuid=?,folder_id=?,calling_another_script=?,owner_tag_id=? WHERE id=?");
        } else {
            preparedStatement = this.connection().prepareStatement("INSERT INTO scheduler(name,exp_second,exp_minute,exp_hour,exp_day,exp_week,exp_month,timezone,taskuid,folder_id,calling_another_script,owner_tag_id,alert_type) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?)", 1);
        }
        preparedStatement.setString(1, map.get("name"));
        preparedStatement.setString(2, map.get("exp_second"));
        preparedStatement.setString(3, map.get("exp_minute"));
        preparedStatement.setString(4, map.get("exp_hour"));
        preparedStatement.setString(5, map.get("exp_day"));
        preparedStatement.setString(6, map.get("exp_week"));
        preparedStatement.setString(7, map.get("exp_month"));
        preparedStatement.setString(8, map.get("timezone"));
        preparedStatement.setString(9, string);
        Integer n3 = 0;
        try {
            n3 = Integer.parseInt(map.get("folder_id"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        preparedStatement.setInt(10, n3);
        int n4 = 0;
        try {
            n4 = Integer.parseInt(map.get("calling_another_script"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        preparedStatement.setInt(11, n4);
        if (map.get("owner_tag_id") != null) {
            try {
                preparedStatement.setInt(12, Integer.parseInt(map.get("owner_tag_id")));
            }
            catch (Exception exception) {
                preparedStatement.setInt(12, 0);
            }
        } else {
            preparedStatement.setInt(12, 0);
        }
        if (bl) {
            preparedStatement.setInt(13, n);
            preparedStatement.executeUpdate();
            object5 = this.connection().prepareStatement("DELETE FROM scheduler_taskdata WHERE scheduler_id=?");
            object5.setInt(1, n);
            object5.executeUpdate();
            object5.close();
            n2 = n;
        } else {
            preparedStatement.setString(13, "email");
            preparedStatement.executeUpdate();
        }
        if (!bl && (object5 = preparedStatement.getGeneratedKeys()).next()) {
            n2 = object5.getInt(1);
        }
        object5 = null;
        if (n2 != null) {
            object4 = new ScheduledTaskFactory().getTask(string);
            object3 = this.connection().prepareStatement("INSERT INTO scheduler_taskdata(field_shortname,val,scheduler_id) VALUES(?,?,?)");
            for (ScheduledTaskField object22 : ((ScheduledTask)object4).listFormFields()) {
                if (map.get(object22.getShortname()) == null || map.get(object22.getShortname()).equals("")) continue;
                object3.setString(1, object22.getShortname());
                object3.setString(2, map.get(object22.getShortname()));
                object3.setInt(3, n2);
                object3.executeUpdate();
                if (!object22.getShortname().equalsIgnoreCase("rscript")) continue;
                object5 = map.get(object22.getShortname());
            }
        }
        object4 = object5;
        if (object5 == null && map.get("plugin_txt") != null) {
            object4 = map.get("plugin_txt");
        }
        object3 = new SVNSchedulerCommitInfo();
        ((SVNSchedulerCommitInfo)object3).setRevision(-1L);
        try {
            if (object4 != null) {
                void var15_23;
                object = Config.getString("svn_user");
                String string4 = Config.getString("svn_pwd");
                Map map2 = this.getSVNUser4WikiUser(string2);
                if (map2 != null && map2.get("svn_username") != null && map2.get("svn_password") != null) {
                    object = (String)map2.get("svn_username");
                    String string5 = (String)map2.get("svn_password");
                }
                SVNSync sVNSync = new SVNSync((String)object, (String)var15_23);
                long l = sVNSync.syncScript(n2, (String)object4, string3);
                ((SVNSchedulerCommitInfo)object3).setRevision(l);
                String string6 = "usr-" + ((String)object).trim().toLowerCase();
                int n5 = this.addIfTagNotExist(string6);
                this.updateLast2UsersTag(n2, n5);
            }
        }
        catch (Exception exception) {
            this.log.error((Object)("Error on SVN sync: ERR:" + exception.getMessage()));
        }
        try {
            object = new TickerIndexRecord();
            ((TickerIndexRecord)object).setTablename(LuceneCrawler.INDEX_SCHEDULER);
            if (TokenCollectorFactory.getTokenCollector((TickerIndexRecord)object) != null) {
                LuceneCrawler luceneCrawler = new LuceneCrawler(LuceneCrawler.INDEX_SCHEDULER);
                luceneCrawler.index(n2 + "");
            }
        }
        catch (Exception exception) {
            this.log.error((Object)("Error while indexing MSG:" + exception.getMessage()));
        }
        ((SVNSchedulerCommitInfo)object3).setScheduler_id(n2);
        return object3;
    }

    @Override
    public boolean updateAlertType(String string, int n) throws Exception {
        Vector vector = new Vector();
        String string2 = "UPDATE scheduler SET alert_type=? WHERE id=?";
        PreparedStatement preparedStatement = this.connection().prepareStatement(string2);
        preparedStatement.setString(1, string);
        preparedStatement.setInt(2, n);
        preparedStatement.executeUpdate();
        preparedStatement.close();
        return true;
    }

    @Override
    public void indexAllSchedulerTasks() throws Exception {
        PreparedStatement preparedStatement = this.connection().prepareStatement("Select id from scheduler");
        ResultSet resultSet = preparedStatement.executeQuery();
        Vector vector = new Vector();
        while (resultSet.next()) {
            int n = resultSet.getInt("id");
            try {
                TickerIndexRecord tickerIndexRecord = new TickerIndexRecord();
                tickerIndexRecord.setTablename(LuceneCrawler.INDEX_SCHEDULER);
                if (TokenCollectorFactory.getTokenCollector(tickerIndexRecord) == null) continue;
                LuceneCrawler luceneCrawler = new LuceneCrawler(LuceneCrawler.INDEX_SCHEDULER);
                luceneCrawler.index(n + "");
            }
            catch (Exception exception) {
                this.log.error((Object)("Error while indexing MSG:" + exception.getMessage()));
            }
        }
        resultSet.close();
        preparedStatement.close();
    }

    @Override
    public List listDependencyList(String string, Date date) throws Exception {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String string2 = "select * from scheduler_queuelogs WHERE scheduler_id IN(" + string + ") AND end_time>='" + simpleDateFormat.format(date) + "' AND is_triggered=1 AND (status='success' OR status='warning') ";
        PreparedStatement preparedStatement = this.connection().prepareStatement(string2);
        ResultSet resultSet = preparedStatement.executeQuery();
        Vector<Map<String, Object>> vector = new Vector<Map<String, Object>>();
        while (resultSet.next()) {
            vector.add(GeneralUtilDB.resultsetToMap(resultSet));
        }
        resultSet.close();
        preparedStatement.close();
        return vector;
    }

    @Override
    public Vector getPeersList() throws Exception {
        String string = "select peername from peerslist";
        PreparedStatement preparedStatement = this.connection().prepareStatement(string);
        ResultSet resultSet = preparedStatement.executeQuery();
        Vector<String> vector = new Vector<String>();
        while (resultSet.next()) {
            String string2 = resultSet.getString("peername");
            vector.add(string2);
        }
        resultSet.close();
        preparedStatement.close();
        return vector;
    }

    @Override
    public List getSingleColData(String string) throws Exception {
        PreparedStatement preparedStatement = this.connection().prepareStatement(string);
        ResultSet resultSet = preparedStatement.executeQuery();
        ArrayList<String> arrayList = new ArrayList<String>();
        while (resultSet.next()) {
            arrayList.add(resultSet.getString(1));
        }
        resultSet.close();
        preparedStatement.close();
        return arrayList;
    }

    @Override
    public Vector getPeersData() throws Exception {
        String string = "select * from peerslist ORDER BY last_online DESC";
        PreparedStatement preparedStatement = this.connection().prepareStatement(string);
        ResultSet resultSet = preparedStatement.executeQuery();
        Vector<Map<String, Object>> vector = new Vector<Map<String, Object>>();
        while (resultSet.next()) {
            vector.add(GeneralUtilDB.resultsetToMap(resultSet));
        }
        resultSet.close();
        preparedStatement.close();
        return vector;
    }

    @Override
    public String getPeerFriendlyName(String string) throws Exception {
        String string2 = "select friendlyname from peerslist WHERE peername=?";
        PreparedStatement preparedStatement = this.connection().prepareStatement(string2);
        preparedStatement.setString(1, string);
        ResultSet resultSet = preparedStatement.executeQuery();
        String string3 = null;
        if (resultSet.next()) {
            string3 = resultSet.getString("friendlyname");
        }
        resultSet.close();
        preparedStatement.close();
        return string3;
    }

    @Override
    public void updatePeersLastOnline(String string, long l) throws Exception {
        Vector vector = new Vector();
        String string2 = "UPDATE peerslist set last_online=? WHERE peername=?";
        PreparedStatement preparedStatement = this.connection().prepareStatement(string2);
        preparedStatement.setLong(1, l);
        preparedStatement.setString(2, string);
        preparedStatement.executeUpdate();
        preparedStatement.close();
    }

    @Override
    public void updatePeersNotes(String string, String string2, String string3, String string4) throws Exception {
        Vector vector = new Vector();
        String string5 = "UPDATE peerslist set notes=?, friendlyname=?,contact_mail=? WHERE peername=?";
        PreparedStatement preparedStatement = this.connection().prepareStatement(string5);
        preparedStatement.setString(1, string2);
        preparedStatement.setString(2, string3);
        preparedStatement.setString(3, string4);
        preparedStatement.setString(4, string);
        preparedStatement.executeUpdate();
        preparedStatement.close();
    }

    @Override
    public void updatePeersToggle(String string, int n, String string2) throws Exception {
        Vector vector = new Vector();
        String string3 = "UPDATE peerslist set active=? WHERE peername=?";
        PreparedStatement preparedStatement = this.connection().prepareStatement(string3);
        preparedStatement.setInt(1, n);
        preparedStatement.setString(2, string);
        preparedStatement.executeUpdate();
        preparedStatement.close();
        int n2 = 1;
        if (n == -1) {
            n2 = 0;
        }
        String string4 = null;
        this.trackPeerAssoHistory(string4, string, n2, string2);
    }

    @Override
    public void updatePeersList(String string) throws Exception {
        Vector vector = new Vector();
        String string2 = "select peername from peerslist where peername=?";
        PreparedStatement preparedStatement = this.connection().prepareStatement(string2);
        preparedStatement.setString(1, string);
        ResultSet resultSet = preparedStatement.executeQuery();
        if (!resultSet.next()) {
            String string3 = "Insert into peerslist(peername) values(?)";
            PreparedStatement preparedStatement2 = this.connection().prepareStatement(string3);
            preparedStatement2.setString(1, string);
            preparedStatement2.executeUpdate();
            preparedStatement2.close();
            System.out.println("++++++++++++++++++++++++++++++++++++++++++SchedulerDBSQL.updatePeersList() called");
        }
        resultSet.close();
        preparedStatement.close();
    }

    @Override
    public Vector getAssociatedPeers(String string) throws Exception {
        PreparedStatement preparedStatement = null;
        preparedStatement = this.connection().prepareStatement("Select peername FROM scheduler_taskpeers where taskuid=?");
        preparedStatement.setString(1, string);
        ResultSet resultSet = preparedStatement.executeQuery();
        Vector<String> vector = new Vector<String>();
        while (resultSet.next()) {
            vector.add(resultSet.getString("peername"));
        }
        resultSet.close();
        preparedStatement.close();
        return vector;
    }

    @Override
    public Vector getAssoAvailablePeers(String string) throws Exception {
        PreparedStatement preparedStatement = null;
        preparedStatement = this.connection().prepareStatement("Select peername FROM scheduler_taskpeers where taskuid=? AND peername not IN (select peername from peerslist where active=-1) ");
        preparedStatement.setString(1, string);
        ResultSet resultSet = preparedStatement.executeQuery();
        Vector<String> vector = new Vector<String>();
        while (resultSet.next()) {
            vector.add(resultSet.getString("peername"));
        }
        resultSet.close();
        preparedStatement.close();
        return vector;
    }

    @Override
    public void setAssociatedPeers(String string, Vector vector) throws Exception {
        PreparedStatement preparedStatement = null;
        preparedStatement = this.connection().prepareStatement("delete FROM scheduler_taskpeers where taskuid=?");
        preparedStatement.setString(1, string);
        preparedStatement.executeUpdate();
        PreparedStatement preparedStatement2 = this.connection().prepareStatement("INSERT INTO scheduler_taskpeers(peername,taskuid) VALUES(?,?)");
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            preparedStatement2.setString(1, (String)iterator.next());
            preparedStatement2.setString(2, string);
            preparedStatement2.executeUpdate();
        }
        preparedStatement.close();
    }

    @Override
    public List getLast50PeerActHistory(String string) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("select a.username,a.taskuid,a.peername,a.action,a.action_datetime ,b.name,c.friendlyname ");
        stringBuffer.append("from scheduler_peers_actionhistory as a ");
        stringBuffer.append("left join scheduler_group as b on a.taskuid=b.taskuid ");
        stringBuffer.append("left join peerslist as c on a.peername = c.peername ");
        stringBuffer.append("where a.peername=? ");
        stringBuffer.append("order by action_datetime desc limit 50 ");
        PreparedStatement preparedStatement = this.connection().prepareStatement(stringBuffer.toString());
        preparedStatement.setString(1, string);
        ResultSet resultSet = preparedStatement.executeQuery();
        ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>();
        while (resultSet.next()) {
            arrayList.add(GeneralUtilDB.resultsetToMap(resultSet));
        }
        resultSet.close();
        preparedStatement.close();
        return arrayList;
    }

    @Override
    public List getLast50TaskActHistory(String string) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("select a.username,a.taskuid,a.peername,a.action,a.action_datetime ,b.name,c.friendlyname ");
        stringBuffer.append("from scheduler_peers_actionhistory as a ");
        stringBuffer.append("left join scheduler_group as b on a.taskuid=b.taskuid ");
        stringBuffer.append("left join peerslist as c on a.peername = c.peername ");
        stringBuffer.append("where a.taskuid=? ");
        stringBuffer.append("order by action_datetime desc limit 50 ");
        PreparedStatement preparedStatement = this.connection().prepareStatement(stringBuffer.toString());
        preparedStatement.setString(1, string);
        ResultSet resultSet = preparedStatement.executeQuery();
        ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>();
        while (resultSet.next()) {
            arrayList.add(GeneralUtilDB.resultsetToMap(resultSet));
        }
        resultSet.close();
        preparedStatement.close();
        return arrayList;
    }

    private void trackPeerAssoHistory(String string, String string2, int n, String string3) throws Exception {
        PreparedStatement preparedStatement = this.connection().prepareStatement("INSERT INTO scheduler_peers_actionhistory(taskuid,peername,action,action_datetime,username) VALUES(?,?,?,?,?)  ");
        preparedStatement.setString(1, string);
        preparedStatement.setString(2, string2);
        preparedStatement.setInt(3, n);
        preparedStatement.setTimestamp(4, new Timestamp(new Date().getTime()));
        preparedStatement.setString(5, string3);
        preparedStatement.executeUpdate();
    }

    @Override
    public void addPeerTaskuid(String string, String string2, String string3) throws Exception {
        PreparedStatement preparedStatement = this.connection().prepareStatement("INSERT INTO scheduler_taskpeers(taskuid, peername) SELECT * FROM (SELECT ?,?) AS table_tmp WHERE NOT EXISTS ( SELECT taskuid, peername FROM scheduler_taskpeers WHERE taskuid = ? and peername = ? ) LIMIT 1 ");
        preparedStatement.setString(1, string);
        preparedStatement.setString(2, string2);
        preparedStatement.setString(3, string);
        preparedStatement.setString(4, string2);
        preparedStatement.executeUpdate();
        preparedStatement.close();
        this.trackPeerAssoHistory(string, string2, 1, string3);
    }

    @Override
    public void deletePeerTaskuid(String string, String string2, String string3) throws Exception {
        PreparedStatement preparedStatement = this.connection().prepareStatement("DELETE FROM scheduler_taskpeers WHERE taskuid = ? AND peername=? ");
        preparedStatement.setString(1, string);
        preparedStatement.setString(2, string2);
        preparedStatement.executeUpdate();
        preparedStatement.close();
        this.trackPeerAssoHistory(string, string2, 0, string3);
    }

    @Override
    public Vector getAllPeerAssociation() throws Exception {
        PreparedStatement preparedStatement = null;
        preparedStatement = this.connection().prepareStatement("Select * FROM scheduler_taskpeers ");
        ResultSet resultSet = preparedStatement.executeQuery();
        Vector<Map<String, Object>> vector = new Vector<Map<String, Object>>();
        while (resultSet.next()) {
            vector.add(GeneralUtilDB.resultsetToMap(resultSet));
        }
        resultSet.close();
        preparedStatement.close();
        return vector;
    }

    @Override
    public Map getLastSuccessfulQLog(int n) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("select a.* from ( ");
        stringBuffer.append("\tselect scheduler_id,max(trigger_datetime) as trigger_datetime ");
        stringBuffer.append("\tfrom scheduler_queuelogs ");
        stringBuffer.append("\tWHERE status='success' AND start_time IS NOT NULL AND  end_time IS NOT NULL AND scheduler_id =" + n);
        stringBuffer.append("\tgroup by scheduler_id ");
        stringBuffer.append(") as b ");
        stringBuffer.append("left outer join scheduler_queuelogs as a on  a.trigger_datetime=b.trigger_datetime and a.scheduler_id=b.scheduler_id; ");
        this.connection().setTransactionIsolation(1);
        PreparedStatement preparedStatement = this.connection().prepareStatement(stringBuffer.toString(), 1007);
        ResultSet resultSet = preparedStatement.executeQuery();
        this.connection().setTransactionIsolation(4);
        Map<String, Object> map = null;
        while (resultSet.next()) {
            map = GeneralUtilDB.resultsetToMap(resultSet);
        }
        resultSet.close();
        preparedStatement.close();
        return map;
    }

    @Override
    public Vector getLastSuccessfulQLogs(Vector vector) throws Exception {
        Object object2;
        String string = null;
        for (Object object2 : vector) {
            string = string == null ? object2 + "" : string + "," + object2;
        }
        Object object3 = "select a.* from (select  scheduler_id,max(trigger_datetime) as trigger_datetime  from scheduler_queuelogs\tWHERE status='success' AND start_time IS NOT NULL AND  end_time IS NOT NULL AND scheduler_id in (" + string + ") ";
        object3 = (String)object3 + "group by scheduler_id ) as b left outer join scheduler_queuelogs as a on  a.trigger_datetime=b.trigger_datetime and a.scheduler_id=b.scheduler_id";
        object2 = this.connection().createStatement();
        ResultSet resultSet = object2.executeQuery((String)object3);
        Vector<Map<String, Object>> vector2 = new Vector<Map<String, Object>>();
        while (resultSet.next()) {
            vector2.add(GeneralUtilDB.resultsetToMap(resultSet));
        }
        resultSet.close();
        object2.close();
        return vector2;
    }

    @Override
    public int addRScript(String string, String string2, int n) throws Exception {
        PreparedStatement preparedStatement = this.connection().prepareStatement("INSERT INTO r_script(name,script,restart) VALUES(?,?,?)", 1);
        preparedStatement.setString(1, string);
        preparedStatement.setString(2, string2);
        preparedStatement.setInt(3, n);
        preparedStatement.executeUpdate();
        ResultSet resultSet = preparedStatement.getGeneratedKeys();
        int n2 = 0;
        if (resultSet.next()) {
            n2 = resultSet.getInt(1);
        }
        resultSet.close();
        preparedStatement.close();
        return n2;
    }

    @Override
    public Map getRScript(int n) throws Exception {
        PreparedStatement preparedStatement = this.connection().prepareStatement("Select name,script,restart FROM r_script where id=?");
        preparedStatement.setInt(1, n);
        ResultSet resultSet = preparedStatement.executeQuery();
        Map<String, Object> map = null;
        if (resultSet.next()) {
            map = GeneralUtilDB.resultsetToMap(resultSet);
        }
        resultSet.close();
        preparedStatement.close();
        return map;
    }

    @Override
    public void addRScriptLog(int n, String string, String string2, Date date, Date date2, String string3) throws Exception {
        PreparedStatement preparedStatement = this.connection().prepareStatement("INSERT INTO r_script_logs(script_id,peer,status,start_time,end_time,message) VALUES(?,?,?,?,?,?)");
        preparedStatement.setInt(1, n);
        preparedStatement.setString(2, string);
        preparedStatement.setString(3, string2);
        preparedStatement.setTimestamp(4, new Timestamp(date.getTime()));
        preparedStatement.setTimestamp(5, new Timestamp(date2.getTime()));
        preparedStatement.setString(6, string3);
        preparedStatement.executeUpdate();
        preparedStatement.close();
    }

    @Override
    public Vector rScriptLast5Logs() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("select a.*,b.name from r_script_logs as a left join r_script as b on a.script_id=b.id ");
        stringBuffer.append("where a.script_id in (select id from (select id from r_script order by id desc limit 5) temp_table) order by a.script_id desc ");
        PreparedStatement preparedStatement = this.connection().prepareStatement(stringBuffer.toString());
        ResultSet resultSet = preparedStatement.executeQuery();
        Vector<Map<String, Object>> vector = new Vector<Map<String, Object>>();
        while (resultSet.next()) {
            Map<String, Object> map = GeneralUtilDB.resultsetToMap(resultSet);
            vector.add(map);
        }
        resultSet.close();
        preparedStatement.close();
        return vector;
    }

    @Override
    public void setGroupOrder(Vector vector) throws Exception {
        PreparedStatement preparedStatement = this.connection().prepareStatement("UPDATE scheduler_group SET disp_order=? WHERE taskuid=?");
        int n = 0;
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            preparedStatement.setInt(1, n++);
            preparedStatement.setString(2, (String)iterator.next());
            preparedStatement.executeUpdate();
        }
    }

    @Override
    public Vector getGroupOrder() throws Exception {
        PreparedStatement preparedStatement = this.connection().prepareStatement("select taskuid FROM scheduler_group ORDER by disp_order");
        ResultSet resultSet = preparedStatement.executeQuery();
        Vector<String> vector = new Vector<String>();
        while (resultSet.next()) {
            vector.add(resultSet.getString("taskuid"));
        }
        resultSet.close();
        preparedStatement.close();
        return vector;
    }

    @Override
    public Vector getAllGroups() throws Exception {
        PreparedStatement preparedStatement = this.connection().prepareStatement("select * FROM scheduler_group ORDER by disp_order");
        ResultSet resultSet = preparedStatement.executeQuery();
        Vector<Map<String, Object>> vector = new Vector<Map<String, Object>>();
        while (resultSet.next()) {
            Map<String, Object> map = GeneralUtilDB.resultsetToMap(resultSet);
            vector.add(map);
        }
        resultSet.close();
        preparedStatement.close();
        return vector;
    }

    @Override
    public Vector getActiveGroups() throws Exception {
        PreparedStatement preparedStatement = this.connection().prepareStatement("select * FROM scheduler_group WHERE active<>-1 ORDER by disp_order ");
        ResultSet resultSet = preparedStatement.executeQuery();
        Vector<Map<String, Object>> vector = new Vector<Map<String, Object>>();
        while (resultSet.next()) {
            Map<String, Object> map = GeneralUtilDB.resultsetToMap(resultSet);
            vector.add(map);
        }
        resultSet.close();
        preparedStatement.close();
        return vector;
    }

    @Override
    public Vector getGroups(String string) throws Exception {
        PreparedStatement preparedStatement = this.connection().prepareStatement("select * FROM scheduler_group WHERE enginetype=? ORDER by disp_order ");
        preparedStatement.setString(1, string);
        ResultSet resultSet = preparedStatement.executeQuery();
        Vector<Map<String, Object>> vector = new Vector<Map<String, Object>>();
        while (resultSet.next()) {
            Map<String, Object> map = GeneralUtilDB.resultsetToMap(resultSet);
            vector.add(map);
        }
        resultSet.close();
        preparedStatement.close();
        return vector;
    }

    @Override
    public void addSchedulerExeLogs(int n, long l, Date date, String string, int n2) throws Exception {
        PreparedStatement preparedStatement = this.connection().prepareStatement("INSERT INTO scheduler_exeplanlogs(scheduler_id,trigger_time,trans_datetime,machine,message,repcode) VALUES(?,?,?,?,?,?)");
        preparedStatement.setInt(1, n);
        preparedStatement.setLong(2, l);
        preparedStatement.setTimestamp(3, new Timestamp(date.getTime()));
        preparedStatement.setString(4, P2PService.getComputerName());
        preparedStatement.setString(5, string);
        preparedStatement.setInt(6, n2);
        preparedStatement.executeUpdate();
        preparedStatement.close();
    }

    @Override
    public boolean execLogsRepcodeExist(int n, long l, int n2) throws Exception {
        boolean bl = false;
        PreparedStatement preparedStatement = this.connection().prepareStatement("select * FROM scheduler_exeplanlogs WHERE scheduler_id=? AND trigger_time=? and repcode=?");
        preparedStatement.setInt(1, n);
        preparedStatement.setLong(2, l);
        preparedStatement.setInt(3, n2);
        ResultSet resultSet = preparedStatement.executeQuery();
        while (resultSet.next()) {
            bl = true;
        }
        resultSet.close();
        preparedStatement.close();
        return bl;
    }

    @Override
    public Vector getSchedulerExeLogs(int n, long l) throws Exception {
        String string = "select trans_datetime, machine, message, repcode FROM scheduler_exeplanlogs WHERE scheduler_id=? AND trigger_time=? ORDER by id";
        PreparedStatement preparedStatement = this.connection().prepareStatement(string);
        preparedStatement.setInt(1, n);
        preparedStatement.setLong(2, l);
        ResultSet resultSet = preparedStatement.executeQuery();
        Vector<Map<String, Object>> vector = new Vector<Map<String, Object>>();
        while (resultSet.next()) {
            Map<String, Object> map = GeneralUtilDB.resultsetToMap(resultSet);
            Timestamp timestamp = (Timestamp)map.get("trans_datetime");
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd-MMM HH:mm:ss");
            map.put("trans_datetime1", simpleDateFormat.format(timestamp));
            vector.add(map);
        }
        resultSet.close();
        preparedStatement.close();
        return vector;
    }

    @Override
    public Vector getTriggerData(int n) throws Exception {
        PreparedStatement preparedStatement = this.connection().prepareStatement("select * FROM scheduler_trigger where scheduler_id=?");
        preparedStatement.setInt(1, n);
        ResultSet resultSet = preparedStatement.executeQuery();
        Vector<Map<String, Object>> vector = new Vector<Map<String, Object>>();
        while (resultSet.next()) {
            Map<String, Object> map = GeneralUtilDB.resultsetToMap(resultSet);
            vector.add(map);
        }
        resultSet.close();
        preparedStatement.close();
        return vector;
    }

    @Override
    public Map getOneRowTriggerData(long l) throws Exception {
        PreparedStatement preparedStatement = this.connection().prepareStatement("select * FROM scheduler_trigger where id=?");
        preparedStatement.setLong(1, l);
        ResultSet resultSet = preparedStatement.executeQuery();
        Map<Object, Object> map = new HashMap();
        if (resultSet.next()) {
            map = GeneralUtilDB.resultsetToMap(resultSet);
        }
        resultSet.close();
        preparedStatement.close();
        return map;
    }

    @Override
    public void setTriggerData(int n, SchedulerTrigger[] schedulerTriggerArray) throws Exception {
        PreparedStatement preparedStatement = this.connection().prepareStatement("DELETE FROM scheduler_trigger where scheduler_id=?");
        preparedStatement.setInt(1, n);
        preparedStatement.executeUpdate();
        preparedStatement.close();
        PreparedStatement preparedStatement2 = this.connection().prepareStatement("INSERT INTO scheduler_trigger(scheduler_id, exp_second,exp_minute,exp_hour,exp_week,exp_day,exp_month,inject_code) VALUES(?,?,?,?,?,?,?,?)");
        for (int i = 0; i < schedulerTriggerArray.length; ++i) {
            preparedStatement2.setInt(1, n);
            preparedStatement2.setString(2, schedulerTriggerArray[i].getExp_second());
            preparedStatement2.setString(3, schedulerTriggerArray[i].getExp_minute());
            preparedStatement2.setString(4, schedulerTriggerArray[i].getExp_hour());
            preparedStatement2.setString(5, schedulerTriggerArray[i].getExp_week());
            preparedStatement2.setString(6, schedulerTriggerArray[i].getExp_day());
            preparedStatement2.setString(7, schedulerTriggerArray[i].getExp_month());
            preparedStatement2.setString(8, schedulerTriggerArray[i].getInject_code());
            preparedStatement2.executeUpdate();
        }
        preparedStatement2.close();
    }

    @Override
    public void addPeerThreadStatus(String string, String string2, String string3, int n, int n2) throws Exception {
        PreparedStatement preparedStatement = this.connection().prepareStatement("INSERT into  peer_queuethreads(peername,queuename,taskuid,allowed_threads,scheduler_id) values(?,?,?,?,?)");
        preparedStatement.setString(1, string);
        preparedStatement.setString(2, string2);
        preparedStatement.setString(3, string3);
        preparedStatement.setInt(4, n);
        preparedStatement.setInt(5, n2);
        preparedStatement.executeUpdate();
        preparedStatement.close();
    }

    @Override
    public void removePeerThreadStatus(String string, int n) throws Exception {
        PreparedStatement preparedStatement = this.connection().prepareStatement("DELETE FROM peer_queuethreads WHERE peername=? AND scheduler_id=?");
        preparedStatement.setString(1, string);
        preparedStatement.setInt(2, n);
        preparedStatement.executeUpdate();
        preparedStatement.close();
    }

    @Override
    public void removeAllPeerThreadStatus(String string) throws Exception {
        PreparedStatement preparedStatement = this.connection().prepareStatement("DELETE FROM peer_queuethreads WHERE peername=?");
        preparedStatement.setString(1, string);
        preparedStatement.executeUpdate();
        preparedStatement.close();
    }

    @Override
    public Vector getAvailablePeers(String string, String string2) throws Exception {
        String string3 = "";
        string3 = string3 + "select peername from peerslist ";
        string3 = string3 + "WHERE peername IN (" + string + ") ";
        string3 = string3 + "AND peername NOT IN ( ";
        string3 = string3 + "  select distinct(peername)  from peer_queuethreads as a ";
        string3 = string3 + "  where queuename IN (select distinct queuename from  peer_queuethreads WHERE taskuid=" + string2 + ") AND peername IN (" + string + ") AND ";
        string3 = string3 + "  a.allowed_threads <= (select count(*) from peer_queuethreads as b where queuename IN (select distinct queuename from  peer_queuethreads WHERE taskuid=" + string2 + ") AND b.peername=a.peername) ";
        string3 = string3 + ") ";
        PreparedStatement preparedStatement = this.connection().prepareStatement(string3);
        ResultSet resultSet = preparedStatement.executeQuery();
        Vector<String> vector = new Vector<String>();
        while (resultSet.next()) {
            vector.add(resultSet.getString("peername"));
        }
        resultSet.close();
        preparedStatement.close();
        return vector;
    }

    @Override
    public long getTimeoutCriteriaInMs(int n) throws Exception {
        String string = "select max(cast((UNIX_TIMESTAMP(end_time)*1000 - UNIX_TIMESTAMP(start_time)*1000) as int)) as maxlast_50 from scheduler_queuelogs where id in (select * from (select id from  scheduler_queuelogs where scheduler_id=? and status='success' order by start_time desc limit 50) temp_table)";
        PreparedStatement preparedStatement = this.connection().prepareStatement(string);
        preparedStatement.setInt(1, n);
        ResultSet resultSet = preparedStatement.executeQuery();
        long l = 0L;
        if (resultSet.next()) {
            l = resultSet.getLong(1);
        }
        return l;
    }

    @Override
    public long getMaxDurationInLast50Exec(int n) throws Exception {
        boolean bl = true;
        long l = 0L;
        int n2 = 0;
        while (bl && n2 < 5) {
            try {
                ++n2;
                bl = false;
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("select max(cast((UNIX_TIMESTAMP(end_time)*1000 - UNIX_TIMESTAMP(start_time)*1000) as int))*2 as maxlast_50 ");
                stringBuffer.append("from scheduler_queuelogs ");
                stringBuffer.append("where id in( ");
                stringBuffer.append("\tselect id from ( ");
                stringBuffer.append("\tselect id from  scheduler_queuelogs ");
                stringBuffer.append("\twhere scheduler_id=? and status='success' order by start_time desc limit 50 ");
                stringBuffer.append("\t) temp_table ");
                stringBuffer.append("); ");
                this.connection().setTransactionIsolation(1);
                PreparedStatement preparedStatement = this.connection().prepareStatement(stringBuffer.toString());
                preparedStatement.setInt(1, n);
                ResultSet resultSet = preparedStatement.executeQuery();
                this.connection().setTransactionIsolation(4);
                if (!resultSet.next()) continue;
                l = resultSet.getLong("maxlast_50");
            }
            catch (SQLException sQLException) {
                this.log.error((Object)("getMaxDurationInLast50Exec(), Error message e:" + sQLException.getMessage()));
                if (sQLException.getMessage().contains("was deadlocked on lock resources with another process")) {
                    this.log.error((Object)("getMaxDurationInLast50Exec(), try " + n2));
                    bl = true;
                    Thread.sleep(50L);
                    continue;
                }
                throw sQLException;
            }
        }
        return l;
    }

    @Override
    public String getOwnerTheme(int n) throws Exception {
        String string = " select b.tagname from scheduler as a left outer join tags as b on b.id=a.owner_tag_id where a.id=?";
        PreparedStatement preparedStatement = this.connection().prepareStatement(string);
        preparedStatement.setInt(1, n);
        ResultSet resultSet = preparedStatement.executeQuery();
        String string2 = null;
        if (resultSet.next()) {
            string2 = resultSet.getString("tagname");
            string2 = string2.replaceAll("thm-", "");
        }
        return string2;
    }

    @Override
    public void updateWikiDone(int n, int n2) throws Exception {
        String string = "UPDATE scheduler set is_wiki_done=? where  id=?";
        PreparedStatement preparedStatement = this.connection().prepareStatement(string);
        preparedStatement.setInt(1, n2);
        preparedStatement.setInt(2, n);
        preparedStatement.executeUpdate();
        preparedStatement.close();
    }

    private void updateLast2UsersTag(int n, int n2) throws Exception {
        String string = "DELETE FROM scheduler_tags WHERE id IN ( select id from ( SELECT st.id FROM scheduler_tags as st ";
        string = string + " LEFT OUTER JOIN tags  on tags.id=st.tag_id ";
        string = string + " WHERE st.id NOT IN( ";
        string = string + "   select st1.id from scheduler_tags as st1 ";
        string = string + "   left outer join tags as t1 on t1.id=st1.tag_id ";
        string = string + "   WHERE LEFT(t1.tagname,4)='usr-' AND st1.scheduler_id=st.scheduler_id ";
        string = string + "   order by st1.id desc ";
        string = string + " ) ";
        string = string + " AND LEFT(tags.tagname,4)='usr-' AND st.scheduler_id=? ) temp_table) ";
        PreparedStatement preparedStatement = this.connection().prepareStatement(string);
        preparedStatement.setInt(1, n);
        preparedStatement.executeUpdate();
        preparedStatement.close();
        PreparedStatement preparedStatement2 = this.connection().prepareStatement("DELETE FROM scheduler_tags WHERE scheduler_id=? AND tag_id=?");
        preparedStatement2.setInt(1, n);
        preparedStatement2.setInt(2, n2);
        preparedStatement2.executeUpdate();
        PreparedStatement preparedStatement3 = this.connection().prepareStatement("INSERT INTO scheduler_tags(scheduler_id,tag_id) VALUES(?,?)");
        preparedStatement3.setInt(1, n);
        preparedStatement3.setInt(2, n2);
        preparedStatement3.executeUpdate();
        preparedStatement3.close();
    }

    @Override
    public int addIfTagNotExist(String string) throws Exception {
        PreparedStatement preparedStatement = this.connection().prepareStatement("select * FROM tags WHERE tagname=?");
        preparedStatement.setString(1, string);
        ResultSet resultSet = preparedStatement.executeQuery();
        int n = 0;
        if (resultSet.next()) {
            n = resultSet.getInt("id");
        } else {
            PreparedStatement preparedStatement2 = this.connection().prepareStatement("insert into tags(tagname) values(?)", 1);
            preparedStatement2.setString(1, string);
            preparedStatement2.executeUpdate();
            ResultSet resultSet2 = preparedStatement2.getGeneratedKeys();
            if (resultSet2.next()) {
                n = resultSet2.getInt(1);
            }
        }
        return n;
    }

    @Override
    public void addTagIds4Task(int n, int n2) throws Exception {
        PreparedStatement preparedStatement = this.connection().prepareStatement("DELETE FROM scheduler_tags WHERE scheduler_id=? and tag_id=?");
        preparedStatement.setInt(1, n);
        preparedStatement.setInt(2, n2);
        preparedStatement.executeUpdate();
        preparedStatement.close();
        PreparedStatement preparedStatement2 = this.connection().prepareStatement("INSERT INTO scheduler_tags(scheduler_id,tag_id) VALUES(?,?)");
        preparedStatement2.setInt(1, n);
        preparedStatement2.setInt(2, n2);
        preparedStatement2.executeUpdate();
        preparedStatement2.close();
    }

    @Override
    public Map getTaskEventActions(int n, long l) throws Exception {
        String string = "select  field_shortname,val from scheduler_taskdata ";
        string = string + " where field_shortname like 'on%' ";
        string = string + " and scheduler_id=? ";
        string = string + " union all ";
        string = string + " select 'status' as field_shortname,status as val from scheduler_queuelogs ";
        string = string + " where scheduler_id=? and trigger_time =? ";
        PreparedStatement preparedStatement = this.connection().prepareStatement(string);
        preparedStatement.setInt(1, n);
        preparedStatement.setInt(2, n);
        preparedStatement.setLong(3, l);
        ResultSet resultSet = preparedStatement.executeQuery();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        while (resultSet.next()) {
            hashMap.put(resultSet.getString(1), resultSet.getString(2));
        }
        return hashMap;
    }

    @Override
    public String getErrorMessageEvenNull(int n, long l) throws Exception {
        String string = "select b.messages from scheduler_queuelogs as a ";
        string = string + "left outer join scheduler_logs as b on a.log_id=b.id ";
        string = string + "where a.status='fail' ";
        string = string + "and a.scheduler_id=? and a.trigger_time=? ";
        PreparedStatement preparedStatement = this.connection().prepareStatement(string);
        preparedStatement.setInt(1, n);
        preparedStatement.setLong(2, l);
        ResultSet resultSet = preparedStatement.executeQuery();
        String string2 = null;
        if (resultSet.next()) {
            string2 = resultSet.getString("messages");
        }
        return string2;
    }

    @Override
    public void pushAlarmMessage(String string, String string2) throws Exception {
        PreparedStatement preparedStatement = this.connection().prepareStatement("INSERT INTO " + string + ".stackAlarms(Date,Message,status) VALUES(NOW(),?,0)");
        preparedStatement.setString(1, string2);
        preparedStatement.executeUpdate();
        preparedStatement.close();
    }

    @Override
    public List getDependsThis(int n) throws Exception {
        String string = "select scheduler_id from scheduler_taskdata where field_shortname='dependentids' AND (val LIKE '" + n + "' OR val LIKE '" + n + ",%' OR val LIKE '%," + n + ",%' OR val LIKE '%," + n + "' )";
        this.log.debug((Object)("query:" + string));
        PreparedStatement preparedStatement = this.connection().prepareStatement(string);
        ResultSet resultSet = preparedStatement.executeQuery();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        while (resultSet.next()) {
            int n2 = resultSet.getInt("scheduler_id");
            arrayList.add(n2);
        }
        return arrayList;
    }

    @Override
    public void addEditLogs(int n, String string, String string2) throws Exception {
        PreparedStatement preparedStatement = this.connection().prepareStatement("INSERT INTO scheduler_editlogs(scheduler_id,username,message,edited_datetime) VALUES(?,?,?,?)");
        preparedStatement.setInt(1, n);
        preparedStatement.setString(2, string);
        preparedStatement.setString(3, string2);
        preparedStatement.setTimestamp(4, new Timestamp(new Date().getTime()));
        preparedStatement.executeUpdate();
        preparedStatement.close();
    }

    @Override
    public List getEditLogs(int n) throws Exception {
        ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>();
        String string = "select * from scheduler_editlogs where scheduler_id=?";
        PreparedStatement preparedStatement = this.connection().prepareStatement(string);
        preparedStatement.setInt(1, n);
        ResultSet resultSet = preparedStatement.executeQuery();
        while (resultSet.next()) {
            arrayList.add(GeneralUtilDB.resultsetToMap(resultSet));
        }
        resultSet.close();
        preparedStatement.close();
        return arrayList;
    }

    @Override
    public String getInjectCode4QLog(String string) throws Exception {
        String string2 = "select inject_code from scheduler_queuelogs where concat(scheduler_id, concat('_',trigger_time) )=?";
        PreparedStatement preparedStatement = this.connection().prepareStatement(string2);
        preparedStatement.setString(1, string);
        ResultSet resultSet = preparedStatement.executeQuery();
        String string3 = null;
        if (resultSet.next()) {
            string3 = resultSet.getString("inject_code");
        }
        return string3;
    }

    @Override
    public void updateTimeoutSettings(Map map) throws Exception {
        PreparedStatement preparedStatement = this.connection().prepareStatement("DELETE FROM scheduler_timeout_settings where ky=?");
        PreparedStatement preparedStatement2 = this.connection().prepareStatement("INSERT INTO scheduler_timeout_settings(ky,val) VALUES(?,?)");
        for (String string : map.keySet()) {
            String string2 = (String)map.get(string);
            preparedStatement.setString(1, string);
            preparedStatement.executeUpdate();
            preparedStatement2.setString(1, string);
            preparedStatement2.setString(2, string2);
            preparedStatement2.executeUpdate();
        }
    }

    @Override
    public Map getTimeoutSettings() throws Exception {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        PreparedStatement preparedStatement = this.connection().prepareStatement("SELECT * FROM scheduler_timeout_settings");
        ResultSet resultSet = preparedStatement.executeQuery();
        while (resultSet.next()) {
            hashMap.put(resultSet.getString("ky"), resultSet.getString("val"));
        }
        return hashMap;
    }

    @Override
    public ArrayList getLast10minuteSuspectedFailure() throws Exception {
        ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("select a.trigger_time,a.scheduler_id from scheduler_exeplanlogs as a ");
        stringBuffer.append("left outer join scheduler_queuelogs as b on ( a.scheduler_id = b.scheduler_id and a.trigger_time = b.trigger_time) ");
        stringBuffer.append("where a.trans_datetime between DATE_ADD(NOW(), interval -20 minute) and DATE_ADD(NOW(), interval -10 minute) ");
        stringBuffer.append(" and (b.status is null) ");
        stringBuffer.append(" order by trans_datetime desc ");
        PreparedStatement preparedStatement = this.connection().prepareStatement(stringBuffer.toString());
        ResultSet resultSet = preparedStatement.executeQuery();
        while (resultSet.next()) {
            arrayList.add(GeneralUtilDB.resultsetToMap(resultSet));
        }
        resultSet.close();
        preparedStatement.close();
        return arrayList;
    }

    @Override
    public boolean isAnyExecLogsInLast3Mins(int n, long l) throws Exception {
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("select count(*) ct from scheduler_exeplanlogs ");
        stringBuffer.append("WHERE trans_datetime > DATE_ADD(NOW(), interval -3 minute) AND scheduler_id=? AND trigger_time=? ");
        PreparedStatement preparedStatement = this.connection().prepareStatement(stringBuffer.toString());
        preparedStatement.setInt(1, n);
        preparedStatement.setLong(2, l);
        ResultSet resultSet = preparedStatement.executeQuery();
        while (resultSet.next()) {
            bl = resultSet.getInt("ct") > 0;
        }
        return bl;
    }

    @Override
    public ArrayList getPeersList4Engine(List<String> list) throws Exception {
        String string = "";
        for (String object2 : list) {
            string = string + (string.equals("") ? "'" + object2 + "'" : ",'" + object2 + "'");
        }
        Object object3 = "select * from peerslist ";
        object3 = (String)object3 + " where peername in( ";
        object3 = (String)object3 + " select distinct peername from scheduler_taskpeers ";
        object3 = (String)object3 + " where taskuid in(select taskuid from scheduler_group where enginetype IN (" + string + ")) ";
        object3 = (String)object3 + " ) ";
        PreparedStatement preparedStatement = this.connection().prepareStatement((String)object3);
        ResultSet resultSet = preparedStatement.executeQuery();
        ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>();
        while (resultSet.next()) {
            arrayList.add(GeneralUtilDB.resultsetToMap(resultSet));
        }
        return arrayList;
    }

    @Override
    public void userPrefSaveOrUpdate(String string, String string2, String string3) throws Exception {
        PreparedStatement preparedStatement = this.connection().prepareStatement("DELETE FROM user_preference WHERE login=? AND ky=?");
        preparedStatement.setString(1, string);
        preparedStatement.setString(2, string2);
        preparedStatement.executeUpdate();
        this.log.debug((Object)"after deleting..");
        if (string3 != null) {
            PreparedStatement preparedStatement2 = this.connection().prepareStatement("INSERT INTO user_preference(login,ky,val) VALUES(?,?,?)");
            preparedStatement2.setString(1, string);
            preparedStatement2.setString(2, string2);
            preparedStatement2.setString(3, string3);
            preparedStatement2.executeUpdate();
            this.log.debug((Object)"after inserting..");
        }
    }

    @Override
    public Map userPrefGetAll(String string) throws Exception {
        PreparedStatement preparedStatement = this.connection().prepareStatement("SELECT ky,val FROM user_preference where login=?");
        preparedStatement.setString(1, string);
        ResultSet resultSet = preparedStatement.executeQuery();
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        while (resultSet.next()) {
            treeMap.put(resultSet.getString("ky"), resultSet.getString("val").toString());
        }
        resultSet.close();
        preparedStatement.close();
        return treeMap;
    }

    @Override
    public List getAutoCompleteXHR(String string) throws Exception {
        String string2 = null;
        if (string.contains(":") && string.split(":").length > 1) {
            string2 = string.split(":")[0];
            string = string.split(":")[1];
        }
        if (string.contains(":") && string.split(":").length == 1) {
            string2 = string.split(":")[0];
            string = null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("select a.name,a.id,b.folder_name,c.name as group_name,d.edited_datetime,d.username, c.icon, ");
        stringBuffer.append("(select CONCAT(GROUP_CONCAT(cast(tags.tagname as CHAR(8000)) order by tags.tagname SEPARATOR ', '), ', ') from scheduler_tags as st ");
        stringBuffer.append("left outer join tags on tags.id=st.tag_id ");
        stringBuffer.append("WHERE st.scheduler_id=a.id ");
        stringBuffer.append(") as stags ");
        stringBuffer.append("from scheduler as a ");
        stringBuffer.append("left outer join scheduler_folder as b on a.folder_id=b.id ");
        stringBuffer.append("left outer join scheduler_group as c on a.taskuid=c.taskuid ");
        stringBuffer.append("left outer join scheduler_editlogs as d on d.scheduler_id=a.id AND d.id = ");
        stringBuffer.append("(select dd.id from scheduler_editlogs as dd where dd.scheduler_id= a.id order by dd.edited_datetime DESC limit 1) ");
        stringBuffer.append("where ( (a.deleted is null OR a.deleted<>1) and c.active>=0 ) ");
        if (string != null) {
            stringBuffer.append("and(a.name like '%" + string + "%' OR cast(a.id as char(10)) like '%" + string + "%' ) ");
        }
        if (string2 != null) {
            stringBuffer.append("AND a.id in (select scheduler_id from scheduler_tags left outer join tags on scheduler_tags.tag_id = tags.id where tags.tagname='thm-" + string2.trim() + "' )");
        }
        stringBuffer.append("ORDER BY d.edited_datetime DESC ");
        PreparedStatement preparedStatement = this.connection().prepareStatement(stringBuffer.toString());
        ResultSet resultSet = preparedStatement.executeQuery();
        ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>();
        while (resultSet.next()) {
            arrayList.add(GeneralUtilDB.resultsetToMap(resultSet));
        }
        return arrayList;
    }

    @Override
    public List getFailedLast2Days(List<String> list) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        for (String charSequence2 : list) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append("'").append(charSequence2).append("'");
        }
        String string = stringBuffer.toString();
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer2.append("select count(*) as num_failed,scheduler_id,b.name as name,status,max(trigger_time) as last_trigger from  scheduler_queuelogs as a ");
        stringBuffer2.append("LEFT JOIN scheduler as b on a.scheduler_id=b.id WHERE scheduler_id IN ");
        stringBuffer2.append("( select scheduler_id FROM scheduler_tags WHERE tag_id IN ");
        stringBuffer2.append("  (select id from tags WHERE tagname in (" + (String)string + ")) ");
        stringBuffer2.append(") AND trigger_datetime>=DATE_ADD(NOW(), INTERVAL -2 DAY) ");
        stringBuffer2.append("AND a.status IS NOT NULL AND a.status NOT IN ('success','overlapped','warning','re-executed') ");
        stringBuffer2.append("GROUP BY scheduler_id,b.name,status ");
        stringBuffer2.append("ORDER BY max(trigger_time) desc ");
        PreparedStatement preparedStatement = this.connection().prepareStatement(stringBuffer2.toString());
        ResultSet resultSet = preparedStatement.executeQuery();
        ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>();
        while (resultSet.next()) {
            arrayList.add(GeneralUtilDB.resultsetToMap(resultSet));
        }
        return arrayList;
    }

    @Override
    public String getTop20IdNameByNameQuery(String string) throws Exception {
        return "SELECT concat(concat(cast(id as char(10)),'|'),name) from scheduler where name like '%" + string + "%' limit 20";
    }

    @Override
    public String getTop20IdNameByIdQuery(String string) throws Exception {
        return "SELECT concat(concat(cast(id as char(10)),'|'),name) from scheduler where cast(id as char(10)) like '%" + string + "%' limit 20";
    }

    @Override
    public String getHistoryQueueLogsDateQuery(long l, String string) {
        return " a.trigger_datetime>=DATE_ADD(NOW(), interval -2 day) AND a.scheduler_id=" + l + " AND a.status='" + string + "'";
    }
}

