/*
 * Decompiled with CFR 0.152.
 */
package com.fe.p2p.listener;

import com.fe.p2p.MessageBean;
import com.fe.p2p.listener.IncomingMessageCallBack;
import com.fe.p2p.listener.IncomingMessageParser;
import com.fe.p2p.msg.MessageNames;
import com.fe.p2p.msg.ReceiveMessage;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.MessageElement;
import net.jxta.pipe.PipeMsgEvent;
import net.jxta.pipe.PipeMsgListener;
import org.apache.commons.digester.Digester;
import org.apache.jcs.JCS;
import org.apache.jcs.engine.behavior.IElementAttributes;
import org.apache.log4j.Logger;

public class IncomingMessage
implements PipeMsgListener {
    private IncomingMessageCallBack imi = null;
    private Logger log = Logger.getLogger(IncomingMessage.class);
    public static final String MESSAGE_NAME_SPACE = "PipeTaskMsg";
    protected static Vector<MessageBean> messages = new Vector();
    private static JCS cachedPeers = null;
    protected static Map<String, Integer> executingpeers = Collections.synchronizedMap(new TreeMap());
    protected static Map<String, Map> executingpeerstime = Collections.synchronizedMap(new TreeMap());
    protected static TreeMap<String, String> cachedStatistics = new TreeMap();
    protected static TreeMap<String, String> cachedRPackages = new TreeMap();
    protected static TreeMap<String, String> cachedPeerQueueStat = new TreeMap();
    public static int ACTION_PEER_ADD = 1;
    public static int ACTION_PEER_REMOVE = 0;
    public static int ACTION_PEER_REMOVEALL = -1;
    private static JCS cachedPeerResp4Task = null;

    public IncomingMessage(IncomingMessageCallBack incomingMessageCallBack) {
        this.imi = incomingMessageCallBack;
    }

    public void pipeMsgEvent(PipeMsgEvent pipeMsgEvent) {
        block14: {
            this.log.debug((Object)"message received...");
            try {
                Object object;
                Message message;
                if (this.imi != null) {
                    this.imi.before(pipeMsgEvent);
                }
                try {
                    message = pipeMsgEvent.getMessage();
                    if (message == null) {
                        this.log.error((Object)"message is null");
                        return;
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    return;
                }
                Message.ElementIterator elementIterator = message.getMessageElements();
                if (!elementIterator.hasNext()) {
                    this.log.error((Object)"en has no elements");
                    return;
                }
                MessageElement messageElement = message.getMessageElement(null, MESSAGE_NAME_SPACE);
                MessageBean messageBean = null;
                String string = messageElement.toString();
                try {
                    messageBean = this.parseMessage(string);
                    this.log.debug((Object)("message from :" + messageBean.getSender() + " msg:" + messageBean.getCommand()));
                }
                catch (Exception exception) {
                    this.log.error((Object)("Error 1:" + exception.getMessage()));
                }
                if (this.imi != null) {
                    this.imi.after(pipeMsgEvent);
                }
                if (messageBean == null) break block14;
                HashMap<String, String> hashMap = new HashMap<String, String>();
                while (elementIterator.hasNext()) {
                    object = elementIterator.next();
                    if (object.getElementName().equals(MESSAGE_NAME_SPACE)) continue;
                    hashMap.put(object.getElementName(), object.toString());
                }
                try {
                    if (hashMap.get(MessageNames.MESSAGE_BEAN_NAME) != null) {
                        new ReceiveMessage(hashMap).process();
                        break block14;
                    }
                    object = new IncomingMessageParser(messageBean, messageElement);
                    ((IncomingMessageParser)object).setAttachement(hashMap);
                    ((IncomingMessageParser)object).parse();
                }
                catch (Exception exception) {
                    this.log.error((Object)("Error while msg:" + messageElement.toString() + " Error:" + exception.getMessage()));
                }
            }
            catch (Exception exception) {
                this.log.error((Object)("Error while parsing or getting data:" + exception.getMessage()));
                exception.printStackTrace();
            }
        }
    }

    public static Vector<MessageBean> getMessages() {
        return messages;
    }

    private MessageBean parseMessage(String string) throws Exception {
        Digester digester = new Digester();
        digester.setValidating(false);
        digester.addObjectCreate("message", MessageBean.class);
        digester.addBeanPropertySetter("message/type");
        digester.addBeanPropertySetter("message/command");
        digester.addBeanPropertySetter("message/sender");
        digester.addBeanPropertySetter("message/reply");
        MessageBean messageBean = (MessageBean)digester.parse((Reader)new StringReader(string));
        return messageBean;
    }

    public static synchronized void peersUpdate(String string, String string2) {
        try {
            if (cachedPeers == null) {
                cachedPeers = JCS.getInstance((String)"cachedPeers$$");
            }
            IElementAttributes iElementAttributes = cachedPeers.getDefaultElementAttributes();
            iElementAttributes.setMaxLifeSeconds(4L);
            cachedPeers.put((Object)string, (Object)string2, iElementAttributes);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static synchronized void updateExecutingPeers(String string, String string2, int n) {
        if (string2.equalsIgnoreCase("BUSY") && n > 0) {
            executingpeers.put(string, n);
        }
        if (string2.equalsIgnoreCase("NOBUSY")) {
            executingpeers.remove(string);
        }
    }

    public static synchronized void updateExecutingPeersTime(String string, String string2, int n, long l) {
        Map map;
        if (string2.equalsIgnoreCase("BUSY") && n > 0 && (map = executingpeerstime.get(string) == null ? Collections.synchronizedMap(new TreeMap()) : executingpeerstime.get(string)) != null) {
            map.put(n, l);
            executingpeerstime.put(string, map);
        }
        if (string2.equalsIgnoreCase("NOBUSY")) {
            executingpeerstime.remove(string);
        }
    }

    public static synchronized void updateFinishedPeersTime(String string, int n, long l) {
        if (n > 0 && executingpeerstime.get(string) != null) {
            Map map = executingpeerstime.get(string);
            if ((map != null && map.get(n) != null && (Long)map.get(n) == l || l == 0L) && map != null) {
                map.remove(n);
            }
            if (map != null && map.keySet().size() == 0) {
                executingpeerstime.remove(string);
            }
        }
    }

    public static synchronized void updatePeerStatistics(String string, String string2) {
        cachedStatistics.put(string, string2);
    }

    public static synchronized Map getPeerStatistics() {
        return cachedStatistics;
    }

    public static synchronized void updatePeerQueueStat(String string, String string2) {
        cachedPeerQueueStat.put(string, string2);
    }

    public static synchronized Map getPeerQueueStat() {
        return cachedPeerQueueStat;
    }

    public static synchronized void updatePeerRPackages(String string, String string2) {
        cachedRPackages.put(string, string2);
    }

    public static synchronized Map getPeerRPackages() {
        return cachedRPackages;
    }

    public static Map<String, Integer> getExecutingPeers() {
        return executingpeers;
    }

    public static synchronized Map<String, Map> getExecutingPeersTime() {
        return executingpeerstime;
    }

    public static HashMap getCachedPeers() {
        HashMap hashMap = null;
        if (cachedPeers != null) {
            hashMap = cachedPeers.getMatching("^[A-Za-z0-9]+$");
        }
        return hashMap != null ? hashMap : new HashMap();
    }

    public static synchronized void peerRespRecencyOnTask(int n, long l) {
        try {
            if (cachedPeerResp4Task == null) {
                cachedPeerResp4Task = JCS.getInstance((String)"cachedPeerResp4Task$$$");
            }
            IElementAttributes iElementAttributes = cachedPeerResp4Task.getDefaultElementAttributes();
            iElementAttributes.setMaxLifeSeconds(180L);
            String string = n + "_" + l;
            cachedPeerResp4Task.put((Object)string, (Object)"true", iElementAttributes);
        }
        catch (Exception exception) {
            Logger logger = Logger.getLogger(IncomingMessage.class);
            logger.error((Object)("Error:" + exception.getMessage()));
        }
    }

    public static synchronized boolean isRespRecencyOnTask(int n, long l) {
        String string = n + "_" + l;
        return cachedPeerResp4Task != null && cachedPeerResp4Task.get((Object)string) != null;
    }
}

