/*
 * Decompiled with CFR 0.152.
 */
package com.fe.p2p.msg.impl;

import com.fe.json.JSONArray;
import com.fe.p2p.P2PService;
import com.fe.p2p.listener.OutgoingMessageCallBack;
import com.fe.p2p.msg.PostCallBack;
import com.fe.p2p.msg.PostMessage;
import com.fe.p2p.msg.impl.ScriptFinished;
import com.fe.scheduler.ScheduledTask;
import com.fe.scheduler.ScheduledTaskFactory;
import com.fe.scheduler.StackFrame;
import com.fe.scheduler.StackFrameCallBack;
import com.fe.scheduler.balance.LoadBalancingQueue;
import com.fe.scheduler.exception.SchedulerException;
import com.fe.scheduler.peer.QueueAbstract;
import com.fe.scheduler.peer.QueueFactory;
import com.fe.scheduler.rscript.RScript;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.jcs.JCS;
import org.apache.jcs.engine.behavior.IElementAttributes;
import org.apache.log4j.Logger;
import org.rosuda.JRI.REXP;
import org.rosuda.JRI.RVector;

public class ExecuteScript
extends RScript
implements PostCallBack {
    private Logger log = Logger.getLogger(ExecuteScript.class);
    private static JCS cache = null;

    @Override
    public synchronized Map executeAtDestination() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        try {
            this.log.debug((Object)("getTaskuid():" + this.getTaskuid()));
            ScheduledTask scheduledTask = new ScheduledTaskFactory().getTaskFromAll(this.getTaskuid());
            this.log.debug((Object)("task:" + scheduledTask));
            StackFrame stackFrame = new StackFrame(scheduledTask, null);
            this.log.debug((Object)("-------->" + this.getUid()));
            stackFrame.setRscript(this);
            stackFrame.setReplyTo(this.getMsgCreator());
            stackFrame.addCallBack(new StackFrameCallBack(){

                @Override
                public void callBack(StackFrame stackFrame, String string, SchedulerException schedulerException) {
                    String string2 = null;
                    if (stackFrame.getRscript() != null) {
                        Object object;
                        String string3;
                        Object object2;
                        string2 = "<?xml version=\"1.0\"?><output status=\"" + string + "\" peer=\"" + P2PService.getComputerName() + "\">";
                        if (stackFrame.getRscript().getResultXML() != null) {
                            string2 = string2 + "<result>" + stackFrame.getRscript().getResultXML() + "</result>";
                        }
                        REXP rEXP = stackFrame.getRscript().getResult();
                        String string4 = "";
                        if (rEXP != null) {
                            object2 = rEXP.asVector();
                            string3 = "";
                            string3 = ExecuteScript.this.parse(rEXP, string3);
                            try {
                                string4 = ExecuteScript.this.parseJSON(rEXP, string4);
                            }
                            catch (Exception exception) {
                                object = "Error while parsing to json";
                                ExecuteScript.this.log.error(object);
                                stackFrame.getRscript().setError(stackFrame.getRscript().getError() != null ? stackFrame.getRscript().getError() + ", " + (String)object : " Error while parsing result to JSON ");
                            }
                            string2 = string2 + "<result>" + string3 + "</result>";
                        }
                        object2 = new SimpleDateFormat("d MMM yyyy HH:mm:ss SSS");
                        string3 = stackFrame.getRscript().getError() != null ? stackFrame.getRscript().getError() : "";
                        string2 = string2 + "<error>" + string3 + "</error>";
                        string2 = string2 + "<startedTime>" + ((DateFormat)object2).format(new Date(stackFrame.getStarted_time())) + "</startedTime>";
                        string2 = string2 + "<duration in=\"milliseconds\">" + (new Date().getTime() - stackFrame.getStarted_time()) + "</duration>";
                        string2 = string2 + "</output>";
                        ScriptFinished scriptFinished = new ScriptFinished();
                        scriptFinished.setStatus(string);
                        scriptFinished.setResult(string2);
                        scriptFinished.setUid(stackFrame.getRscript().getUid());
                        scriptFinished.setError(stackFrame.getRscript().getError());
                        scriptFinished.setJsonresult(string4);
                        scriptFinished.setPriority(OutgoingMessageCallBack.PRIORITY_VERY_VERY_HIGH);
                        object = new PostMessage(scriptFinished, stackFrame.getReplyTo());
                        ((PostMessage)object).send();
                    }
                }
            });
            boolean bl = false;
            QueueAbstract queueAbstract = new QueueFactory().getQueue(this.getTaskuid());
            if (queueAbstract.isRoomForThread()) {
                queueAbstract.addExThread(stackFrame);
                bl = true;
            }
            Object[] objectArray = queueAbstract.getExecutingStacks();
            String string = "";
            for (int i = 0; i < objectArray.length; ++i) {
                StackFrame stackFrame2 = (StackFrame)objectArray[i];
                if (stackFrame2.getRscript() == null) continue;
                string = string + (string.equals("") ? stackFrame2.getRscript().getUid() : "|" + stackFrame2.getRscript().getUid());
            }
            hashMap.put("running_uids", string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return hashMap;
    }

    private String parse(REXP rEXP, String string) {
        Object object;
        if (rEXP.getType() == 16) {
            object = rEXP.asVector();
            for (Object e : object) {
                if (!(e instanceof REXP)) continue;
                string = string + this.parse((REXP)e, "");
            }
        }
        if (rEXP.getType() == 2) {
            string = string + "<double>" + rEXP.asDouble() + "</double>";
        }
        if (rEXP.getType() == 33) {
            object = rEXP.asDoubleArray();
            string = string + "<array>";
            for (int i = 0; i < ((RVector)object).length; ++i) {
                string = string + "<double>" + (double)object[i] + "</double>";
            }
            string = string + "</array>";
        }
        if (rEXP.getType() == 3) {
            string = string + "<string>" + rEXP.asString() + "</string>";
        }
        return string;
    }

    private String parseJSON(REXP rEXP, String string) throws Exception {
        Object object;
        Object object2;
        if (rEXP.getType() == 16) {
            object2 = rEXP.asVector();
            object = object2.iterator();
            while (object.hasNext()) {
                Object e = object.next();
                if (!(e instanceof REXP)) continue;
                string = string + this.parseJSON((REXP)e, "");
            }
        }
        object2 = new JSONArray();
        if (rEXP.getType() == 2) {
            ((JSONArray)object2).put(rEXP.asDouble());
        }
        if (rEXP.getType() == 33) {
            object = rEXP.asDoubleArray();
            for (int i = 0; i < ((Object)object).length; ++i) {
                ((JSONArray)object2).put((double)object[i]);
            }
        }
        if (rEXP.getType() == 3) {
            ((JSONArray)object2).put(rEXP.asString());
        }
        return ((JSONArray)object2).toString();
    }

    private static JCS getCache() throws Exception {
        if (cache == null) {
            cache = JCS.getInstance((String)ExecuteScript.class.getName());
        }
        return cache;
    }

    @Override
    public void callBack(Map map) {
        String string = (String)map.get("running_uids");
        String string2 = this.getMsgCreator();
        String string3 = string2 + "_delay";
        try {
            if (ExecuteScript.getCache().get((Object)string3) == null) {
                this.log.debug((Object)("<<--------" + this.getUid()));
                if (string != null && !string.equals("")) {
                    ArrayList<String> arrayList = new ArrayList<String>();
                    StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
                    while (stringTokenizer.hasMoreTokens()) {
                        arrayList.add(stringTokenizer.nextToken());
                    }
                    Collection<RScript> collection = LoadBalancingQueue.getExecuteRScriptDefault().getScriptProcessingQueue();
                    for (RScript rScript : collection) {
                        long l;
                        if (!rScript.getPeer().equals(string2) || (l = new Date().getTime() - rScript.getStartedtime().getTime()) <= 60000L || arrayList.contains(rScript.getUid())) continue;
                        this.log.debug((Object)("removing task uid:" + rScript.getUid()));
                        rScript.setError("Removing because it is not running on peer");
                        String string4 = "";
                        LoadBalancingQueue.getExecuteRScriptDefault().scriptFinished(rScript, string4, ScheduledTask.EXCECUTION_FAIL);
                    }
                    IElementAttributes iElementAttributes = ExecuteScript.getCache().getDefaultElementAttributes();
                    iElementAttributes.setMaxLifeSeconds(60L);
                    ExecuteScript.getCache().put((Object)string3, (Object)"delay", iElementAttributes);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void onCallBackSendingFailed() {
    }
}

