/*
 * Decompiled with CFR 0.152.
 */
package com.fe.scheduler;

import com.fe.client.MigrationMgmt;
import com.fe.connectbl.SyncManager;
import com.fe.xml.XMLScheduledJob;
import java.io.File;
import java.io.FileWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.log4j.Logger;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class BloombergSyncJob
implements Job {
    private Logger log = Logger.getLogger(BloombergSyncJob.class);

    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        XMLScheduledJob xMLScheduledJob = (XMLScheduledJob)jobExecutionContext.getJobDetail().getJobDataMap().get((Object)"job");
        if (xMLScheduledJob != null && xMLScheduledJob.getDaysNumber() > 0) {
            Date date = new Date();
            try {
                this.log.debug((Object)"Synchronization started");
                SyncManager syncManager = new SyncManager(xMLScheduledJob.getDaysNumber(), new MigrationMgmt(), xMLScheduledJob.getConfolder(), xMLScheduledJob.getDatabase());
                syncManager.setFilename(xMLScheduledJob.getFilename());
                syncManager.start();
                this.log.debug((Object)"Synchronization done");
                this.externalLog(date, new Date(), xMLScheduledJob, true);
            }
            catch (Exception exception) {
                this.externalLog(date, new Date(), xMLScheduledJob, false);
            }
        }
    }

    private void externalLog(Date date, Date date2, XMLScheduledJob xMLScheduledJob, boolean bl) {
        boolean bl2 = true;
        boolean bl3 = false;
        String string = new File(xMLScheduledJob.getConfolder()).getParent() + File.separator + "scheduler.log";
        File file = new File(string);
        try {
            boolean bl4 = true;
            FileWriter fileWriter = new FileWriter(file, bl4);
            String string2 = "dd-MMM hh:mm:ss aaa ";
            String string3 = "";
            string3 = string3 + "Config file:" + xMLScheduledJob.getFilename();
            string3 = string3 + "\tStarted At:" + new SimpleDateFormat(string2).format(date);
            if (bl == bl2) {
                string3 = string3 + "\tEnded At:" + new SimpleDateFormat(string2).format(date2);
                string3 = string3 + "\tStatus:Success";
            } else {
                string3 = string3 + "\tStatus:Failed";
            }
            string3 = string3 + "\t #Days:" + xMLScheduledJob.getDaysNumber();
            if (!file.exists()) {
                file.createNewFile();
            }
            fileWriter.append(string3 + "\r\n");
            fileWriter.flush();
            fileWriter.close();
        }
        catch (Exception exception) {
            this.log.error((Object)("Error:" + exception.getMessage()));
        }
    }
}

