/*
 * Decompiled with CFR 0.152.
 */
package com.fe.scheduler;

import com.fe.Config;
import com.fe.client.BBSyncMgmt;
import com.fe.client.ClientErrorMgmt;
import com.fe.db.SchedulerDB;
import com.fe.p2p.P2PService;
import com.fe.scheduler.ScheduledTask;
import com.fe.scheduler.ScheduledTaskFactory;
import com.fe.scheduler.StackFrame;
import com.fe.scheduler.balance.LoadBalancingQueue;
import com.fe.scheduler.balance.LoadBalancingQueueItem;
import java.util.Date;
import java.util.Map;
import org.apache.log4j.Logger;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class ScheduledTaskJob
implements Job {
    private Logger log = Logger.getLogger(ScheduledTaskJob.class);

    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        int n = (Integer)jobExecutionContext.getJobDetail().getJobDataMap().get((Object)"scheduler_id");
        String string = (String)jobExecutionContext.getJobDetail().getJobDataMap().get((Object)"taskuid");
        String string2 = (String)jobExecutionContext.getJobDetail().getJobDataMap().get((Object)"jobdata_invoked_by");
        String string3 = (String)jobExecutionContext.getJobDetail().getJobDataMap().get((Object)"jobdata_updatedtime");
        Number number = (Number)jobExecutionContext.getJobDetail().getJobDataMap().get((Object)"trigger_row_id");
        try {
            Object object;
            SchedulerDB schedulerDB = SchedulerDB.getSchedulerDB();
            Map map = null;
            String string4 = null;
            try {
                schedulerDB.connectDB(BBSyncMgmt.getDBName());
                map = schedulerDB.getScheduler(n);
                if (number != null) {
                    object = schedulerDB.getOneRowTriggerData(number.longValue());
                    string4 = (String)object.get("inject_code");
                }
            }
            catch (Exception exception) {
                throw exception;
            }
            finally {
                schedulerDB.closeDB();
            }
            if (map.get("deleted") != null && ((Number)map.get("deleted")).intValue() == 1) {
                throw new Exception("Deleted Task can't be executed");
            }
            this.log.debug((Object)("trigger_row_id:" + number + "    inject_code:" + string4));
            object = new ScheduledTaskFactory().getTask(string);
            if (object == null) {
                throw new Exception("Task Group not found for the task:" + n);
            }
            StackFrame stackFrame = new StackFrame((ScheduledTask)object, map);
            if (string2 != null && !string2.equals("")) {
                stackFrame.setInvokedby(string2);
            } else if (string3 != null) {
                stackFrame.setInvokedby("Scheduler (" + string3 + ")");
            } else {
                stackFrame.setInvokedby("Scheduler");
            }
            if (jobExecutionContext.getTrigger().getPreviousFireTime() != null) {
                stackFrame.setTrigger_time(jobExecutionContext.getTrigger().getPreviousFireTime().getTime());
            } else {
                stackFrame.setTrigger_time(new Date().getTime());
            }
            if (jobExecutionContext.getTrigger().getNextFireTime() != null) {
                stackFrame.setNexttrigger_time(jobExecutionContext.getTrigger().getNextFireTime().getTime());
            }
            if (Config.getValue("load_balancing_server") != null && Config.getValue("load_balancing_server").equals(P2PService.getComputerName())) {
                LoadBalancingQueueItem loadBalancingQueueItem = new LoadBalancingQueueItem();
                loadBalancingQueueItem.setSf(stackFrame);
                Integer n2 = (Integer)map.get("id");
                loadBalancingQueueItem.setInject_code(string4);
                loadBalancingQueueItem.setSchedulerid(n2);
                LoadBalancingQueue.getDefault().add(loadBalancingQueueItem);
            }
            this.log.debug((Object)("adding task to queue: task:" + map.get("name")));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            ClientErrorMgmt.reportError(exception, "Error while triggering task");
        }
    }

    private void addLog(Date date, Map map, String string) throws Exception {
        SchedulerDB schedulerDB = SchedulerDB.getSchedulerDB();
        schedulerDB.connectDB(BBSyncMgmt.getDBName());
        Number number = (Number)map.get("id");
        String string2 = (String)map.get("timezone");
        Date date2 = new Date();
        int n = number.intValue();
        schedulerDB.addSchedulerLog(n, date, date2, string2, string, null);
        schedulerDB.closeDB();
    }
}

