/*
 * Decompiled with CFR 0.152.
 */
package com.fe.scheduler.balance;

import com.fe.client.BBSyncMgmt;
import com.fe.client.ClientErrorMgmt;
import com.fe.client.Debugger;
import com.fe.client.SchedulerMgmt;
import com.fe.db.SchedulerDB;
import com.fe.db.SuperDB;
import com.fe.p2p.MessageBean;
import com.fe.p2p.P2PAdvertisement;
import com.fe.p2p.P2PService;
import com.fe.p2p.listener.IncomingMessage;
import com.fe.p2p.listener.OutgoingMessage;
import com.fe.p2p.listener.OutgoingMessageCallBack;
import com.fe.p2p.msg.PostMessage;
import com.fe.p2p.msg.impl.TenderScript;
import com.fe.scheduler.ScheduledTask;
import com.fe.scheduler.ScheduledTaskFactory;
import com.fe.scheduler.ScheduledTaskQueue;
import com.fe.scheduler.SchedulerAlert;
import com.fe.scheduler.SchedulerEngine;
import com.fe.scheduler.SchedulerExePlanLogs;
import com.fe.scheduler.StackFrame;
import com.fe.scheduler.StackFrameCallBack;
import com.fe.scheduler.balance.LoadBalancingQueue;
import com.fe.scheduler.balance.LoadBalancingQueueItem;
import com.fe.scheduler.balance.LoadBalancingQueueTimeout;
import com.fe.scheduler.balance.WaitingQueueList;
import com.fe.scheduler.balance.hsqldb.LoadBalancingHSQLQueue;
import com.fe.scheduler.exception.ExceptionDependencyTimeout;
import com.fe.scheduler.exception.SchedulerException;
import com.fe.scheduler.rscript.RScript;
import com.fe.scheduler.rscript.RScriptListener;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import net.jxta.peergroup.PeerGroup;
import net.jxta.pipe.OutputPipeListener;
import net.jxta.pipe.PipeService;
import net.jxta.protocol.PipeAdvertisement;
import org.apache.jcs.engine.behavior.IElementAttributes;
import org.apache.log4j.Logger;
import org.mozilla.javascript.edu.emory.mathcs.backport.java.util.Collections;

public class LoadBalancingLinkedQueue
extends LoadBalancingQueue
implements Callable {
    private WaitingQueueList<LoadBalancingQueueItem> queue = new WaitingQueueList();
    private ConcurrentLinkedQueue<LoadBalancingQueueItem> queueprocessing = new ConcurrentLinkedQueue();
    private ConcurrentLinkedQueue<RScript> scriptQueue = new ConcurrentLinkedQueue();
    private ConcurrentLinkedQueue<RScript> scriptQueueProcessing = new ConcurrentLinkedQueue();
    private Vector<RScript> scriptQueueVec = new Vector();
    private Hashtable<String, RScriptListener> scriptQueueListener = new Hashtable();
    private TreeMap queue_stat = new TreeMap();
    private boolean threadRunning = false;
    private boolean scriptThreadRunning = false;
    private long lastExcecutedTime = 0L;
    private Logger log = Logger.getLogger(LoadBalancingLinkedQueue.class);
    private Future<String> future = null;
    private Future<String> futureScript = null;
    private ExecutorService executor = Executors.newCachedThreadPool();
    private static ExecutorService startScriptService = Executors.newFixedThreadPool(3);
    private int currentMode = 0;
    private TreeMap runonlyon = new TreeMap();
    private static final int MODE_TASK = 1;
    private static final int MODE_SCRIPT = 2;
    private Vector roundRobin = new Vector();

    public LoadBalancingLinkedQueue(int n) {
        this.currentMode = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public synchronized void add(LoadBalancingQueueItem loadBalancingQueueItem) {
        int n;
        Object object;
        loadBalancingQueueItem.setExecuting(false);
        this.log.debug((Object)("add() item: scheduler_id:" + loadBalancingQueueItem.getSchedulerid() + " trigger_time:" + loadBalancingQueueItem.getSf().getTrigger_time()));
        TreeMap<String, Object> treeMap = new TreeMap<String, Object>();
        treeMap.put("scheduler_id", loadBalancingQueueItem.getSchedulerid());
        treeMap.put("trigger_time", loadBalancingQueueItem.getSf().getTrigger_time());
        treeMap.put("inject_code", loadBalancingQueueItem.getInject_code());
        boolean bl = false;
        if (this.getAllTaskIds().contains(loadBalancingQueueItem.getSchedulerid())) {
            bl = true;
            try {
                long l;
                object = null;
                n = 0;
                for (LoadBalancingQueueItem object2 : this.queueprocessing) {
                    if (object2.getSchedulerid() == loadBalancingQueueItem.getSchedulerid()) {
                        ++n;
                    }
                    if (object2.getSchedulerid() != loadBalancingQueueItem.getSchedulerid() || object2.getStarted() == null || object2.getOverlaptimeout() <= 0L) continue;
                    object = object2;
                }
                if (object != null && n <= 1 && (l = new Date().getTime() - ((LoadBalancingQueueItem)object).getStarted().getTime()) >= ((LoadBalancingQueueItem)object).getOverlaptimeout()) {
                    bl = false;
                    new SchedulerExePlanLogs(((LoadBalancingQueueItem)object).getSchedulerid(), ((LoadBalancingQueueItem)object).getSf().getTrigger_time()).log("Task is taking more time and the same task can be overlapped in the queue", 0);
                }
            }
            catch (Exception exception) {
                System.out.println("~~~~ LoadBalancingQueue.class Error 20:" + exception.getMessage());
            }
        }
        object = SchedulerDB.getSchedulerDB();
        n = 1;
        try {
            ((SuperDB)object).connectDB(BBSyncMgmt.getDBName());
            LoadBalancingQueueTimeout loadBalancingQueueTimeout = new LoadBalancingQueueTimeout((SchedulerDB)object, new ScheduledTaskFactory().getTaskUids());
            WaitingQueueList.setAlertRange(loadBalancingQueueTimeout.getMaxWaitingAlert());
            if (!bl) {
                try {
                    new SchedulerExePlanLogs(loadBalancingQueueItem.getSchedulerid(), loadBalancingQueueItem.getSf().getTrigger_time()).log("Added to server queue by " + loadBalancingQueueItem.getSf().getInvokedby(), 0);
                    if (loadBalancingQueueItem.getInject_code() != null && !loadBalancingQueueItem.getInject_code().equals("")) {
                        new SchedulerExePlanLogs(loadBalancingQueueItem.getSchedulerid(), loadBalancingQueueItem.getSf().getTrigger_time()).log(" Code Injected: " + loadBalancingQueueItem.getInject_code(), 0);
                    }
                    this.addLastExecutionDuration((SchedulerDB)object, loadBalancingQueueItem);
                    this.addTimeoutAndLastExecTimes((SchedulerDB)object, loadBalancingQueueItem);
                }
                catch (Exception exception) {
                    System.out.println("LoadBalancingQueue: Error 10:" + exception.getMessage());
                }
                this.queue.add((Object)loadBalancingQueueItem);
            } else {
                void var7_17;
                treeMap.put("status", ScheduledTask.EXCECUTION_OVERLAPPED);
                treeMap.put("is_triggered", new Integer(1));
                LoadBalancingQueueItem loadBalancingQueueItem2 = this.getItemFromQueue(this.getQueuedTasks(), loadBalancingQueueItem);
                if (loadBalancingQueueItem2 == null) {
                    LoadBalancingQueueItem loadBalancingQueueItem3 = this.getItemFromQueue(this.getExecutingTasks(), loadBalancingQueueItem);
                }
                if (var7_17 != null) {
                    if (var7_17.getSf().getTrigger_time() == loadBalancingQueueItem.getSf().getTrigger_time()) {
                        n = 0;
                    } else {
                        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd/MMM hh:mm");
                        Date date = new Date();
                        date.setTime(var7_17.getSf().getTrigger_time());
                        String string = "Failed, The task is already queued, added at " + simpleDateFormat.format(date);
                        if (var7_17.getStarted() != null) {
                            string = "Failed, The task is already executing, started at " + simpleDateFormat.format(var7_17.getStarted());
                        }
                        new SchedulerExePlanLogs(loadBalancingQueueItem.getSchedulerid(), loadBalancingQueueItem.getSf().getTrigger_time()).log(string, 0);
                    }
                }
            }
            if (n != 0) {
                Vector<TreeMap<String, Object>> vector = new Vector<TreeMap<String, Object>>();
                vector.add(treeMap);
                ((SchedulerDB)object).updateQueueLog(vector, new Vector());
            }
        }
        catch (Exception exception) {
            System.out.println("~~~~ LoadBalancingQueueItem.add() Error while adding :" + exception.getMessage());
        }
        finally {
            try {
                ((SuperDB)object).closeDB();
            }
            catch (Exception exception) {}
        }
        if (this.future == null || this.future != null && this.future.isDone()) {
            this.future = this.executor.submit(this);
        }
    }

    private Vector<Number> getAllTaskIds() {
        Vector<Number> vector = new Vector<Number>();
        for (LoadBalancingQueueItem loadBalancingQueueItem : this.queue) {
            vector.add(new Integer(loadBalancingQueueItem.getSchedulerid()));
        }
        for (LoadBalancingQueueItem loadBalancingQueueItem : this.queueprocessing) {
            vector.add(new Integer(loadBalancingQueueItem.getSchedulerid()));
        }
        return vector;
    }

    public ArrayList<LoadBalancingQueueItem> getAllTasks() {
        ArrayList<LoadBalancingQueueItem> arrayList = new ArrayList<LoadBalancingQueueItem>();
        for (LoadBalancingQueueItem loadBalancingQueueItem : this.queue) {
            arrayList.add(loadBalancingQueueItem);
        }
        for (LoadBalancingQueueItem loadBalancingQueueItem : this.queueprocessing) {
            arrayList.add(loadBalancingQueueItem);
        }
        return arrayList;
    }

    @Override
    public long lastExcecutedTime() {
        return this.lastExcecutedTime;
    }

    @Override
    public synchronized void removeItemProcessing(LoadBalancingQueueItem loadBalancingQueueItem, String string, int n) {
        if (string != null) {
            new SchedulerExePlanLogs(loadBalancingQueueItem.getSchedulerid(), loadBalancingQueueItem.getSf().getTrigger_time()).log(string, 0);
        }
        this.queueprocessing.remove(loadBalancingQueueItem);
        this.removeTimeoutForTask(loadBalancingQueueItem.getSchedulerid(), loadBalancingQueueItem.getSf().getTrigger_time());
        Debugger.addDebugMsg("script id:" + loadBalancingQueueItem.getSchedulerid() + " executing finishing removing form LB executing Queue", loadBalancingQueueItem.getSchedulerid() + "");
        this.log.debug((Object)("removing from processing Q schedueler_id:" + loadBalancingQueueItem.getSchedulerid()));
        loadBalancingQueueItem.setSf(null);
        loadBalancingQueueItem = null;
    }

    private synchronized void addItemProcessing(LoadBalancingQueueItem loadBalancingQueueItem) {
        this.queueprocessing.add(loadBalancingQueueItem);
        if (loadBalancingQueueItem.getTimeoutexpiry() > 0L) {
            this.addTimeoutForTask(loadBalancingQueueItem.getSchedulerid(), loadBalancingQueueItem.getSf().getTrigger_time(), loadBalancingQueueItem.getStarted().getTime(), loadBalancingQueueItem.getTimeoutexpiry());
        }
        this.log.debug((Object)("adding to processing Q schedueler_id:" + loadBalancingQueueItem.getSchedulerid()));
    }

    private synchronized void removeFromQueue(LoadBalancingQueueItem loadBalancingQueueItem) {
        this.queue.remove(loadBalancingQueueItem);
        this.log.debug((Object)("removing from Queue schedueler_id:" + loadBalancingQueueItem.getSchedulerid()));
    }

    private Set intersection(Collection collection, Collection collection2) {
        HashSet hashSet = new HashSet(collection);
        hashSet.retainAll(collection2);
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runTasks() {
        try {
            if (this.cache == null) {
                this.getCache();
            }
            if (this.getCache().get((Object)"System_Garbage_Collector") == null) {
                IElementAttributes iElementAttributes = this.getCache().getDefaultElementAttributes();
                iElementAttributes.setMaxLifeSeconds(45L);
                this.getCache().put((Object)"System_Garbage_Collector", (Object)"yes", iElementAttributes);
                System.gc();
            }
            this.log.debug((Object)"+++++++++++++++++++++++++++++++++++++++++++++++++>runTasks() ");
            while (!this.queue.isEmpty()) {
                try {
                    for (LoadBalancingQueueItem loadBalancingQueueItem : this.queue) {
                        try {
                            if (this.processDependencyQueueItem(loadBalancingQueueItem) && this.processValidateQueueItem(loadBalancingQueueItem)) {
                                this.processQueueItem(loadBalancingQueueItem);
                            }
                        }
                        catch (Exception exception) {
                            this.log.error((Object)("error while processing item:" + loadBalancingQueueItem.getSchedulerid()));
                            exception.printStackTrace();
                        }
                        Thread.sleep(13L);
                        loadBalancingQueueItem = null;
                    }
                }
                catch (Exception exception) {
                    this.log.error((Object)("error while processing queue: err: " + exception.getMessage()));
                }
            }
            this.log.debug((Object)"<-------------------------------------------------------------------- exiting ..... runTasks() ");
        }
        catch (Exception exception) {
            this.log.error((Object)("loadbalancing queue thread terminiated: e: " + exception.getMessage()));
            exception.printStackTrace();
        }
        finally {
            this.threadRunning = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runScripts() {
        try {
            if (this.cache == null) {
                this.getCache();
            }
            if (this.getCache().get((Object)"System_Garbage_Collector") == null) {
                IElementAttributes iElementAttributes = this.getCache().getDefaultElementAttributes();
                iElementAttributes.setMaxLifeSeconds(45L);
                this.getCache().put((Object)"System_Garbage_Collector", (Object)"yes", iElementAttributes);
                System.gc();
            }
            while (!this.scriptQueue.isEmpty()) {
                try {
                    if (this.scriptQueue.isEmpty()) continue;
                    try {
                        this.processScriptQueue();
                    }
                    catch (Exception exception) {
                        this.log.error((Object)("couldn't process script, e:" + exception.getMessage()));
                    }
                }
                catch (Exception exception) {
                    Thread.sleep(5L);
                    this.log.error((Object)("error while processing queue: err: " + exception.getMessage()));
                }
            }
        }
        catch (Exception exception) {
            this.log.error((Object)("loadbalancing queue thread terminiated: e: " + exception.getMessage()));
            exception.printStackTrace();
        }
        finally {
            this.scriptThreadRunning = false;
        }
    }

    private void runTimeoutCleaner() {
    }

    public void run() {
    }

    public Object call() throws Exception {
        this.log.debug((Object)("call() called and current mode:" + this.currentMode));
        switch (this.currentMode) {
            case 1: {
                this.runTasks();
                break;
            }
            case 2: {
                this.runScripts();
            }
        }
        return "done";
    }

    public void killScriptQueue() {
        this.scriptQueueListener.clear();
        this.scriptQueueVec.clear();
        this.scriptQueue.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void scriptTimedOut(RScript rScript) {
        block10: {
            try {
                if (this.scriptQueueListener.get(rScript.getUid()) == null) break block10;
                RScriptListener rScriptListener = this.scriptQueueListener.get(rScript.getUid());
                try {
                    rScriptListener.onScriptTimedOut(rScript);
                }
                catch (Exception exception) {
                    ClientErrorMgmt.reportError(exception, "Error while invoking listener");
                }
                finally {
                    this.scriptQueueListener.remove(rScript.getUid());
                }
            }
            catch (Exception exception) {
                this.log.error((Object)"Error while time out");
            }
            finally {
                this.scriptQueueVec.remove(rScript);
                this.scriptQueue.remove(rScript);
            }
        }
    }

    private void processScriptQueue() throws Exception {
        RScript rScript = this.scriptQueue.peek();
        if (!rScript.isExecuting()) {
            this.cache = this.getCache();
            if (this.getCache().get((Object)rScript.getUid()) == null) {
                IElementAttributes iElementAttributes = this.getGroupedCache().getDefaultElementAttributes();
                iElementAttributes.setMaxLifeSeconds((long)CACHE_GROUP_EXPIRY);
                this.getGroupedCache().putInGroup((Object)rScript.getUid(), CACHE_GROUP_TIMEOUT, (Object)"timeout", iElementAttributes);
                this.log.debug((Object)"adding into timeoud cache...------------>");
                this.scriptTimedOut(rScript);
                for (Object e : this.getGroupedCache().getGroupKeys(CACHE_GROUP_TIMEOUT)) {
                    this.getGroupedCache().getFromGroup(e, CACHE_GROUP_TIMEOUT);
                }
            } else {
                Vector<String> vector;
                Vector<Object> vector2 = this.getRunOnlyOn(rScript.getTaskuid());
                if (rScript.getExecuteAt() != null) {
                    vector = new Vector<String>();
                    if (vector2.contains(rScript.getExecuteAt())) {
                        vector.add(rScript.getExecuteAt());
                    }
                } else {
                    for (String string : vector2) {
                        if (this.roundRobin.contains(string)) continue;
                        this.roundRobin.add(string);
                    }
                    vector = new Vector();
                    for (String string : this.roundRobin) {
                        if (!vector2.contains(string)) continue;
                        vector.add(string);
                    }
                }
                if (vector != null && vector.size() > 0) {
                    for (String string : vector) {
                        String string2 = string + "_" + rScript.getTaskuid();
                        IElementAttributes iElementAttributes = this.cache.getDefaultElementAttributes();
                        iElementAttributes.setMaxLifeSeconds(1L);
                        if (this.cache.get((Object)string2) != null) continue;
                        TenderScript tenderScript = new TenderScript();
                        tenderScript.setPriority(OutgoingMessageCallBack.PRIORITY_LOW);
                        tenderScript.setUid(rScript.getUid());
                        tenderScript.setTaskuid(rScript.getTaskuid());
                        PostMessage postMessage = new PostMessage(tenderScript, string);
                        postMessage.send();
                        this.cache.put((Object)string2, (Object)"send", iElementAttributes);
                        tenderScript = null;
                        postMessage = null;
                        this.log.debug((Object)("sending to :" + string));
                    }
                }
                if (!this.roundRobin.isEmpty()) {
                    Collections.rotate((List)this.roundRobin, (int)-1);
                }
                vector2 = null;
                vector = null;
            }
        }
        rScript = null;
    }

    @Override
    public synchronized void addExecuteR(RScript rScript, RScriptListener rScriptListener) throws Exception {
        this.log.debug((Object)("adding script:" + rScript.getScript()));
        rScript.setExecuting(false);
        rScript.setQueued_time(new Date().getTime());
        this.scriptQueue.add(rScript);
        this.scriptQueueVec.add(rScript);
        IElementAttributes iElementAttributes = this.getCache().getDefaultElementAttributes();
        iElementAttributes.setMaxLifeSeconds((long)CACHE_GROUP_EXPIRY);
        this.getCache().put((Object)rScript.getUid(), (Object)"alive", iElementAttributes);
        if (rScriptListener != null) {
            this.scriptQueueListener.put(rScript.getUid(), rScriptListener);
        }
        if (this.futureScript == null || this.futureScript != null && this.futureScript.isDone()) {
            this.futureScript = this.executor.submit(this);
        }
    }

    @Override
    public final RScript startScriptIfNotStarted(RScript rScript, String string) {
        Future<RScript> future = startScriptService.submit(new Callable<RScript>(){
            private RScript rscript = null;
            private String peer = null;

            @Override
            public RScript call() {
                RScript rScript = null;
                if (LoadBalancingQueue.getDefault() instanceof LoadBalancingHSQLQueue) {
                    LoadBalancingLinkedQueue loadBalancingLinkedQueue = (LoadBalancingLinkedQueue)LoadBalancingQueue.getExecuteRScriptDefault();
                    rScript = loadBalancingLinkedQueue.startScriptIfNotStarted1(this.rscript, this.peer);
                }
                return rScript;
            }

            public Callable<RScript> init(RScript rScript, String string) {
                this.rscript = rScript;
                this.peer = string;
                return this;
            }
        }.init(rScript, string));
        RScript rScript2 = null;
        try {
            rScript2 = future.get();
        }
        catch (Exception exception) {
            this.log.error((Object)"error while retriveing future result");
        }
        return rScript2;
    }

    private synchronized RScript startScriptIfNotStarted1(RScript rScript, String string) {
        if (this.scriptQueue.contains(rScript)) {
            Object object;
            this.scriptQueue.remove(rScript);
            RScript rScript2 = this.scriptQueueVec.get(this.scriptQueueVec.indexOf(rScript));
            rScript2.setPeer(string);
            rScript2.setDelay(new Date().getTime() - rScript2.getQueued_time());
            rScript2.setExecuting(true);
            rScript2.setStartedtime(new Date());
            this.scriptQueueProcessing.add(rScript2);
            if (this.scriptQueueListener.get(rScript2.getUid()) != null) {
                object = this.scriptQueueListener.get(rScript2.getUid());
                try {
                    object.onScriptSent(rScript2, string);
                }
                catch (Exception exception) {
                    ClientErrorMgmt.reportError(exception, "Error while invoking listener");
                }
            }
            try {
                object = this.getGroupedCache().getDefaultElementAttributes();
                object.setMaxLifeSeconds((long)CACHE_GROUP_EXPIRY);
                this.getGroupedCache().putInGroup((Object)string, CACHE_GROUP_ACTIVEPEERS, (Object)"active", (IElementAttributes)object);
            }
            catch (Exception exception) {
                this.log.error((Object)"error while caching active peer");
            }
            return rScript2;
        }
        return null;
    }

    @Override
    public synchronized void scriptFinished(RScript rScript, String string, String string2) {
        this.scriptQueueProcessing.remove(rScript);
        try {
            RScript rScript2 = this.scriptQueueVec.get(this.scriptQueueVec.indexOf(rScript));
            String string3 = rScript2.getPeer() + "_" + rScript2.getTaskuid();
            rScript2.setError(rScript.getError());
            this.cache = this.getCache();
            IElementAttributes iElementAttributes = this.getGroupedCache().getDefaultElementAttributes();
            iElementAttributes.setMaxLifeSeconds((long)CACHE_GROUP_EXPIRY);
            this.getGroupedCache().putInGroup((Object)rScript.getUid(), CACHE_GROUP_FINISHED, (Object)rScript2.getDelay(), iElementAttributes);
            for (Object e : this.getGroupedCache().getGroupKeys(CACHE_GROUP_FINISHED)) {
                this.getGroupedCache().getFromGroup(e, CACHE_GROUP_FINISHED);
            }
            if (this.scriptQueueListener.get(rScript2.getUid()) != null) {
                Object object = this.scriptQueueListener.get(rScript2.getUid());
                try {
                    object.onScriptFinished(rScript2, rScript2.getPeer(), string, string2);
                }
                catch (Exception exception) {
                    ClientErrorMgmt.reportError(exception, "Error while invoking listener");
                }
                this.scriptQueueListener.remove(rScript2.getUid());
                object = null;
            }
            this.cache.remove((Object)string3);
            rScript2 = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.scriptQueueVec.remove(rScript);
        rScript = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processDependencyQueueItem(LoadBalancingQueueItem loadBalancingQueueItem) throws Exception {
        boolean bl = true;
        if (loadBalancingQueueItem != null) {
            Map map = loadBalancingQueueItem.getSf().getData();
            String string = (String)map.get(ScheduledTask.FIELD_DEPENDENCY_IDS);
            int n = 0;
            if (string != null && !string.equals("") && map.get(ScheduledTask.FIELD_DEPENDENCY_CHECKTIME) != null && !map.get(ScheduledTask.FIELD_DEPENDENCY_CHECKTIME).equals("")) {
                String string2 = (String)map.get(ScheduledTask.FIELD_DEPENDENCY_CHECKTIME);
                SchedulerDB schedulerDB = SchedulerDB.getSchedulerDB();
                try {
                    schedulerDB.connectDB(BBSyncMgmt.getDBName());
                    n = this.dependencyCheck(loadBalancingQueueItem, string, string2, schedulerDB);
                    if (n == 1) {
                        bl = true;
                    }
                    if (n == 0) {
                        bl = false;
                    }
                    if (n == -1) {
                        Object object;
                        bl = true;
                        loadBalancingQueueItem.getSf().setDependencyfailed(true);
                        String string3 = "Task timeout! Waited for dependencies until 1 minute before next execution time";
                        ExceptionDependencyTimeout exceptionDependencyTimeout = new ExceptionDependencyTimeout(string3);
                        schedulerDB.updateResponseCode(loadBalancingQueueItem.getSchedulerid(), loadBalancingQueueItem.getSf().getTrigger_time(), exceptionDependencyTimeout.getErrorcode());
                        loadBalancingQueueItem.getSf().setTasklog(string3);
                        String string4 = (String)map.get("alert_type");
                        String string5 = (String)map.get("name");
                        if (string4 != null && !string4.equals("")) {
                            object = new SchedulerAlert(loadBalancingQueueItem.getSchedulerid(), loadBalancingQueueItem.getSf().getTrigger_time());
                            ((SchedulerAlert)object).alert(string4, string5, SchedulerAlert.ALERT_SUB_TIMEOUT, string3, null, schedulerDB, exceptionDependencyTimeout, map);
                        }
                        if ((object = schedulerDB.getTaskEventActions(loadBalancingQueueItem.getSchedulerid(), loadBalancingQueueItem.getSf().getTrigger_time())).containsKey(ScheduledTask.FIELD_DEPENDENCY_TIMEOUT) && object.get(ScheduledTask.FIELD_DEPENDENCY_TIMEOUT) != null && !((String)object.get(ScheduledTask.FIELD_DEPENDENCY_TIMEOUT)).trim().equals("")) {
                            String string6 = (String)object.get(ScheduledTask.FIELD_DEPENDENCY_TIMEOUT);
                            String string7 = ScheduledTask.TASK_EVENT_CALL_EXP_ID_VARIABLE + "=" + loadBalancingQueueItem.getSchedulerid() + "\n";
                            string7 = string7 + ScheduledTask.TASK_EVENT_CALL_EXP_TRIGGERTIME_VARIABLE + "=" + loadBalancingQueueItem.getSf().getTrigger_time() + "\n";
                            new SchedulerEngine().executeScriptExpression(string6, "onDependency timeout of " + loadBalancingQueueItem.getSchedulerid(), string7);
                        }
                    }
                }
                catch (Exception exception) {
                    this.log.error((Object)("Error at processDependencyQueueItem:" + exception.getMessage()));
                }
                finally {
                    schedulerDB.closeDB();
                }
            }
            map = null;
        }
        return bl;
    }

    private boolean processValidateQueueItem(LoadBalancingQueueItem loadBalancingQueueItem) throws Exception {
        boolean bl = true;
        for (LoadBalancingQueueItem loadBalancingQueueItem2 : this.queue) {
            String string;
            Map map;
            if (loadBalancingQueueItem2 == null || loadBalancingQueueItem2.getSf() == null || loadBalancingQueueItem2.getSf().getTask() == null || loadBalancingQueueItem.getSf() == null || loadBalancingQueueItem.getSf().getTask() == null || loadBalancingQueueItem2.getSf().getData() == null) continue;
            if (loadBalancingQueueItem.getSchedulerid() != loadBalancingQueueItem2.getSchedulerid() && loadBalancingQueueItem.getSf().getTask().getUniqueid().equals(loadBalancingQueueItem2.getSf().getTask().getUniqueid()) && loadBalancingQueueItem.getSf().getTrigger_time() > loadBalancingQueueItem2.getSf().getTrigger_time()) {
                map = loadBalancingQueueItem2.getSf().getData();
                string = (String)map.get(ScheduledTask.FIELD_DEPENDENCY_CHECKTIME);
                if (string != null) continue;
                bl = false;
                continue;
            }
            map = loadBalancingQueueItem2.getSf().getData();
            string = (String)map.get(ScheduledTask.FIELD_DEPENDENCY_CHECKTIME);
            if (loadBalancingQueueItem.getSf().getTrigger_time() == loadBalancingQueueItem2.getSf().getTrigger_time() && string == null && loadBalancingQueueItem.getSf().getTask().getUniqueid().equals(loadBalancingQueueItem2.getSf().getTask().getUniqueid()) && (loadBalancingQueueItem.getLastExecutedDuration() <= 0L && loadBalancingQueueItem2.getLastExecutedDuration() > 0L || loadBalancingQueueItem2.getLastExecutedDuration() > 0L && loadBalancingQueueItem.getLastExecutedDuration() > 0L && loadBalancingQueueItem.getLastExecutedDuration() > loadBalancingQueueItem2.getLastExecutedDuration())) {
                bl = false;
            }
            if (!priorityQueue) continue;
            Vector vector = this.getGroupOrder();
            if (vector != null && vector.indexOf(loadBalancingQueueItem.getSf().getTask().getUniqueid()) > vector.indexOf(loadBalancingQueueItem2.getSf().getTask().getUniqueid())) {
                String string2 = loadBalancingQueueItem2.getSf().getTask().getUniqueid();
                this.log.debug((Object)("found priority group:" + string2));
                SchedulerMgmt schedulerMgmt = new SchedulerMgmt();
                Map map2 = schedulerMgmt.getOnlinePeers();
                if (map2 != null && map2.size() > 0) {
                    this.log.debug((Object)("online peers:" + map2.keySet()));
                    Vector<Object> vector2 = this.getRunOnlyOn(string2);
                    String string3 = "";
                    for (String string4 : map2.keySet()) {
                        if (vector2 == null || !vector2.contains(string4)) continue;
                        string3 = string3 + (string3.equals("") ? "'" + string4 + "'" : ",'" + string4 + "'");
                    }
                    this.log.debug((Object)("peer query:" + string3));
                    Object object = this.getPeers4PriorityGr(string3, "'" + string2 + "'");
                    this.log.debug((Object)("avail peers for prioiry:" + object));
                    if (object != null && ((Vector)object).size() > 0) {
                        bl = false;
                    }
                    this.log.debug((Object)("=======================================" + object));
                    object = null;
                    vector2 = null;
                }
                map2 = null;
            }
            map = null;
            vector = null;
        }
        return bl;
    }

    private void processQueueItem(LoadBalancingQueueItem loadBalancingQueueItem) throws Exception {
        if (loadBalancingQueueItem != null && !loadBalancingQueueItem.isExecuting()) {
            String string = loadBalancingQueueItem.getSf().getTask().getUniqueid();
            Vector<Object> vector = this.getRunOnlyOn(string);
            boolean bl = false;
            if (bl && !ScheduledTaskQueue.isExecutingOrQueued() || loadBalancingQueueItem.getSf().isDependencyfailed()) {
                loadBalancingQueueItem.getSf().addCallBack(new StackFrameCallBack(){

                    @Override
                    public void callBack(StackFrame stackFrame, String string, SchedulerException schedulerException) {
                        String string2 = stackFrame.getData().get("id") + "";
                        try {
                            int n = Integer.parseInt(string2);
                            IncomingMessage.updateFinishedPeersTime(P2PService.getComputerName(), n, stackFrame.getTrigger_time());
                            LoadBalancingLinkedQueue.this.executionEnded(n);
                        }
                        catch (Exception exception) {
                            LoadBalancingLinkedQueue.this.log.error((Object)("error 28:" + exception.getMessage()));
                        }
                    }
                });
                ScheduledTaskQueue.add(loadBalancingQueueItem.getSf());
                this.executionStarted(loadBalancingQueueItem, loadBalancingQueueItem.getSf().getTrigger_time(), P2PService.getComputerName());
                IncomingMessage.updateExecutingPeersTime(P2PService.getComputerName(), "BUSY", loadBalancingQueueItem.getSchedulerid(), loadBalancingQueueItem.getSf().getTrigger_time());
            } else if (vector != null) {
                Vector vector2 = (Vector)vector.clone();
                if (vector2 != null && vector2.size() > 0) {
                    this.sendTask2Peer(vector2, loadBalancingQueueItem.getSchedulerid(), loadBalancingQueueItem.getSf().getTrigger_time(), loadBalancingQueueItem.getSf().getNexttrigger_time(), loadBalancingQueueItem.getSf().getTask().getUniqueid());
                }
                vector2 = null;
            }
            if (vector != null) {
                vector.clear();
            }
            vector = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateLogTimes(LoadBalancingQueueItem loadBalancingQueueItem) {
        if (loadBalancingQueueItem.getStarted() != null) {
            SchedulerDB schedulerDB = SchedulerDB.getSchedulerDB();
            try {
                schedulerDB.connectDB(BBSyncMgmt.getDBName());
                schedulerDB.updateServerStartEnd(loadBalancingQueueItem.getSchedulerid(), loadBalancingQueueItem.getSf().getNexttrigger_time(), loadBalancingQueueItem.getStarted(), new Date());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            finally {
                try {
                    schedulerDB.closeDB();
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    public boolean killQueuedTask(int n, long l) {
        boolean bl = false;
        Iterator iterator = this.queue.iterator();
        while (iterator.hasNext() && !bl) {
            LoadBalancingQueueItem loadBalancingQueueItem = (LoadBalancingQueueItem)iterator.next();
            if (loadBalancingQueueItem.getSchedulerid() != n || loadBalancingQueueItem.getSf() == null || loadBalancingQueueItem.getSf().getTrigger_time() != l) continue;
            new SchedulerExePlanLogs(n, l).log("Queued task killed by user", 0);
            this.removeFromQueue(loadBalancingQueueItem);
            bl = true;
        }
        return bl;
    }

    @Override
    public LoadBalancingQueueItem getItemFromProcessingQueue(int n, long l) {
        LoadBalancingQueueItem loadBalancingQueueItem = null;
        for (LoadBalancingQueueItem loadBalancingQueueItem2 : this.queueprocessing) {
            if (loadBalancingQueueItem2.getSchedulerid() != n || loadBalancingQueueItem2.getSf() == null || loadBalancingQueueItem2.getSf().getTrigger_time() != l) continue;
            loadBalancingQueueItem = loadBalancingQueueItem2;
        }
        return loadBalancingQueueItem;
    }

    @Override
    public boolean removeFaultyProcessingTask(int n, long l) {
        boolean bl = false;
        LoadBalancingQueueItem loadBalancingQueueItem = null;
        Iterator<LoadBalancingQueueItem> iterator = this.queueprocessing.iterator();
        while (iterator.hasNext() && !bl) {
            LoadBalancingQueueItem loadBalancingQueueItem2 = iterator.next();
            if (loadBalancingQueueItem2.getSchedulerid() != n || loadBalancingQueueItem2.getSf() == null || loadBalancingQueueItem2.getSf().getTrigger_time() != l) continue;
            loadBalancingQueueItem = loadBalancingQueueItem2;
        }
        if (loadBalancingQueueItem != null) {
            try {
                this.removeItemProcessing(loadBalancingQueueItem, null, 0);
                bl = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return bl;
    }

    @Override
    public synchronized int startedIfNotStarted(int n, long l, String string) {
        int n2 = -1;
        for (LoadBalancingQueueItem loadBalancingQueueItem : this.queue) {
            if (loadBalancingQueueItem.getSchedulerid() == n && loadBalancingQueueItem.isExecuting()) {
                n2 = 0;
            }
            if (loadBalancingQueueItem.getSchedulerid() != n || loadBalancingQueueItem.isExecuting()) continue;
            n2 = 1;
            this.executionStarted(loadBalancingQueueItem, l, string);
        }
        return n2;
    }

    @Override
    public synchronized void executionFailed(int n, long l, String string) {
        for (LoadBalancingQueueItem loadBalancingQueueItem : this.queueprocessing) {
            if (loadBalancingQueueItem.getSchedulerid() != n || !loadBalancingQueueItem.getMachine().equals(string)) continue;
            loadBalancingQueueItem.setMachine(null);
            loadBalancingQueueItem.setExecuting(false);
            loadBalancingQueueItem.setStarted(null);
            this.removeItemProcessing(loadBalancingQueueItem, null, 0);
            this.queue.add((Object)loadBalancingQueueItem);
        }
    }

    private synchronized void executionStarted(LoadBalancingQueueItem loadBalancingQueueItem, long l, String string) {
        loadBalancingQueueItem.setMachine(string);
        loadBalancingQueueItem.setExecuting(true);
        loadBalancingQueueItem.setStarted(new Date());
        this.removeFromQueue(loadBalancingQueueItem);
        Debugger.addDebugMsg("script id:" + loadBalancingQueueItem.getSchedulerid() + " execution starting and removing from LB queue", "" + loadBalancingQueueItem.getSchedulerid());
        this.addItemProcessing(loadBalancingQueueItem);
        Debugger.addDebugMsg("script id:" + loadBalancingQueueItem.getSchedulerid() + " adding to LB executing Queue", "" + loadBalancingQueueItem.getSchedulerid());
    }

    @Override
    public void executionEnded(int n) {
        LoadBalancingQueueItem loadBalancingQueueItem = new LoadBalancingQueueItem();
        loadBalancingQueueItem.setSchedulerid(n);
        LoadBalancingQueueItem loadBalancingQueueItem2 = this.getItemFromQueue(this.queueprocessing, loadBalancingQueueItem);
        if (this.queueprocessing.contains(loadBalancingQueueItem2)) {
            this.removeItemProcessing(loadBalancingQueueItem2, null, 0);
        }
        this.lastExcecutedTime = new Date().getTime();
    }

    @Override
    public void executionEnded(int n, long l) {
        LoadBalancingQueueItem loadBalancingQueueItem = new LoadBalancingQueueItem();
        loadBalancingQueueItem.setSchedulerid(n);
        LoadBalancingQueueItem loadBalancingQueueItem2 = null;
        for (LoadBalancingQueueItem loadBalancingQueueItem3 : this.queueprocessing) {
            if (loadBalancingQueueItem3.getSchedulerid() != n || loadBalancingQueueItem3.getSf() == null || loadBalancingQueueItem3.getSf().getTrigger_time() != l) continue;
            loadBalancingQueueItem2 = loadBalancingQueueItem3;
        }
        if (this.queueprocessing.contains(loadBalancingQueueItem2)) {
            this.removeItemProcessing(loadBalancingQueueItem2, null, 0);
        }
        this.lastExcecutedTime = new Date().getTime();
    }

    @Override
    public void cleanupProccesingQueue(int n, String string) {
        LoadBalancingQueueItem loadBalancingQueueItem = new LoadBalancingQueueItem();
        loadBalancingQueueItem.setSchedulerid(n);
        LoadBalancingQueueItem loadBalancingQueueItem2 = this.getItemFromQueue(this.queueprocessing, loadBalancingQueueItem);
        if (this.queueprocessing.contains(loadBalancingQueueItem2) && loadBalancingQueueItem2.getMachine().equals(string)) {
            this.removeItemProcessing(loadBalancingQueueItem2, null, 0);
        }
    }

    private LoadBalancingQueueItem getItemFromQueue(Collection<LoadBalancingQueueItem> collection, LoadBalancingQueueItem loadBalancingQueueItem) {
        LoadBalancingQueueItem loadBalancingQueueItem2 = null;
        if (collection.contains(loadBalancingQueueItem)) {
            for (LoadBalancingQueueItem loadBalancingQueueItem3 : collection) {
                if (loadBalancingQueueItem3.getSchedulerid() != loadBalancingQueueItem.getSchedulerid()) continue;
                loadBalancingQueueItem2 = loadBalancingQueueItem3;
            }
        }
        return loadBalancingQueueItem2;
    }

    @Override
    public Collection<LoadBalancingQueueItem> getExecutingTasks() {
        return this.queueprocessing;
    }

    @Override
    public Collection<LoadBalancingQueueItem> getQueuedTasks() {
        return this.queue;
    }

    private synchronized void publishTender(Vector<Object> vector, LoadBalancingQueueItem loadBalancingQueueItem) throws Exception {
        Object object22;
        boolean bl = true;
        Vector vector2 = (Vector)this.shuffleIteration.clone();
        Vector vector3 = new Vector();
        for (Object object22 : vector2) {
            if (!vector.contains(object22)) continue;
            vector3.add(object22);
        }
        vector.removeAll(vector3);
        vector.addAll(vector3);
        PeerGroup peerGroup = P2PService.getPeerGroup();
        object22 = loadBalancingQueueItem.getSf();
        MessageBean messageBean = new MessageBean();
        messageBean.setType(MessageBean.TYPE_REQUEST);
        messageBean.setReply(MessageBean.REPLYBACK);
        if (((StackFrame)object22).getTask() != null) {
            messageBean.setCommand("EXECUTETASK:" + loadBalancingQueueItem.getSchedulerid() + ":" + ((StackFrame)object22).getTrigger_time() + ":" + ((StackFrame)object22).getNexttrigger_time() + ":" + ((StackFrame)object22).getTask().getUniqueid() + ":TENDER");
        } else {
            messageBean.setCommand("EXECUTETASK:" + loadBalancingQueueItem.getSchedulerid() + ":" + ((StackFrame)object22).getTrigger_time() + ":" + ((StackFrame)object22).getNexttrigger_time() + ":" + ":TENDER");
        }
        boolean bl2 = true;
        boolean bl3 = false;
        for (String string : vector) {
            Debugger.addDebugMsg("Msg to peer " + string + " sc_id:" + loadBalancingQueueItem.getSchedulerid() + " tr_time: " + ((StackFrame)object22).getTrigger_time(), string + " " + loadBalancingQueueItem.getSchedulerid() + " " + ((StackFrame)object22).getTrigger_time());
            PipeAdvertisement pipeAdvertisement = new P2PAdvertisement().getPipeAdvertisement(string, peerGroup);
            OutgoingMessageCallBack outgoingMessageCallBack = new OutgoingMessageCallBack(){};
            outgoingMessageCallBack.setPriority(OutgoingMessageCallBack.PRIORITY_NORMAL);
            OutgoingMessage outgoingMessage = new OutgoingMessage(outgoingMessageCallBack, messageBean, string);
            PipeService pipeService = P2PService.getPipeService();
            try {
                pipeService.createOutputPipe(pipeAdvertisement, (OutputPipeListener)outgoingMessage);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (bl) {
                if (this.shuffleIteration.contains(string)) {
                    this.shuffleIteration.remove(string);
                }
                this.shuffleIteration.add(string);
            }
            bl = false;
            Thread.sleep(20L);
            pipeService = null;
            outgoingMessage = null;
            outgoingMessageCallBack = null;
            pipeAdvertisement = null;
        }
        vector2 = null;
        vector3 = null;
    }

    @Override
    public synchronized void executeScript(Vector<Object> vector, int n) throws Exception {
        Object object22;
        boolean bl = true;
        Vector vector2 = (Vector)this.shuffleIteration.clone();
        Vector vector3 = new Vector();
        for (Object object22 : vector2) {
            if (!vector.contains(object22)) continue;
            vector3.add(object22);
        }
        vector.removeAll(vector3);
        vector.addAll(vector3);
        PeerGroup peerGroup = P2PService.getPeerGroup();
        object22 = new MessageBean();
        ((MessageBean)object22).setType(MessageBean.TYPE_REQUEST);
        ((MessageBean)object22).setReply(MessageBean.REPLYBACK);
        ((MessageBean)object22).setCommand("EXECUTESCRIPT:" + n + ":CONFIRM");
        for (String string : vector) {
            PipeAdvertisement pipeAdvertisement = new P2PAdvertisement().getPipeAdvertisement(string, peerGroup);
            OutgoingMessageCallBack outgoingMessageCallBack = new OutgoingMessageCallBack(){};
            outgoingMessageCallBack.setPriority(OutgoingMessageCallBack.PRIORITY_NORMAL);
            OutgoingMessage outgoingMessage = new OutgoingMessage(outgoingMessageCallBack, (MessageBean)object22, string);
            PipeService pipeService = P2PService.getPipeService();
            try {
                pipeService.createOutputPipe(pipeAdvertisement, (OutputPipeListener)outgoingMessage);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            Thread.sleep(20L);
        }
    }

    private Vector getGroupOrder() throws Exception {
        SchedulerDB schedulerDB;
        Vector vector;
        if (this.cache == null) {
            this.getCache();
        }
        if ((vector = (Vector)this.cache.get((Object)"taskgroup_order")) != null && vector.size() > 0) {
            schedulerDB = vector.get(0);
        }
        if (vector == null) {
            schedulerDB = SchedulerDB.getSchedulerDB();
            try {
                schedulerDB.connectDB(BBSyncMgmt.getDBName());
                vector = schedulerDB.getGroupOrder();
                IElementAttributes iElementAttributes = this.cache.getDefaultElementAttributes();
                iElementAttributes.setMaxLifeSeconds(7L);
                this.cache.put((Object)"taskgroup_order", (Object)vector, iElementAttributes);
            }
            catch (Exception exception) {
                throw exception;
            }
            finally {
                schedulerDB.closeDB();
            }
        }
        return vector;
    }

    public Map<String, Integer> debug_data() {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        hashMap.put("scriptQueueListener_size", this.scriptQueueListener.size());
        hashMap.put("scriptQueueVec_size", this.scriptQueueVec.size());
        hashMap.put("scriptQueue_size", this.scriptQueue.size());
        hashMap.put("queue_size", this.queue.size());
        hashMap.put("queueprocessing_size", this.queueprocessing.size());
        return hashMap;
    }

    @Override
    public void peerStarted(int n, long l, String string) throws Exception {
    }

    @Override
    public Collection<RScript> getScriptQueue() throws Exception {
        return this.scriptQueue;
    }

    @Override
    public Collection<RScript> getScriptProcessingQueue() throws Exception {
        return this.scriptQueueProcessing;
    }

    @Override
    public void removeScriptFromAllQueue(RScript rScript) {
        try {
            this.scriptQueueProcessing.remove(rScript);
            RScript rScript2 = this.scriptQueueVec.get(this.scriptQueueVec.indexOf(rScript));
            String string = rScript2.getPeer() + "_" + rScript2.getTaskuid();
            rScript2.setError(rScript.getError());
            this.cache = this.getCache();
            this.cache.remove((Object)string);
            this.scriptQueueVec.remove(rScript);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

