/*
 * Decompiled with CFR 0.152.
 */
package com.fe.svn;

import com.fe.Config;
import com.fe.svn.LogEntryHandler;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.tmatesoft.svn.core.ISVNLogEntryHandler;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNDirEntry;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLogEntry;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNProperty;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.io.dav.DAVRepositoryFactory;
import org.tmatesoft.svn.core.internal.io.fs.FSRepositoryFactory;
import org.tmatesoft.svn.core.internal.io.svn.SVNRepositoryFactoryImpl;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNOptions;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.wc.SVNClientManager;
import org.tmatesoft.svn.core.wc.SVNCommitClient;
import org.tmatesoft.svn.core.wc.SVNDiffClient;
import org.tmatesoft.svn.core.wc.SVNLogClient;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNUpdateClient;
import org.tmatesoft.svn.core.wc.SVNWCClient;
import org.tmatesoft.svn.core.wc.SVNWCUtil;

public class SVNSync {
    private Logger log = Logger.getLogger(SVNSync.class);
    private String svnurl = "svn://10.153.64.3/scheduler";
    private String local = "C:\\temp_repotest1\\sc3";
    private File dstPath = null;
    SVNClientManager cm = null;

    public SVNSync(String string, String string2) {
        this.init(string, string2);
    }

    private void init(String string, String string2) {
        SVNSync.setupLibrary();
        this.cm = SVNClientManager.newInstance((DefaultSVNOptions)SVNWCUtil.createDefaultOptions((boolean)true), (String)string, (String)string2);
        this.svnurl = Config.getString("svn_url");
        this.local = Config.getString("svn_local_path");
        this.dstPath = new File(this.local);
    }

    public SVNSync() {
        String string = Config.getString("svn_user");
        String string2 = Config.getString("svn_pwd");
        this.init(string, string2);
    }

    public long syncScript(int n, String string, String string2) {
        long l = -1L;
        try {
            String string3;
            SVNURL sVNURL = SVNURL.parseURIEncoded((String)this.svnurl);
            SVNUpdateClient sVNUpdateClient = this.cm.getUpdateClient();
            if (!SVNWCUtil.isVersionedDirectory((File)this.dstPath)) {
                sVNUpdateClient.doCheckout(sVNURL, this.dstPath, SVNRevision.UNDEFINED, SVNRevision.HEAD, true);
                sVNUpdateClient.doUpdate(this.dstPath, SVNRevision.HEAD, true);
            } else {
                this.log.debug((Object)("~~~~~~" + this.dstPath.getPath() + " it is already working copy...."));
            }
            BufferedReader bufferedReader = new BufferedReader(new StringReader(string));
            StringBuffer stringBuffer = new StringBuffer();
            File file = new File(this.local, "script_" + n + ".R");
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
            while ((string3 = bufferedReader.readLine()) != null) {
                if (string3 != null && string3.equals("")) {
                    bufferedWriter.write(string3 + "\n");
                }
                if (string3 == null || string3.equals("")) continue;
                bufferedWriter.write(string3 + "\n");
            }
            bufferedWriter.close();
            bufferedReader.close();
            SVNWCClient sVNWCClient = this.cm.getWCClient();
            try {
                sVNWCClient.doInfo(file, SVNRevision.HEAD);
            }
            catch (SVNException sVNException) {
                if (sVNException.getMessage().contains("is not under version control")) {
                    sVNWCClient.doAdd(file, false, false, false, true);
                    this.log.debug((Object)("~~~~~ file:" + file + " is not under version control"));
                }
                this.log.debug((Object)("~~~~~ file:" + file + " is under version control"));
            }
            SVNCommitClient sVNCommitClient = this.cm.getCommitClient();
            SVNCommitInfo sVNCommitInfo = sVNCommitClient.doCommit(new File[]{file}, false, string2, false, true);
            l = sVNCommitInfo.getNewRevision();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return l;
    }

    public String getLastChanged(int n) throws Exception {
        StringTokenizer stringTokenizer;
        long l;
        String string = "script_" + n + ".R";
        File file = new File(this.local, string);
        TreeSet<Long> treeSet = this.revisions(file);
        Vector<Long> vector = new Vector<Long>(treeSet);
        String string2 = null;
        if (treeSet.size() > 0 && vector.indexOf(treeSet.last()) > 0 && (string2 = this.diff(n, l = vector.get(vector.indexOf(treeSet.last()) - 1).longValue(), treeSet.last())) != null && (stringTokenizer = new StringTokenizer(string2, "\n\r")).countTokens() >= 4) {
            stringTokenizer.nextToken();
            stringTokenizer.nextToken();
            stringTokenizer.nextToken();
            stringTokenizer.nextToken();
            string2 = "";
            while (stringTokenizer.hasMoreTokens()) {
                string2 = string2 + stringTokenizer.nextToken() + "\n";
            }
        }
        return string2;
    }

    public Vector<SVNLogEntry> log(int n) throws Exception {
        File file = new File(this.local, "script_" + n + ".R");
        Vector<SVNLogEntry> vector = null;
        if (file.exists()) {
            SVNLogClient sVNLogClient = this.cm.getLogClient();
            long l = 250L;
            LogEntryHandler logEntryHandler = new LogEntryHandler();
            sVNLogClient.doLog(new File[]{file}, SVNRevision.create((long)0L), SVNRevision.create((long)0L), SVNRevision.HEAD, true, true, l, (ISVNLogEntryHandler)logEntryHandler);
            while (logEntryHandler.getLogMessages() == null) {
                Thread.sleep(100L);
            }
            vector = logEntryHandler.getLogMessages();
            Thread.sleep(100L);
        }
        return vector;
    }

    public Vector<SVNDirEntry> logTest() throws Exception {
        SVNLogClient sVNLogClient = this.cm.getLogClient();
        long l = 50L;
        LogEntryHandler logEntryHandler = new LogEntryHandler();
        SVNURL sVNURL = SVNURL.parseURIEncoded((String)this.svnurl);
        sVNLogClient.doLog(sVNURL, new String[0], SVNRevision.create((long)0L), SVNRevision.create((long)0L), SVNRevision.HEAD, true, true, 1L, (ISVNLogEntryHandler)logEntryHandler);
        while (logEntryHandler.getLogMessages() == null) {
            Thread.sleep(100L);
        }
        Vector<SVNLogEntry> vector = logEntryHandler.getLogMessages();
        Thread.sleep(100L);
        return vector;
    }

    public String diff(int n, long l, long l2) throws Exception {
        File file = new File(this.local, "script_" + n + ".R");
        String string = null;
        if (file.exists()) {
            SVNDiffClient sVNDiffClient = this.cm.getDiffClient();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            sVNDiffClient.doDiff(file, SVNRevision.create((long)l), SVNRevision.create((long)l), SVNRevision.create((long)l2), true, false, (OutputStream)byteArrayOutputStream);
            string = byteArrayOutputStream.toString();
        }
        return string;
    }

    public String diffWC(int n, long l) throws Exception {
        File file = new File(this.local, "script_" + n + ".R");
        String string = null;
        if (file.exists()) {
            SVNDiffClient sVNDiffClient = this.cm.getDiffClient();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            sVNDiffClient.doDiff(file, SVNRevision.create((long)l), SVNRevision.create((long)l), SVNRevision.HEAD, true, false, (OutputStream)byteArrayOutputStream);
            string = byteArrayOutputStream.toString();
        }
        return string;
    }

    public String getScript(int n, long l) throws Exception {
        String string = "script_" + n + ".R";
        SVNRepository sVNRepository = this.cm.createRepository(SVNURL.parseURIEncoded((String)this.svnurl), false);
        SVNNodeKind sVNNodeKind = sVNRepository.checkPath(string, -1L);
        if (sVNNodeKind == SVNNodeKind.NONE) {
            throw new Exception("There is no entry at '" + this.svnurl + "'.");
        }
        if (sVNNodeKind == SVNNodeKind.DIR) {
            throw new Exception("The entry at '" + this.svnurl + "' is a directory while a file was expected.");
        }
        SVNProperties sVNProperties = new SVNProperties();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        sVNRepository.getFile(string, l, sVNProperties, (OutputStream)byteArrayOutputStream);
        Map map = sVNProperties.asMap();
        String string2 = (String)map.get("svn:mime-type");
        boolean bl = SVNProperty.isTextMimeType((String)string2);
        String string3 = null;
        if (bl) {
            string3 = byteArrayOutputStream.toString();
        } else {
            System.out.println("Not a text file.");
        }
        return string3;
    }

    private static void setupLibrary() {
        DAVRepositoryFactory.setup();
        SVNRepositoryFactoryImpl.setup();
        FSRepositoryFactory.setup();
    }

    public TreeSet<Long> revisions(File file) throws Exception {
        TreeSet<Long> treeSet = new TreeSet<Long>();
        if (file.exists()) {
            SVNLogClient sVNLogClient = this.cm.getLogClient();
            LogEntryHandler logEntryHandler = new LogEntryHandler();
            sVNLogClient.doLog(new File[]{file}, SVNRevision.create((long)0L), SVNRevision.create((long)0L), SVNRevision.HEAD, true, true, 0L, (ISVNLogEntryHandler)logEntryHandler);
            while (logEntryHandler.getLogMessages() == null) {
                Thread.sleep(100L);
            }
            Vector<SVNLogEntry> vector = logEntryHandler.getLogMessages();
            Thread.sleep(100L);
            for (SVNLogEntry sVNLogEntry : vector) {
                treeSet.add(sVNLogEntry.getRevision());
            }
        }
        return treeSet;
    }
}

