/*
 * Decompiled with CFR 0.152.
 */
package com.fe.test.svn;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.io.dav.DAVRepositoryFactory;
import org.tmatesoft.svn.core.internal.io.fs.FSRepositoryFactory;
import org.tmatesoft.svn.core.internal.io.svn.SVNRepositoryFactoryImpl;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.ISVNReporter;
import org.tmatesoft.svn.core.io.ISVNReporterBaton;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.io.SVNRepositoryFactory;
import org.tmatesoft.svn.core.io.diff.SVNDeltaProcessor;
import org.tmatesoft.svn.core.io.diff.SVNDiffWindow;
import org.tmatesoft.svn.core.wc.SVNWCUtil;

public class Export {
    public static void main(String[] stringArray) {
        Export.setupLibrary();
        try {
            Export.exportExample();
        }
        catch (SVNException sVNException) {
            for (SVNErrorMessage sVNErrorMessage = sVNException.getErrorMessage(); sVNErrorMessage != null; sVNErrorMessage = sVNErrorMessage.getChildErrorMessage()) {
                System.err.println(sVNErrorMessage.getErrorCode().getCode() + " : " + sVNErrorMessage.getMessage());
            }
            System.exit(1);
        }
        System.exit(0);
    }

    private static void exportExample() throws SVNException {
        SVNURL sVNURL = SVNURL.parseURIEncoded((String)"svn://4ecapsvsg1/dbproj/trunk/bldb");
        String string = "svnrams";
        String string2 = "svnrams";
        File file = new File("c:\\rnd\\svnexport");
        if (!file.exists()) {
            file.mkdirs();
        }
        SVNRepository sVNRepository = SVNRepositoryFactory.create((SVNURL)sVNURL);
        ISVNAuthenticationManager iSVNAuthenticationManager = SVNWCUtil.createDefaultAuthenticationManager((String)string, (String)string2);
        sVNRepository.setAuthenticationManager(iSVNAuthenticationManager);
        SVNNodeKind sVNNodeKind = sVNRepository.checkPath("", -1L);
        if (sVNNodeKind == SVNNodeKind.NONE) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.UNKNOWN, (String)"No entry at URL ''{0}''", (Object)sVNURL);
            throw new SVNException(sVNErrorMessage);
        }
        if (sVNNodeKind == SVNNodeKind.FILE) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.UNKNOWN, (String)"Entry at URL ''{0}'' is a file while directory was expected", (Object)sVNURL);
            throw new SVNException(sVNErrorMessage);
        }
        long l = sVNRepository.getLatestRevision();
        ExportReporterBaton exportReporterBaton = new ExportReporterBaton(l);
        ExportEditor exportEditor = new ExportEditor(file);
        sVNRepository.update(l, null, true, (ISVNReporterBaton)exportReporterBaton, (ISVNEditor)exportEditor);
        System.out.println("Exported revision: " + l);
    }

    private static void setupLibrary() {
        DAVRepositoryFactory.setup();
        SVNRepositoryFactoryImpl.setup();
        FSRepositoryFactory.setup();
    }

    private static class ExportEditor
    implements ISVNEditor {
        private File myRootDirectory;
        private SVNDeltaProcessor myDeltaProcessor;

        public ExportEditor(File file) {
            this.myRootDirectory = file;
            this.myDeltaProcessor = new SVNDeltaProcessor();
        }

        public void targetRevision(long l) throws SVNException {
        }

        public void openRoot(long l) throws SVNException {
        }

        public void addDir(String string, String string2, long l) throws SVNException {
            File file = new File(this.myRootDirectory, string);
            if (!file.exists() && !file.mkdirs()) {
                SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.IO_ERROR, (String)"error: failed to add the directory ''{0}''.", (Object)file);
            }
            System.out.println("dir added: " + string);
        }

        public void openDir(String string, long l) throws SVNException {
        }

        public void changeDirProperty(String string, SVNPropertyValue sVNPropertyValue) throws SVNException {
        }

        public void addFile(String string, String string2, long l) throws SVNException {
            File file = new File(this.myRootDirectory, string);
            if (file.exists()) {
                SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.IO_ERROR, (String)"error: exported file ''{0}'' already exists!", (Object)file);
                System.out.println("File " + file.getPath() + " Already existings! updating");
            } else {
                System.out.println("creating file " + file.getPath());
            }
            try {
                file.createNewFile();
            }
            catch (IOException iOException) {
                SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.IO_ERROR, (String)"error: cannot create new  file ''{0}''", (Object)file);
                throw new SVNException(sVNErrorMessage);
            }
        }

        public void openFile(String string, long l) throws SVNException {
        }

        public void changeFileProperty(String string, String string2, SVNPropertyValue sVNPropertyValue) throws SVNException {
        }

        public void applyTextDelta(String string, String string2) throws SVNException {
            this.myDeltaProcessor.applyTextDelta((File)null, new File(this.myRootDirectory, string), false);
        }

        public OutputStream textDeltaChunk(String string, SVNDiffWindow sVNDiffWindow) throws SVNException {
            return this.myDeltaProcessor.textDeltaChunk(sVNDiffWindow);
        }

        public void textDeltaEnd(String string) throws SVNException {
            this.myDeltaProcessor.textDeltaEnd();
        }

        public void closeFile(String string, String string2) throws SVNException {
        }

        public void closeDir() throws SVNException {
        }

        public void deleteEntry(String string, long l) throws SVNException {
        }

        public void absentDir(String string) throws SVNException {
        }

        public void absentFile(String string) throws SVNException {
        }

        public SVNCommitInfo closeEdit() throws SVNException {
            return null;
        }

        public void abortEdit() throws SVNException {
        }
    }

    private static class ExportReporterBaton
    implements ISVNReporterBaton {
        private long exportRevision;

        public ExportReporterBaton(long l) {
            this.exportRevision = l;
        }

        public void report(ISVNReporter iSVNReporter) throws SVNException {
            try {
                iSVNReporter.setPath("", null, this.exportRevision, SVNDepth.INFINITY, true);
                iSVNReporter.finishReport();
            }
            catch (SVNException sVNException) {
                iSVNReporter.abortReport();
                System.out.println("Report failed.");
            }
        }
    }
}

