/*
 * Decompiled with CFR 0.152.
 */
package com.fe.util;

import com.fe.client.ClientErrorMgmt;
import java.text.SimpleDateFormat;
import java.util.Collection;
import org.tmatesoft.svn.core.SVNDirEntry;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLogEntry;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.io.dav.DAVRepositoryFactory;
import org.tmatesoft.svn.core.internal.io.fs.FSRepositoryFactory;
import org.tmatesoft.svn.core.internal.io.svn.SVNRepositoryFactoryImpl;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.io.SVNRepositoryFactory;
import org.tmatesoft.svn.core.wc.SVNWCUtil;

public class SVNInfo {
    private String url = "svn://10.153.64.3/dbproj/trunk/bldb";
    private String name = "svnrams";
    private String password = "svnrams";
    private long startRevision = 0L;
    private SVNRepository repository = null;

    public SVNInfo() {
    }

    public SVNInfo(String string) {
        this.url = string;
    }

    public SVNRepository getRepository() throws Exception {
        return this.repository;
    }

    public boolean connect() throws Exception {
        SVNInfo.setupLibrary();
        try {
            this.repository = SVNRepositoryFactory.create((SVNURL)SVNURL.parseURIEncoded((String)this.url));
        }
        catch (SVNException sVNException) {
            ClientErrorMgmt.reportError((Exception)((Object)sVNException), null);
            throw sVNException;
        }
        ISVNAuthenticationManager iSVNAuthenticationManager = SVNWCUtil.createDefaultAuthenticationManager((String)this.name, (String)this.password);
        this.repository.setAuthenticationManager(iSVNAuthenticationManager);
        return true;
    }

    public long getRevisionNo() throws Exception {
        try {
            Collection collection = null;
            SVNDirEntry sVNDirEntry = this.repository.getDir("", -1L, true, collection);
            if (sVNDirEntry != null) {
                return sVNDirEntry.getRevision();
            }
            return 0L;
        }
        catch (SVNException sVNException) {
            ClientErrorMgmt.reportError((Exception)((Object)sVNException), "error while fetching the latest repository revision: ");
            throw sVNException;
        }
    }

    public String getLastRevisionDate() throws Exception {
        try {
            Collection collection = this.repository.log(new String[]{""}, null, this.getRevisionNo(), this.getRevisionNo(), true, true);
            if (collection.size() > 0) {
                SVNLogEntry sVNLogEntry = (SVNLogEntry)collection.iterator().next();
                return new SimpleDateFormat("dd-MMM-yy").format(sVNLogEntry.getDate());
            }
            return null;
        }
        catch (SVNException sVNException) {
            ClientErrorMgmt.reportError((Exception)((Object)sVNException), "error while fetching the log entries: ");
            throw sVNException;
        }
    }

    public SVNLogEntry logMessage(long l) throws Exception {
        try {
            Collection collection = this.repository.log(new String[]{""}, null, l, l, true, true);
            if (collection.size() > 0) {
                SVNLogEntry sVNLogEntry = (SVNLogEntry)collection.iterator().next();
                return sVNLogEntry;
            }
            return null;
        }
        catch (SVNException sVNException) {
            ClientErrorMgmt.reportError((Exception)((Object)sVNException), "error while fetching the log entries: ");
            throw sVNException;
        }
    }

    public Collection<SVNLogEntry> logMessages() throws Exception {
        try {
            long l = this.getRevisionNo();
            Collection collection = this.repository.log(new String[]{""}, null, 0L, l, true, true);
            return collection;
        }
        catch (SVNException sVNException) {
            ClientErrorMgmt.reportError((Exception)((Object)sVNException), "error while fetching the log entries: ");
            throw sVNException;
        }
    }

    private static void setupLibrary() {
        DAVRepositoryFactory.setup();
        SVNRepositoryFactoryImpl.setup();
        FSRepositoryFactory.setup();
    }
}

