/*
 * Decompiled with CFR 0.152.
 */
package com.fe.xls.historical;

import com.fe.data.Strategy;
import com.fe.xls.listener.HistoricalRowListener;
import com.fe.xls.listener.HistoricalStrategySheetListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Date;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

public class XLStrgyContractHistoricalReader {
    private File file;
    private int sheetscount = 0;
    private static int STRATEGY_COMMODITY_ROW = 0;
    private static int STRATEGY_TITLE_ROW = 1;
    private static int STRATEGY_TITLE_CELL_START_AT = 2;
    private static int STRATEGY_DATE_CELL = 0;
    private static int DATA_ROW_START_AT = 3;
    private Logger log = Logger.getLogger(XLStrgyContractHistoricalReader.class);

    public XLStrgyContractHistoricalReader(File file) {
        this.file = file;
    }

    public void processFile(HistoricalStrategySheetListener historicalStrategySheetListener, HistoricalRowListener historicalRowListener) throws Exception {
        int n;
        FileInputStream fileInputStream = new FileInputStream(this.file);
        HSSFWorkbook hSSFWorkbook = new HSSFWorkbook((InputStream)fileInputStream);
        this.sheetscount = hSSFWorkbook.getNumberOfSheets();
        String[] stringArray = new String[hSSFWorkbook.getNumberOfSheets()];
        for (n = 0; n < hSSFWorkbook.getNumberOfSheets(); ++n) {
            stringArray[n] = hSSFWorkbook.getSheetName(n);
        }
        historicalStrategySheetListener.sheetsBegin(this.file.getName(), stringArray);
        for (n = 0; n < hSSFWorkbook.getNumberOfSheets(); ++n) {
            HSSFSheet hSSFSheet = hSSFWorkbook.getSheetAt(n);
            String string = this.getCommodidty(hSSFSheet);
            Vector vector = this.getStrategyTitles(hSSFSheet);
            if (!historicalStrategySheetListener.excecute(string, hSSFWorkbook.getSheetName(n), vector, n)) continue;
            for (int i = DATA_ROW_START_AT; i < hSSFSheet.getLastRowNum(); ++i) {
                HSSFRow hSSFRow = hSSFSheet.getRow(i);
                HSSFCell hSSFCell = hSSFRow.getCell(STRATEGY_DATE_CELL);
                Date date = null;
                if (hSSFCell != null) {
                    try {
                        date = hSSFCell.getDateCellValue();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                Vector vector2 = this.getStrategies(hSSFRow, vector, date);
                this.log.debug((Object)("contracts:" + vector2));
                if (historicalRowListener.excecuteContinue(hSSFWorkbook.getSheetName(n), date, vector2, i)) continue;
                i = hSSFSheet.getLastRowNum() + 1;
            }
        }
        historicalStrategySheetListener.sheetsEnd();
        ((InputStream)fileInputStream).close();
    }

    public int getSheetscount() {
        return this.sheetscount;
    }

    private Vector getStrategies(HSSFRow hSSFRow, Vector vector, Date date) {
        Vector<Strategy> vector2 = new Vector<Strategy>();
        int n = hSSFRow.getLastCellNum() > STRATEGY_TITLE_CELL_START_AT + vector.size() ? STRATEGY_TITLE_CELL_START_AT + vector.size() : hSSFRow.getLastCellNum();
        for (int i = STRATEGY_TITLE_CELL_START_AT; i < n; ++i) {
            Strategy strategy;
            HSSFCell hSSFCell = hSSFRow.getCell(i);
            if (hSSFCell == null) continue;
            if (hSSFCell.getCellType() == 0 && i - STRATEGY_TITLE_CELL_START_AT < vector.size() && vector.get(i - STRATEGY_TITLE_CELL_START_AT) != null) {
                strategy = new Strategy();
                strategy.setCdate(date);
                strategy.setName((String)vector.get(i - STRATEGY_TITLE_CELL_START_AT));
                strategy.setValue(hSSFCell.getNumericCellValue());
                vector2.add(strategy);
            }
            if (hSSFCell.getCellType() != 1 || hSSFCell.getStringCellValue() == null || i - STRATEGY_TITLE_CELL_START_AT >= vector.size() || vector.get(i - STRATEGY_TITLE_CELL_START_AT) == null) continue;
            strategy = new Strategy();
            strategy.setCdate(date);
            strategy.setName((String)vector.get(i - STRATEGY_TITLE_CELL_START_AT));
            strategy.setSvalue(hSSFCell.getStringCellValue());
            vector2.add(strategy);
        }
        return vector2;
    }

    private String getCommodidty(HSSFSheet hSSFSheet) {
        String string = null;
        boolean bl = false;
        HSSFRow hSSFRow = hSSFSheet.getRow(STRATEGY_COMMODITY_ROW);
        for (int i = STRATEGY_TITLE_CELL_START_AT; i < hSSFRow.getLastCellNum(); ++i) {
            HSSFCell hSSFCell = hSSFRow.getCell(i);
            if (hSSFCell == null || hSSFCell.getCellType() != 1 || hSSFCell.getStringCellValue() == null) continue;
            if (string == null) {
                string = hSSFCell.getStringCellValue();
                continue;
            }
            if (string.trim().equals(hSSFCell.getStringCellValue())) continue;
        }
        if (bl) {
            string = null;
        }
        return string;
    }

    private Vector getStrategyTitles(HSSFSheet hSSFSheet) throws Exception {
        Vector<String> vector = new Vector<String>();
        HSSFRow hSSFRow = hSSFSheet.getRow(STRATEGY_TITLE_ROW);
        for (int i = STRATEGY_TITLE_CELL_START_AT; i < hSSFRow.getLastCellNum(); ++i) {
            HSSFCell hSSFCell = hSSFRow.getCell(i);
            if (hSSFCell == null || hSSFCell.getCellType() != 1) continue;
            vector.add(hSSFCell.getStringCellValue());
        }
        return vector;
    }
}

