/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcs.auxiliary.lateral;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jcs.auxiliary.lateral.behavior.ILateralCacheManager;
import org.apache.jcs.auxiliary.lateral.behavior.ILateralCacheObserver;
import org.apache.jcs.auxiliary.lateral.behavior.ILateralCacheService;
import org.apache.jcs.engine.behavior.ICacheRestore;

public class LateralCacheRestore
implements ICacheRestore {
    private static final Log log = LogFactory.getLog((Class)LateralCacheRestore.class);
    private final ILateralCacheManager lcm;
    private boolean canFix = true;
    private Object lateralObj;

    public LateralCacheRestore(ILateralCacheManager lcm) {
        this.lcm = lcm;
    }

    public boolean canFix() {
        if (!this.canFix) {
            return this.canFix;
        }
        try {
            this.lateralObj = this.lcm.fixService();
        }
        catch (Exception ex) {
            log.error((Object)("Can't fix " + ex.getMessage()));
            this.canFix = false;
        }
        return this.canFix;
    }

    public void fix() {
        if (!this.canFix) {
            return;
        }
        this.lcm.fixCaches((ILateralCacheService)this.lateralObj, (ILateralCacheObserver)this.lateralObj);
        String msg = "Lateral connection resumed.";
        log.info((Object)msg);
        log.debug((Object)msg);
    }
}

