/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcs.auxiliary.remote.http.client;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jcs.auxiliary.remote.http.client.RemoteHttpCache;
import org.apache.jcs.auxiliary.remote.http.client.RemoteHttpCacheAttributes;
import org.apache.jcs.auxiliary.remote.http.client.RemoteHttpCacheManager;
import org.apache.jcs.auxiliary.remote.http.client.behavior.IRemoteHttpCacheClient;

public class RemoteHttpCacheMonitor
implements Runnable {
    private static final Log log = LogFactory.getLog((Class)RemoteHttpCacheMonitor.class);
    private static RemoteHttpCacheMonitor instance;
    private static long idlePeriod;
    private Set remoteHttpCaches = new HashSet();
    private boolean alright = true;
    static final int TIME = 0;
    static final int ERROR = 1;
    static int mode;

    public static void setIdlePeriod(long idlePeriod) {
        if (idlePeriod > RemoteHttpCacheMonitor.idlePeriod) {
            RemoteHttpCacheMonitor.idlePeriod = idlePeriod;
        }
    }

    private RemoteHttpCacheMonitor() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static RemoteHttpCacheMonitor getInstance() {
        Class clazz = RemoteHttpCacheMonitor.class;
        synchronized (clazz) {
            if (instance == null) {
                instance = new RemoteHttpCacheMonitor();
                return instance;
            }
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyError(RemoteHttpCache remoteCache) {
        if (log.isInfoEnabled()) {
            log.info((Object)("Notified of an error. " + remoteCache));
        }
        this.bad();
        RemoteHttpCacheMonitor remoteHttpCacheMonitor = this;
        synchronized (remoteHttpCacheMonitor) {
            this.remoteHttpCaches.add(remoteCache);
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (log.isInfoEnabled()) {
            log.info((Object)"Monitoring daemon started");
        }
        block15: while (true) {
            if (mode == 1) {
                RemoteHttpCacheMonitor remoteHttpCacheMonitor = this;
                synchronized (remoteHttpCacheMonitor) {
                    if (this.alright) {
                        try {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)"FAILURE DRIVEN MODE: cache monitor waiting for error");
                            }
                            this.wait();
                        }
                        catch (InterruptedException ignore) {
                            // empty catch block
                        }
                    }
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("TIME DRIVEN MODE: cache monitor sleeping for " + idlePeriod));
            }
            try {
                Thread.sleep(idlePeriod);
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
            RemoteHttpCacheMonitor ex = this;
            synchronized (ex) {
                this.alright = true;
            }
            HashSet remoteCachesToExamine = new HashSet();
            RemoteHttpCacheMonitor ignore = this;
            synchronized (ignore) {
                remoteCachesToExamine.addAll(this.remoteHttpCaches);
            }
            Iterator itr2 = remoteCachesToExamine.iterator();
            while (true) {
                if (!itr2.hasNext()) continue block15;
                try {
                    RemoteHttpCache remoteCache = (RemoteHttpCache)itr2.next();
                    if (remoteCache.getStatus() != 3) continue;
                    RemoteHttpCacheAttributes attributes = remoteCache.getRemoteHttpCacheAttributes();
                    IRemoteHttpCacheClient remoteService = RemoteHttpCacheManager.getInstance().createRemoteHttpCacheClientForAttributes(attributes);
                    if (log.isInfoEnabled()) {
                        log.info((Object)("Performing Alive check on service " + remoteService));
                    }
                    if (remoteService.isAlive()) {
                        remoteCache.fixCache(remoteService);
                        continue block15;
                    }
                    this.bad();
                    continue block15;
                }
                catch (Exception ex2) {
                    this.bad();
                    log.error((Object)ex2);
                    continue;
                }
                break;
            }
        }
    }

    private synchronized void bad() {
        this.alright = false;
    }

    static {
        idlePeriod = 3000L;
        mode = 1;
    }
}

