/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcs.utils.net;

import java.net.UnknownHostException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jcs.utils.net.HostNameUtil;

public final class AddressUtil {
    private static final Log log = LogFactory.getLog((Class)AddressUtil.class);
    public static final String DEFAULT_INTERNET_ADDRESS_OCTET_AS_STRING = "000";
    public static final String DEFAULT_INTERNET_ADDRESS_AS_STRING = "0.0.0.0";
    private static String currentAddressOctetAsString = null;

    private AddressUtil() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"private constructor");
        }
    }

    public static synchronized String obtainFinalThreeDigitsOfAddressAsString() {
        if (currentAddressOctetAsString == null) {
            currentAddressOctetAsString = AddressUtil.obtainFinalThreeDigitsOfAddressAsStringLookup();
        }
        return currentAddressOctetAsString;
    }

    private static String obtainFinalThreeDigitsOfAddressAsStringLookup() {
        String retval = DEFAULT_INTERNET_ADDRESS_OCTET_AS_STRING;
        try {
            int lastdot;
            String ipAsString = HostNameUtil.getLocalHostAddress();
            if (log.isInfoEnabled()) {
                log.info((Object)("obtainFinalThreeDigitsOfAddressAsStringLookup running; ipstring [" + ipAsString + "]"));
            }
            if ((lastdot = ipAsString.lastIndexOf(".")) != -1) {
                if (lastdot != ipAsString.length()) {
                    ipAsString = ipAsString.substring(lastdot + 1);
                    switch (ipAsString.length()) {
                        case 1: {
                            ipAsString = "00" + ipAsString;
                            break;
                        }
                        case 2: {
                            ipAsString = "0" + ipAsString;
                            break;
                        }
                        case 3: {
                            if (!log.isDebugEnabled()) break;
                            log.debug((Object)"3 digits is as we expect");
                            break;
                        }
                        default: {
                            log.warn((Object)("detected invalid ip octet length [" + ipAsString + "] will return default"));
                            ipAsString = DEFAULT_INTERNET_ADDRESS_OCTET_AS_STRING;
                        }
                    }
                    retval = ipAsString;
                } else {
                    log.warn((Object)("ip ends in . ip: " + ipAsString + "  returning default: " + DEFAULT_INTERNET_ADDRESS_OCTET_AS_STRING));
                }
            } else {
                log.warn((Object)("could not find a . in address: " + ipAsString + "  returning default: " + DEFAULT_INTERNET_ADDRESS_OCTET_AS_STRING));
            }
        }
        catch (UnknownHostException e1) {
            log.warn((Object)"problem getting host address.  returning default: 000");
        }
        return retval;
    }
}

