/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.net.sf.retrotranslator.runtime.impl;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.mozilla.javascript.net.sf.retrotranslator.runtime.asm.AnnotationVisitor;
import org.mozilla.javascript.net.sf.retrotranslator.runtime.asm.Type;
import org.mozilla.javascript.net.sf.retrotranslator.runtime.asm.signature.SignatureReader;
import org.mozilla.javascript.net.sf.retrotranslator.runtime.asm.signature.SignatureVisitor;
import org.mozilla.javascript.net.sf.retrotranslator.runtime.impl.AnnotationArray;
import org.mozilla.javascript.net.sf.retrotranslator.runtime.impl.AnnotationValue;
import org.mozilla.javascript.net.sf.retrotranslator.runtime.impl.ClassDescriptor;
import org.mozilla.javascript.net.sf.retrotranslator.runtime.impl.EnumValue;
import org.mozilla.javascript.net.sf.retrotranslator.runtime.impl.GenericDeclarationDescriptor;
import org.mozilla.javascript.net.sf.retrotranslator.runtime.impl.LazyList;
import org.mozilla.javascript.net.sf.retrotranslator.runtime.impl.LazyValue;
import org.mozilla.javascript.net.sf.retrotranslator.runtime.impl.MemberDescriptor;
import org.mozilla.javascript.net.sf.retrotranslator.runtime.impl.RuntimeTools;
import org.mozilla.javascript.net.sf.retrotranslator.runtime.impl.TypeDescriptor;
import org.mozilla.javascript.net.sf.retrotranslator.runtime.java.lang.annotation.Annotation_;
import org.mozilla.javascript.net.sf.retrotranslator.runtime.java.lang.reflect.TypeVariable_;
import org.mozilla.javascript.net.sf.retrotranslator.runtime.java.lang.reflect._Type;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodDescriptor
extends GenericDeclarationDescriptor
implements MemberDescriptor {
    private String name;
    private String desc;
    private ClassDescriptor classDescriptor;
    private LazyValue<Class, Method> method;
    private LazyValue<String, Class> returnType;
    private LazyValue<Object, Object> defaultValue;
    private LazyValue<Class, Constructor> constructor;
    private LazyValue<TypeDescriptor, Object> genericReturnType;
    private LazyList<TypeDescriptor, Object> genericParameterTypes;
    private LazyList<TypeDescriptor, Object> genericExceptionTypes;
    private LazyList<List<AnnotationValue>, Annotation_[]> parameterAnnotations;

    public MethodDescriptor(ClassDescriptor classDescriptor, int access, String name, String desc, String signature) {
        this.classDescriptor = classDescriptor;
        this.access = access;
        this.name = name;
        this.desc = desc;
        if (signature != null) {
            new SignatureReader(signature).accept(this);
        }
        this.returnType = this.createReturnType();
        if (name.equals("<init>")) {
            this.constructor = this.createConstructor();
        } else if (!name.equals("<clinit>")) {
            this.method = this.createMethod();
        }
        this.parameterAnnotations = this.createParameterAnnotations();
    }

    private LazyValue<String, Class> createReturnType() {
        return new LazyValue<String, Class>(this.desc){

            @Override
            protected Class resolve(String input) {
                return MethodDescriptor.this.getClassByType(Type.getReturnType(input));
            }

            @Override
            protected /* synthetic */ Object resolve(Object x0) {
                return this.resolve((String)x0);
            }
        };
    }

    private LazyValue<Class, Constructor> createConstructor() {
        return new LazyValue<Class, Constructor>(this.classDescriptor.getTarget()){

            @Override
            protected Constructor resolve(Class input) {
                for (Constructor<?> constructor : input.getDeclaredConstructors()) {
                    if (!RuntimeTools.getConstructorDescriptor(constructor).equals(MethodDescriptor.this.desc)) continue;
                    return constructor;
                }
                return null;
            }

            @Override
            protected /* synthetic */ Object resolve(Object x0) {
                return this.resolve((Class)x0);
            }
        };
    }

    private LazyValue<Class, Method> createMethod() {
        return new LazyValue<Class, Method>(this.classDescriptor.getTarget()){

            @Override
            protected Method resolve(Class input) {
                for (Method method : input.getDeclaredMethods()) {
                    if (!method.getName().equals(MethodDescriptor.this.name) || !Type.getMethodDescriptor(method).equals(MethodDescriptor.this.desc)) continue;
                    return method;
                }
                return null;
            }

            @Override
            protected /* synthetic */ Object resolve(Object x0) {
                return this.resolve((Class)x0);
            }
        };
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDesc() {
        return this.desc;
    }

    public Class getReturnType() {
        return this.returnType.get();
    }

    public Object getDefaultValue() {
        return this.defaultValue == null ? null : RuntimeTools.cloneNonEmptyArray(this.defaultValue.get());
    }

    public static MethodDescriptor getInstance(Method method) {
        ClassDescriptor classDescriptor = ClassDescriptor.getInstance(method.getDeclaringClass());
        String desc = Type.getMethodDescriptor(method);
        MethodDescriptor methodDescriptor = classDescriptor.getMethodDescriptor(new StringBuffer().append(method.getName()).append(desc).toString());
        if (methodDescriptor == null) {
            methodDescriptor = new MethodDescriptor(classDescriptor, method.getModifiers(), method.getName(), desc, null);
        }
        methodDescriptor.method.provide(method);
        return methodDescriptor;
    }

    public static MethodDescriptor getInstance(Constructor constructor) {
        ClassDescriptor classDescriptor = ClassDescriptor.getInstance(constructor.getDeclaringClass());
        String desc = RuntimeTools.getConstructorDescriptor(constructor);
        MethodDescriptor methodDescriptor = classDescriptor.getMethodDescriptor(new StringBuffer().append("<init>").append(desc).toString());
        if (methodDescriptor == null) {
            methodDescriptor = new MethodDescriptor(classDescriptor, constructor.getModifiers(), constructor.getName(), desc, null);
        }
        methodDescriptor.constructor.provide(constructor);
        return methodDescriptor;
    }

    @Override
    public Object getTarget() {
        return this.method != null ? (Constructor)((Object)this.method.get()) : (this.constructor != null ? this.constructor.get() : null);
    }

    public Method getMethod() {
        return this.method == null ? null : this.method.get();
    }

    public Constructor getConstructor() {
        return this.constructor == null ? null : this.constructor.get();
    }

    @Override
    public ClassDescriptor getClassDescriptor() {
        return this.classDescriptor;
    }

    @Override
    protected TypeVariable_ findTypeVariable(String name) {
        TypeVariable_ variable = this.getTypeVariable(name);
        return variable != null ? variable : this.classDescriptor.findTypeVariable(name);
    }

    public Annotation_[][] getParameterAnnotations() {
        return this.parameterAnnotations.getClone();
    }

    private LazyList<List<AnnotationValue>, Annotation_[]> createParameterAnnotations() {
        return new LazyList<List<AnnotationValue>, Annotation_[]>(){

            @Override
            protected Annotation_[] resolve(List<AnnotationValue> input) {
                return MethodDescriptor.this.createAnnotations(input);
            }

            protected Annotation_[][] newArray(int size) {
                return new Annotation_[Type.getArgumentTypes(MethodDescriptor.this.desc).length][];
            }

            @Override
            protected /* synthetic */ Object[] newArray(int x0) {
                return this.newArray(x0);
            }

            @Override
            protected /* synthetic */ Object resolve(Object x0) {
                return this.resolve((List)x0);
            }
        };
    }

    public Object getGenericReturnType() {
        return this.genericReturnType == null ? null : _Type.executeCheckCastInstruction(this.genericReturnType.get());
    }

    public Object[] getGenericParameterTypes() {
        return this.genericParameterTypes == null ? null : this.genericParameterTypes.getClone();
    }

    public Object[] getGenericExceptionTypes() {
        return this.genericExceptionTypes == null ? null : this.genericExceptionTypes.getClone();
    }

    @Override
    protected Annotation_[] createAnnotations(Annotation_[] declaredAnnotations) {
        return declaredAnnotations;
    }

    @Override
    public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
        if (!visible) {
            return EMPTY_VISITOR;
        }
        List<AnnotationValue> values = this.parameterAnnotations.get(parameter);
        if (values == null) {
            values = new ArrayList<AnnotationValue>();
            this.parameterAnnotations.set(parameter, values);
        }
        AnnotationValue value = new AnnotationValue(desc);
        values.add(value);
        return value;
    }

    @Override
    public void visit(String name, Object value) {
        this.setDefaultValue(value);
    }

    @Override
    public void visitEnum(String name, String desc, String value) {
        this.setDefaultValue(new EnumValue(desc, value));
    }

    @Override
    public AnnotationVisitor visitAnnotation(String name, String desc) {
        AnnotationValue value = new AnnotationValue(desc);
        this.setDefaultValue(value);
        return value;
    }

    @Override
    public AnnotationVisitor visitArray(String name) {
        AnnotationArray array = new AnnotationArray();
        this.setDefaultValue(array);
        return array;
    }

    @Override
    public SignatureVisitor visitParameterType() {
        TypeDescriptor descriptor = new TypeDescriptor();
        if (this.genericParameterTypes == null) {
            this.genericParameterTypes = this.getLazyList();
        }
        this.genericParameterTypes.add(descriptor);
        return descriptor;
    }

    @Override
    public SignatureVisitor visitReturnType() {
        TypeDescriptor descriptor = new TypeDescriptor();
        this.genericReturnType = this.getLazyType(descriptor);
        return descriptor;
    }

    @Override
    public SignatureVisitor visitExceptionType() {
        TypeDescriptor descriptor = new TypeDescriptor();
        if (this.genericExceptionTypes == null) {
            this.genericExceptionTypes = this.getLazyList();
        }
        this.genericExceptionTypes.add(descriptor);
        return descriptor;
    }

    private void setDefaultValue(Object o) {
        this.defaultValue = new LazyValue<Object, Object>(o){

            @Override
            protected Object resolve(Object input) {
                return MethodDescriptor.this.resolveValue(input, MethodDescriptor.this.getReturnType(), MethodDescriptor.this);
            }
        };
    }
}

