/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcs.auxiliary.remote.server;

import java.rmi.Naming;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jcs.auxiliary.remote.server.RemoteCacheServerFactory;
import org.apache.jcs.engine.logging.behavior.ICacheEventLogger;

public class RegistryKeepAliveRunner
implements Runnable {
    private static final Log log = LogFactory.getLog((Class)RegistryKeepAliveRunner.class);
    private String registryHost;
    private int registryPort;
    private String serviceName;
    private ICacheEventLogger cacheEventLogger;

    public RegistryKeepAliveRunner(String registryHost, int registryPort, String serviceName) {
        this.registryHost = registryHost;
        this.registryPort = registryPort;
        this.serviceName = serviceName;
    }

    public void run() {
        this.checkAndRestoreIfNeeded();
    }

    protected void checkAndRestoreIfNeeded() {
        String registry = "//" + this.registryHost + ":" + this.registryPort + "/" + this.serviceName;
        if (log.isDebugEnabled()) {
            log.debug((Object)("looking up server " + registry));
        }
        try {
            Remote obj = Naming.lookup(registry);
            String message = "RMI registry looks fine.  Found [" + obj + "] in registry [" + registry + "]";
            if (this.cacheEventLogger != null) {
                this.cacheEventLogger.logApplicationEvent("RegistryKeepAliveRunner", "Naming.lookup", message);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)message);
            }
            obj = null;
        }
        catch (Exception ex) {
            String message = "Problem finding server at [" + registry + "].  Will attempt to start registry and rebind.";
            log.error((Object)message, (Throwable)ex);
            if (this.cacheEventLogger != null) {
                this.cacheEventLogger.logError("RegistryKeepAliveRunner", "Naming.lookup", message + ":" + ex.getMessage());
            }
            this.createAndRegister(registry);
        }
    }

    protected void createAndRegister(String registry) {
        this.createReqistry(registry);
        this.registerServer(registry);
    }

    protected void createReqistry(String registry) {
        block3: {
            try {
                LocateRegistry.createRegistry(this.registryPort);
                String message = "Successfully created registry [" + registry + "].";
                if (this.cacheEventLogger != null) {
                    this.cacheEventLogger.logApplicationEvent("RegistryKeepAliveRunner", "createRegistry", message);
                }
            }
            catch (RemoteException e) {
                String message = "Could not start registry [" + registry + "].";
                log.error((Object)message, (Throwable)e);
                if (this.cacheEventLogger == null) break block3;
                this.cacheEventLogger.logError("RegistryKeepAliveRunner", "createRegistry", message + ":" + e.getMessage());
            }
        }
    }

    protected void registerServer(String registry) {
        block4: {
            try {
                RemoteCacheServerFactory.registerServer(this.registryHost, this.registryPort, this.serviceName);
                String message = "Successfully rebound server to registry [" + registry + "].";
                if (this.cacheEventLogger != null) {
                    this.cacheEventLogger.logApplicationEvent("RegistryKeepAliveRunner", "registerServer", message);
                }
                if (log.isInfoEnabled()) {
                    log.info((Object)message);
                }
            }
            catch (RemoteException e) {
                String message = "Could not rebind server to registry [" + registry + "].";
                log.error((Object)message, (Throwable)e);
                if (this.cacheEventLogger == null) break block4;
                this.cacheEventLogger.logError("RegistryKeepAliveRunner", "registerServer", message + ":" + e.getMessage());
            }
        }
    }

    public void setCacheEventLogger(ICacheEventLogger cacheEventLogger) {
        this.cacheEventLogger = cacheEventLogger;
    }
}

