/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcs.engine.control;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jcs.auxiliary.AuxiliaryCache;
import org.apache.jcs.auxiliary.AuxiliaryCacheAttributes;
import org.apache.jcs.auxiliary.AuxiliaryCacheConfigurator;
import org.apache.jcs.auxiliary.AuxiliaryCacheFactory;
import org.apache.jcs.engine.behavior.ICompositeCacheAttributes;
import org.apache.jcs.engine.behavior.IElementAttributes;
import org.apache.jcs.engine.behavior.IElementSerializer;
import org.apache.jcs.engine.control.CompositeCache;
import org.apache.jcs.engine.control.CompositeCacheManager;
import org.apache.jcs.engine.logging.behavior.ICacheEventLogger;
import org.apache.jcs.engine.match.KeyMatcherPatternImpl;
import org.apache.jcs.engine.match.behavior.IKeyMatcher;
import org.apache.jcs.utils.config.OptionConverter;
import org.apache.jcs.utils.config.PropertySetter;

public class CompositeCacheConfigurator {
    private static final Log log = LogFactory.getLog((Class)CompositeCacheConfigurator.class);
    static final String DEFAULT_REGION = "jcs.default";
    static final String REGION_PREFIX = "jcs.region.";
    static final String SYSTEM_REGION_PREFIX = "jcs.system.";
    static final String AUXILIARY_PREFIX = "jcs.auxiliary.";
    static final String ATTRIBUTE_PREFIX = ".attributes";
    static final String CACHE_ATTRIBUTE_PREFIX = ".cacheattributes";
    static final String ELEMENT_ATTRIBUTE_PREFIX = ".elementattributes";
    public static final String KEY_MATCHER_PREFIX = ".keymatcher";
    private CompositeCacheManager compositeCacheManager;

    public CompositeCacheConfigurator(CompositeCacheManager ccMgr) {
        this.compositeCacheManager = ccMgr;
    }

    protected void doConfigure(String configFileName) {
        Properties props = new Properties();
        try {
            FileInputStream istream = new FileInputStream(configFileName);
            props.load(istream);
            istream.close();
        }
        catch (IOException e) {
            log.error((Object)("Could not read configuration file, ignored: " + configFileName), (Throwable)e);
            return;
        }
        this.doConfigure(props);
    }

    public void doConfigure(Properties properties) {
        long start = System.currentTimeMillis();
        this.compositeCacheManager.setConfigurationProperties(properties);
        this.setDefaultAuxValues(properties);
        this.setDefaultCompositeCacheAttributes(properties);
        this.setDefaultElementAttributes(properties);
        this.parseSystemRegions(properties);
        this.parseRegions(properties);
        long end = System.currentTimeMillis();
        if (log.isInfoEnabled()) {
            log.info((Object)("Finished configuration in " + (end - start) + " ms."));
        }
    }

    protected void setDefaultAuxValues(Properties props) {
        String value;
        this.compositeCacheManager.defaultAuxValues = value = OptionConverter.findAndSubst(DEFAULT_REGION, props);
        if (log.isInfoEnabled()) {
            log.info((Object)("Setting default auxiliaries to " + value));
        }
    }

    protected void setDefaultCompositeCacheAttributes(Properties props) {
        ICompositeCacheAttributes icca = this.parseCompositeCacheAttributes(props, "", DEFAULT_REGION);
        this.compositeCacheManager.setDefaultCacheAttributes(icca);
        log.info((Object)("setting defaultCompositeCacheAttributes to " + icca));
    }

    protected void setDefaultElementAttributes(Properties props) {
        IElementAttributes iea = this.parseElementAttributes(props, "", DEFAULT_REGION);
        this.compositeCacheManager.setDefaultElementAttributes(iea);
        log.info((Object)("setting defaultElementAttributes to " + iea));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parseSystemRegions(Properties props) {
        Enumeration<?> en = props.propertyNames();
        while (en.hasMoreElements()) {
            CompositeCache cache;
            String key = (String)en.nextElement();
            if (!key.startsWith(SYSTEM_REGION_PREFIX) || key.indexOf("attributes") != -1) continue;
            String regionName = key.substring(SYSTEM_REGION_PREFIX.length());
            String value = OptionConverter.findAndSubst(key, props);
            String string = regionName;
            synchronized (string) {
                cache = this.parseRegion(props, regionName, value, null, SYSTEM_REGION_PREFIX);
            }
            this.compositeCacheManager.systemCaches.put(regionName, cache);
            this.compositeCacheManager.caches.put(regionName, cache);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parseRegions(Properties props) {
        ArrayList<String> regionNames = new ArrayList<String>();
        Enumeration<?> en = props.propertyNames();
        while (en.hasMoreElements()) {
            CompositeCache cache;
            String key = (String)en.nextElement();
            if (!key.startsWith(REGION_PREFIX) || key.indexOf("attributes") != -1) continue;
            String regionName = key.substring(REGION_PREFIX.length());
            regionNames.add(regionName);
            String auxiliaryList = OptionConverter.findAndSubst(key, props);
            String string = regionName;
            synchronized (string) {
                cache = this.parseRegion(props, regionName, auxiliaryList);
            }
            this.compositeCacheManager.caches.put(regionName, cache);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Parsed regions " + regionNames));
        }
    }

    protected CompositeCache parseRegion(Properties props, String regName, String value) {
        return this.parseRegion(props, regName, value, null, REGION_PREFIX);
    }

    protected CompositeCache parseRegion(Properties props, String regName, String value, ICompositeCacheAttributes cca) {
        return this.parseRegion(props, regName, value, cca, REGION_PREFIX);
    }

    protected CompositeCache parseRegion(Properties props, String regName, String value, ICompositeCacheAttributes cca, String regionPrefix) {
        if (cca == null) {
            cca = this.parseCompositeCacheAttributes(props, regName, regionPrefix);
        }
        IElementAttributes ea = this.parseElementAttributes(props, regName, regionPrefix);
        CompositeCache cache = new CompositeCache(regName, cca, ea);
        ArrayList<AuxiliaryCache> auxList = new ArrayList<AuxiliaryCache>();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Parsing region name '" + regName + "', value '" + value + "'"));
        }
        StringTokenizer st = new StringTokenizer(value, ",");
        if (!(value.startsWith(",") || value.equals("") || st.hasMoreTokens())) {
            return null;
        }
        while (st.hasMoreTokens()) {
            String auxName = st.nextToken().trim();
            if (auxName == null || auxName.equals(",")) continue;
            log.debug((Object)("Parsing auxiliary named \"" + auxName + "\"."));
            AuxiliaryCache auxCache = this.parseAuxiliary(cache, props, auxName, regName);
            if (auxCache == null) continue;
            auxList.add(auxCache);
        }
        cache.setAuxCaches(auxList.toArray(new AuxiliaryCache[0]));
        return cache;
    }

    protected ICompositeCacheAttributes parseCompositeCacheAttributes(Properties props, String regName) {
        return this.parseCompositeCacheAttributes(props, regName, REGION_PREFIX);
    }

    protected ICompositeCacheAttributes parseCompositeCacheAttributes(Properties props, String regName, String regionPrefix) {
        String attrName = regionPrefix + regName + CACHE_ATTRIBUTE_PREFIX;
        ICompositeCacheAttributes ccAttr = (ICompositeCacheAttributes)OptionConverter.instantiateByKey(props, attrName, ICompositeCacheAttributes.class, null);
        if (ccAttr == null) {
            if (log.isInfoEnabled()) {
                log.info((Object)("No special CompositeCacheAttributes class defined for key [" + attrName + "], using default class."));
            }
            ICompositeCacheAttributes ccAttr2 = this.compositeCacheManager.getDefaultCacheAttributes();
            ccAttr = ccAttr2.copy();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Parsing options for '" + attrName + "'"));
        }
        PropertySetter.setProperties(ccAttr, props, attrName + ".");
        ccAttr.setCacheName(regName);
        if (log.isDebugEnabled()) {
            log.debug((Object)("End of parsing for \"" + attrName + "\"."));
        }
        ccAttr.setCacheName(regName);
        return ccAttr;
    }

    protected IElementAttributes parseElementAttributes(Properties props, String regName, String regionPrefix) {
        String attrName = regionPrefix + regName + ELEMENT_ATTRIBUTE_PREFIX;
        IElementAttributes eAttr = (IElementAttributes)OptionConverter.instantiateByKey(props, attrName, IElementAttributes.class, null);
        if (eAttr == null) {
            if (log.isInfoEnabled()) {
                log.info((Object)("No special ElementAttribute class defined for key [" + attrName + "], using default class."));
            }
            IElementAttributes eAttr2 = this.compositeCacheManager.getDefaultElementAttributes();
            eAttr = eAttr2.copy();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Parsing options for '" + attrName + "'"));
        }
        PropertySetter.setProperties(eAttr, props, attrName + ".");
        if (log.isDebugEnabled()) {
            log.debug((Object)("End of parsing for \"" + attrName + "\"."));
        }
        return eAttr;
    }

    protected AuxiliaryCache parseAuxiliary(CompositeCache cache, Properties props, String auxName, String regName) {
        AuxiliaryCacheFactory auxFac;
        if (log.isDebugEnabled()) {
            log.debug((Object)("parseAuxiliary, Cache = " + cache));
        }
        if ((auxFac = this.compositeCacheManager.registryFacGet(auxName)) == null) {
            String prefix = AUXILIARY_PREFIX + auxName;
            auxFac = (AuxiliaryCacheFactory)OptionConverter.instantiateByKey(props, prefix, AuxiliaryCacheFactory.class, null);
            if (auxFac == null) {
                log.error((Object)("Could not instantiate auxFactory named \"" + auxName + "\"."));
                return null;
            }
            auxFac.setName(auxName);
            this.compositeCacheManager.registryFacPut(auxFac);
        }
        AuxiliaryCacheAttributes auxAttr = this.compositeCacheManager.registryAttrGet(auxName);
        String attrName = AUXILIARY_PREFIX + auxName + ATTRIBUTE_PREFIX;
        if (auxAttr == null) {
            String prefix = AUXILIARY_PREFIX + auxName + ATTRIBUTE_PREFIX;
            auxAttr = (AuxiliaryCacheAttributes)OptionConverter.instantiateByKey(props, prefix, AuxiliaryCacheAttributes.class, null);
            if (auxAttr == null) {
                log.error((Object)("Could not instantiate auxAttr named '" + attrName + "'"));
                return null;
            }
            auxAttr.setName(auxName);
            this.compositeCacheManager.registryAttrPut(auxAttr);
        }
        auxAttr = auxAttr.copy();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Parsing options for '" + attrName + "'"));
        }
        PropertySetter.setProperties(auxAttr, props, attrName + ".");
        auxAttr.setCacheName(regName);
        if (log.isDebugEnabled()) {
            log.debug((Object)("End of parsing for '" + attrName + "'"));
        }
        auxAttr.setCacheName(regName);
        String auxPrefix = AUXILIARY_PREFIX + auxName;
        ICacheEventLogger cacheEventLogger = AuxiliaryCacheConfigurator.parseCacheEventLogger(props, auxPrefix);
        IElementSerializer elementSerializer = AuxiliaryCacheConfigurator.parseElementSerializer(props, auxPrefix);
        AuxiliaryCache auxCache = auxFac.createCache(auxAttr, this.compositeCacheManager, cacheEventLogger, elementSerializer);
        return auxCache;
    }

    public static IKeyMatcher parseKeyMatcher(Properties props, String auxPrefix) {
        IKeyMatcher keyMatcher = null;
        String keyMatcherClassName = auxPrefix + KEY_MATCHER_PREFIX;
        keyMatcher = (IKeyMatcher)OptionConverter.instantiateByKey(props, keyMatcherClassName, IKeyMatcher.class, null);
        if (keyMatcher != null) {
            String attributePrefix = auxPrefix + KEY_MATCHER_PREFIX + ATTRIBUTE_PREFIX;
            PropertySetter.setProperties(keyMatcher, props, attributePrefix + ".");
            if (log.isInfoEnabled()) {
                log.info((Object)("Using custom key matcher [" + keyMatcher + "] for auxiliary [" + auxPrefix + "]"));
            }
        } else {
            keyMatcher = new KeyMatcherPatternImpl();
            if (log.isInfoEnabled()) {
                log.info((Object)("Using standard key matcher [" + keyMatcher + "] for auxiliary [" + auxPrefix + "]"));
            }
        }
        return keyMatcher;
    }
}

