/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcs.auxiliary.disk;

import EDU.oswego.cs.dl.util.concurrent.WriterPreferenceReadWriteLock;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jcs.auxiliary.AbstractAuxiliaryCacheEventLogging;
import org.apache.jcs.auxiliary.AuxiliaryCache;
import org.apache.jcs.auxiliary.disk.LRUMapJCS;
import org.apache.jcs.auxiliary.disk.PurgatoryElement;
import org.apache.jcs.auxiliary.disk.behavior.IDiskCacheAttributes;
import org.apache.jcs.engine.CacheEventQueueFactory;
import org.apache.jcs.engine.CacheInfo;
import org.apache.jcs.engine.behavior.ICacheElement;
import org.apache.jcs.engine.behavior.ICacheEventQueue;
import org.apache.jcs.engine.behavior.ICacheListener;
import org.apache.jcs.engine.stats.StatElement;
import org.apache.jcs.engine.stats.Stats;
import org.apache.jcs.engine.stats.behavior.IStatElement;
import org.apache.jcs.engine.stats.behavior.IStats;

public abstract class AbstractDiskCache
extends AbstractAuxiliaryCacheEventLogging
implements AuxiliaryCache,
Serializable {
    private static final long serialVersionUID = 6541664080877628324L;
    private static final Log log = LogFactory.getLog((Class)AbstractDiskCache.class);
    private IDiskCacheAttributes dcattr = null;
    protected Map purgatory = new HashMap();
    protected ICacheEventQueue cacheEventQueue;
    protected boolean alive = false;
    protected String cacheName;
    protected int purgHits = 0;
    private WriterPreferenceReadWriteLock removeAllLock = new WriterPreferenceReadWriteLock();

    public AbstractDiskCache(IDiskCacheAttributes attr) {
        this.dcattr = attr;
        this.cacheName = attr.getCacheName();
        CacheEventQueueFactory fact = new CacheEventQueueFactory();
        this.cacheEventQueue = fact.createCacheEventQueue(new MyCacheListener(), CacheInfo.listenerId, this.cacheName, this.dcattr.getEventQueuePoolName(), this.dcattr.getEventQueueType());
        this.initPurgatory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initPurgatory() {
        block9: {
            try {
                this.removeAllLock.writeLock().acquire();
                if (this.purgatory != null) {
                    Map map = this.purgatory;
                    synchronized (map) {
                        this.purgatory = this.dcattr.getMaxPurgatorySize() >= 0 ? new LRUMapJCS(this.dcattr.getMaxPurgatorySize()) : new HashMap();
                        break block9;
                    }
                }
                this.purgatory = this.dcattr.getMaxPurgatorySize() >= 0 ? new LRUMapJCS(this.dcattr.getMaxPurgatorySize()) : new HashMap();
            }
            catch (InterruptedException e) {
                log.error((Object)"problem encountered resseting purgatory.", (Throwable)e);
            }
            finally {
                this.removeAllLock.writeLock().release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void update(ICacheElement cacheElement) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Putting element in purgatory, cacheName: " + this.cacheName + ", key: " + cacheElement.getKey()));
        }
        try {
            PurgatoryElement pe = new PurgatoryElement(cacheElement);
            pe.setSpoolable(true);
            Map map = this.purgatory;
            synchronized (map) {
                this.purgatory.put(pe.getKey(), pe);
            }
            this.cacheEventQueue.addPutEvent(pe);
        }
        catch (IOException ex) {
            log.error((Object)"Problem adding put event to queue.", (Throwable)ex);
            this.cacheEventQueue.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ICacheElement get(Serializable key) {
        if (!this.alive) {
            return null;
        }
        PurgatoryElement pe = null;
        Map map = this.purgatory;
        synchronized (map) {
            pe = (PurgatoryElement)this.purgatory.get(key);
        }
        if (pe != null) {
            ++this.purgHits;
            if (log.isDebugEnabled() && this.purgHits % 100 == 0) {
                log.debug((Object)("Purgatory hits = " + this.purgHits));
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Found element in purgatory, cacheName: " + this.cacheName + ", key: " + key));
            }
            return pe.cacheElement;
        }
        try {
            return this.doGet(key);
        }
        catch (Exception e) {
            log.error((Object)e);
            this.cacheEventQueue.destroy();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getMatching(String pattern) throws IOException {
        Object[] keyArray = null;
        Map map = this.purgatory;
        synchronized (map) {
            keyArray = this.purgatory.keySet().toArray();
        }
        Set matchingKeys = this.getKeyMatcher().getMatchingKeysFromArray(pattern, keyArray);
        Map result = this.processGetMultiple(matchingKeys);
        Map diskMatches = this.doGetMatching(pattern);
        result.putAll(diskMatches);
        return result;
    }

    public Map processGetMultiple(Set keys) {
        HashMap<Serializable, ICacheElement> elements = new HashMap<Serializable, ICacheElement>();
        if (keys != null && !keys.isEmpty()) {
            Iterator iterator = keys.iterator();
            while (iterator.hasNext()) {
                Serializable key = (Serializable)iterator.next();
                ICacheElement element = this.get(key);
                if (element == null) continue;
                elements.put(key, element);
            }
        }
        return elements;
    }

    public abstract Set getGroupKeys(String var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean remove(Serializable key) throws IOException {
        PurgatoryElement pe = null;
        Object object = this.purgatory;
        synchronized (object) {
            pe = (PurgatoryElement)this.purgatory.get(key);
        }
        if (pe != null) {
            object = pe.getCacheElement();
            synchronized (object) {
                Map map = this.purgatory;
                synchronized (map) {
                    this.purgatory.remove(key);
                }
                pe.setSpoolable(false);
                this.doRemove(key);
            }
        }
        this.doRemove(key);
        return false;
    }

    public final void removeAll() throws IOException {
        if (this.dcattr.isAllowRemoveAll()) {
            this.initPurgatory();
            this.doRemoveAll();
        } else if (log.isInfoEnabled()) {
            log.info((Object)"RemoveAll was requested but the request was not fulfilled: allowRemoveAll is set to false.");
        }
    }

    public final void dispose() throws IOException {
        Runnable disR = new Runnable(){

            public void run() {
                boolean keepGoing = true;
                long total = 0L;
                long interval = 100L;
                while (keepGoing) {
                    keepGoing = !AbstractDiskCache.this.cacheEventQueue.isEmpty();
                    try {
                        Thread.sleep(interval);
                        total += interval;
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                        break;
                    }
                }
                log.info((Object)("No longer waiting for event queue to finish: " + AbstractDiskCache.this.cacheEventQueue.getStatistics()));
            }
        };
        Thread t = new Thread(disR);
        t.start();
        try {
            t.join(this.dcattr.getShutdownSpoolTimeLimit() * 1000);
        }
        catch (InterruptedException ex) {
            log.error((Object)"The Shutdown Spool Process was interrupted.", (Throwable)ex);
        }
        log.info((Object)"In dispose, destroying event queue.");
        this.cacheEventQueue.destroy();
        this.doDispose();
        this.alive = false;
    }

    public String getCacheName() {
        return this.cacheName;
    }

    public String getStats() {
        return this.getStatistics().toString();
    }

    public IStats getStatistics() {
        Stats stats = new Stats();
        stats.setTypeName("Abstract Disk Cache");
        ArrayList<IStatElement> elems = new ArrayList<IStatElement>();
        StatElement se = null;
        se = new StatElement();
        se.setName("Purgatory Hits");
        se.setData("" + this.purgHits);
        elems.add(se);
        se = new StatElement();
        se.setName("Purgatory Size");
        se.setData("" + this.purgatory.size());
        elems.add(se);
        IStats eqStats = this.cacheEventQueue.getStatistics();
        IStatElement[] eqSEs = eqStats.getStatElements();
        List<IStatElement> eqL = Arrays.asList(eqSEs);
        elems.addAll(eqL);
        IStatElement[] ses = elems.toArray(new StatElement[0]);
        stats.setStatElements(ses);
        return stats;
    }

    public int getStatus() {
        return this.alive ? 1 : 2;
    }

    public abstract int getSize();

    public int getCacheType() {
        return 2;
    }

    protected final ICacheElement doGet(Serializable key) throws IOException {
        return super.getWithEventLogging(key);
    }

    protected final Map doGetMatching(String pattern) throws IOException {
        return super.getMatchingWithEventLogging(pattern);
    }

    protected final void doUpdate(ICacheElement cacheElement) throws IOException {
        super.updateWithEventLogging(cacheElement);
    }

    protected final boolean doRemove(Serializable key) throws IOException {
        return super.removeWithEventLogging(key);
    }

    protected final void doRemoveAll() throws IOException {
        super.removeAllWithEventLogging();
    }

    protected final void doDispose() throws IOException {
        super.disposeWithEventLogging();
    }

    public String getEventLoggingExtraInfo() {
        return this.getDiskLocation();
    }

    protected abstract String getDiskLocation();

    private class MyCacheListener
    implements ICacheListener {
        private long listenerId = 0L;

        private MyCacheListener() {
        }

        public long getListenerId() throws IOException {
            return this.listenerId;
        }

        public void setListenerId(long id) throws IOException {
            this.listenerId = id;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handlePut(ICacheElement element) throws IOException {
            if (AbstractDiskCache.this.alive) {
                if (element instanceof PurgatoryElement) {
                    PurgatoryElement pe = (PurgatoryElement)element;
                    ICacheElement iCacheElement = pe.getCacheElement();
                    synchronized (iCacheElement) {
                        Map map;
                        try {
                            AbstractDiskCache.this.removeAllLock.readLock().acquire();
                            map = AbstractDiskCache.this.purgatory;
                            synchronized (map) {
                                block23: {
                                    if (AbstractDiskCache.this.purgatory.containsKey(pe.getKey())) break block23;
                                    return;
                                }
                                element = pe.getCacheElement();
                            }
                            if (pe.isSpoolable()) {
                                AbstractDiskCache.this.doUpdate(element);
                            }
                        }
                        catch (InterruptedException e) {
                            log.error((Object)e);
                        }
                        finally {
                            AbstractDiskCache.this.removeAllLock.readLock().release();
                        }
                        map = AbstractDiskCache.this.purgatory;
                        synchronized (map) {
                            AbstractDiskCache.this.purgatory.remove(element.getKey());
                        }
                    }
                }
                AbstractDiskCache.this.doUpdate(element);
            } else {
                Map map = AbstractDiskCache.this.purgatory;
                synchronized (map) {
                    AbstractDiskCache.this.purgatory.remove(element.getKey());
                }
            }
        }

        public void handleRemove(String cacheName, Serializable key) throws IOException {
            if (AbstractDiskCache.this.alive && AbstractDiskCache.this.doRemove(key)) {
                log.debug((Object)("Element removed, key: " + key));
            }
        }

        public void handleRemoveAll(String cacheName) throws IOException {
            if (AbstractDiskCache.this.alive) {
                AbstractDiskCache.this.doRemoveAll();
            }
        }

        public void handleDispose(String cacheName) throws IOException {
            if (AbstractDiskCache.this.alive) {
                AbstractDiskCache.this.doDispose();
            }
        }
    }
}

