/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcs.auxiliary.disk.jdbc.mysql;

import java.io.Serializable;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jcs.auxiliary.disk.jdbc.JDBCDiskCache;
import org.apache.jcs.auxiliary.disk.jdbc.TableState;
import org.apache.jcs.auxiliary.disk.jdbc.mysql.MySQLDiskCacheAttributes;
import org.apache.jcs.engine.behavior.ICacheElement;
import org.apache.jcs.engine.behavior.ICompositeCacheManager;

public class MySQLDiskCache
extends JDBCDiskCache {
    private static final long serialVersionUID = -7169488308515823491L;
    private static final Log log = LogFactory.getLog((Class)MySQLDiskCache.class);
    private MySQLDiskCacheAttributes mySQLDiskCacheAttributes;

    public MySQLDiskCache(MySQLDiskCacheAttributes attributes, TableState tableState, ICompositeCacheManager compositeCacheManager) {
        super(attributes, tableState, compositeCacheManager);
        this.mySQLDiskCacheAttributes = attributes;
        if (log.isDebugEnabled()) {
            log.debug((Object)("MySQLDiskCacheAttributes = " + attributes));
        }
    }

    protected ICacheElement processGet(Serializable key) {
        if (this.getTableState().getState() == 2 && this.mySQLDiskCacheAttributes.isBalkDuringOptimization()) {
            return null;
        }
        return super.processGet(key);
    }

    protected Map processGetMatching(String pattern) {
        if (this.getTableState().getState() == 2 && this.mySQLDiskCacheAttributes.isBalkDuringOptimization()) {
            return null;
        }
        return super.processGetMatching(pattern);
    }

    public String constructLikeParameterFromPattern(String pattern) {
        pattern = pattern.replaceAll("\\.\\+", "%");
        pattern = pattern.replaceAll("\\.", "_");
        if (log.isDebugEnabled()) {
            log.debug((Object)("pattern = [" + pattern + "]"));
        }
        return pattern;
    }

    protected void processUpdate(ICacheElement element) {
        if (this.getTableState().getState() == 2 && this.mySQLDiskCacheAttributes.isBalkDuringOptimization()) {
            return;
        }
        super.processUpdate(element);
    }

    protected int deleteExpired() {
        if (this.getTableState().getState() == 2 && this.mySQLDiskCacheAttributes.isBalkDuringOptimization()) {
            return -1;
        }
        return super.deleteExpired();
    }
}

