/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcs.auxiliary.lateral.socket.tcp.discovery;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jcs.auxiliary.lateral.LateralCacheInfo;
import org.apache.jcs.auxiliary.lateral.socket.tcp.discovery.MyByteArrayOutputStream;
import org.apache.jcs.auxiliary.lateral.socket.tcp.discovery.UDPDiscoveryMessage;

public class UDPDiscoverySender {
    private static final Log log = LogFactory.getLog((Class)UDPDiscoverySender.class);
    private MulticastSocket m_localSocket;
    private InetAddress m_multicastAddress;
    private int m_multicastPort;

    public UDPDiscoverySender(String host, int port) throws IOException {
        try {
            this.m_localSocket = new MulticastSocket();
            this.m_multicastAddress = InetAddress.getByName(host);
        }
        catch (IOException e) {
            log.error((Object)("Could not bind to multicast address [" + host + "]"), (Throwable)e);
            throw e;
        }
        this.m_multicastPort = port;
    }

    public void destroy() {
        try {
            if (this.m_localSocket != null) {
                this.m_localSocket.close();
            }
        }
        catch (Exception e) {
            log.error((Object)"Problem destrying sender", (Throwable)e);
        }
    }

    public void finalize() throws Throwable {
        super.finalize();
        this.destroy();
    }

    public void send(UDPDiscoveryMessage message) throws IOException {
        if (this.m_localSocket == null) {
            throw new IOException("Socket is null, cannot send message.");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("sending UDPDiscoveryMessage, message = " + message));
        }
        try {
            MyByteArrayOutputStream byteStream = new MyByteArrayOutputStream();
            ObjectOutputStream objectStream = new ObjectOutputStream(byteStream);
            objectStream.writeObject(message);
            objectStream.flush();
            byte[] bytes = byteStream.getBytes();
            DatagramPacket packet = new DatagramPacket(bytes, bytes.length, this.m_multicastAddress, this.m_multicastPort);
            this.m_localSocket.send(packet);
        }
        catch (IOException e) {
            log.error((Object)"Error sending message", (Throwable)e);
            throw e;
        }
    }

    public void requestBroadcast() throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"sending requestBroadcast ");
        }
        UDPDiscoveryMessage message = new UDPDiscoveryMessage();
        message.setRequesterId(LateralCacheInfo.listenerId);
        message.setMessageType(1);
        this.send(message);
    }

    public void passiveBroadcast(String host, int port, ArrayList cacheNames) throws IOException {
        this.passiveBroadcast(host, port, cacheNames, LateralCacheInfo.listenerId);
    }

    protected void passiveBroadcast(String host, int port, ArrayList cacheNames, long listenerId) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"sending passiveBroadcast ");
        }
        UDPDiscoveryMessage message = new UDPDiscoveryMessage();
        message.setHost(host);
        message.setPort(port);
        message.setCacheNames(cacheNames);
        message.setRequesterId(listenerId);
        message.setMessageType(0);
        this.send(message);
    }
}

