/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcs.auxiliary.lateral.socket.tcp.discovery;

import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jcs.auxiliary.lateral.socket.tcp.discovery.UDPDiscoverySender;

public class UDPDiscoverySenderThread
implements Runnable {
    private static final Log log = LogFactory.getLog((Class)UDPDiscoverySenderThread.class);
    private String discoveryAddress = "";
    private int discoveryPort = 0;
    private String myHostName = null;
    private int myPort = 0;
    private ArrayList cacheNames = new ArrayList();

    protected void setCacheNames(ArrayList cacheNames) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Resetting cacheNames = [" + cacheNames + "]"));
        }
        this.cacheNames = cacheNames;
    }

    protected ArrayList getCacheNames() {
        return this.cacheNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UDPDiscoverySenderThread(String discoveryAddress, int discoveryPort, String myHostName, int myPort, ArrayList cacheNames) {
        this.discoveryAddress = discoveryAddress;
        this.discoveryPort = discoveryPort;
        this.myHostName = myHostName;
        this.myPort = myPort;
        this.cacheNames = cacheNames;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Creating sender thread for discoveryAddress = [" + discoveryAddress + "] and discoveryPort = [" + discoveryPort + "] myHostName = [" + myHostName + "] and port = [" + myPort + "]"));
        }
        UDPDiscoverySender sender = null;
        try {
            sender = new UDPDiscoverySender(discoveryAddress, discoveryPort);
            sender.requestBroadcast();
            if (log.isDebugEnabled()) {
                log.debug((Object)"Sent a request broadcast to the group");
            }
        }
        catch (Exception e) {
            log.error((Object)"Problem sending a Request Broadcast", (Throwable)e);
        }
        finally {
            try {
                if (sender != null) {
                    sender.destroy();
                }
            }
            catch (Exception e) {
                log.error((Object)"Problem closing Request Broadcast sender", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        UDPDiscoverySender sender = null;
        try {
            sender = new UDPDiscoverySender(this.discoveryAddress, this.discoveryPort);
            sender.passiveBroadcast(this.myHostName, this.myPort, this.cacheNames);
            if (log.isDebugEnabled()) {
                log.debug((Object)"Called sender to issue a passive broadcast");
            }
        }
        catch (Exception e) {
            log.error((Object)("Problem calling the UDP Discovery Sender [" + this.discoveryAddress + ":" + this.discoveryPort + "]"), (Throwable)e);
        }
        finally {
            try {
                sender.destroy();
            }
            catch (Exception e) {
                log.error((Object)"Problem closing Passive Broadcast sender", (Throwable)e);
            }
        }
    }
}

