/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcs.auxiliary.remote;

import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jcs.auxiliary.remote.behavior.IRemoteCacheService;
import org.apache.jcs.engine.ZombieCacheService;
import org.apache.jcs.engine.behavior.ICacheElement;
import org.apache.jcs.utils.struct.BoundedQueue;
import org.apache.jcs.utils.timing.ElapsedTimer;

public class ZombieRemoteCacheService
extends ZombieCacheService
implements IRemoteCacheService {
    private static final Log log = LogFactory.getLog((Class)ZombieRemoteCacheService.class);
    private int maxQueueSize = 0;
    private BoundedQueue queue;

    public ZombieRemoteCacheService() {
        this.queue = new BoundedQueue(0);
    }

    public ZombieRemoteCacheService(int maxQueueSize) {
        this.maxQueueSize = maxQueueSize;
        this.queue = new BoundedQueue(maxQueueSize);
    }

    public int getQueueSize() {
        return this.queue.size();
    }

    public void update(ICacheElement item, long listenerId) {
        if (this.maxQueueSize > 0) {
            PutEvent event = new PutEvent(item, listenerId);
            this.queue.add(event);
        }
    }

    public void remove(String cacheName, Serializable key, long listenerId) {
        if (this.maxQueueSize > 0) {
            RemoveEvent event = new RemoveEvent(cacheName, key, listenerId);
            this.queue.add(event);
        }
    }

    public void removeAll(String cacheName, long listenerId) {
        if (this.maxQueueSize > 0) {
            RemoveAllEvent event = new RemoveAllEvent(cacheName, listenerId);
            this.queue.add(event);
        }
    }

    public ICacheElement get(String cacheName, Serializable key, long requesterId) throws IOException {
        return null;
    }

    public Map getMatching(String cacheName, String pattern, long requesterId) throws IOException {
        return Collections.EMPTY_MAP;
    }

    public Map getMultiple(String cacheName, Set keys, long requesterId) {
        return new HashMap();
    }

    public Set getGroupKeys(String cacheName, String groupName) {
        return Collections.EMPTY_SET;
    }

    protected void propagateEvents(IRemoteCacheService service) throws Exception {
        int cnt = 0;
        if (log.isInfoEnabled()) {
            log.info((Object)"Propagating events to the new RemoteService.");
        }
        ElapsedTimer timer = new ElapsedTimer();
        while (!this.queue.isEmpty()) {
            ++cnt;
            ZombieEvent event = (ZombieEvent)this.queue.take();
            if (event instanceof PutEvent) {
                PutEvent putEvent = (PutEvent)event;
                service.update(putEvent.element, event.requesterId);
                continue;
            }
            if (event instanceof RemoveEvent) {
                RemoveEvent removeEvent = (RemoveEvent)event;
                service.remove(event.cacheName, removeEvent.key, event.requesterId);
                continue;
            }
            if (!(event instanceof RemoveAllEvent)) continue;
            service.removeAll(event.cacheName, event.requesterId);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Propagated " + cnt + " events to the new RemoteService in " + timer.getElapsedTimeString()));
        }
    }

    private class RemoveAllEvent
    extends ZombieEvent {
        public RemoveAllEvent(String cacheName, long requesterId) {
            this.cacheName = cacheName;
            this.requesterId = requesterId;
        }
    }

    private class RemoveEvent
    extends ZombieEvent {
        Serializable key;

        public RemoveEvent(String cacheName, Serializable key, long requesterId) {
            this.cacheName = cacheName;
            this.requesterId = requesterId;
            this.key = key;
        }
    }

    private class PutEvent
    extends ZombieEvent {
        ICacheElement element;

        public PutEvent(ICacheElement element, long requesterId) {
            this.requesterId = requesterId;
            this.element = element;
        }
    }

    private abstract class ZombieEvent {
        String cacheName;
        long requesterId;

        private ZombieEvent() {
        }
    }
}

