/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcs.engine.logging;

import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jcs.engine.logging.CacheEvent;
import org.apache.jcs.engine.logging.behavior.ICacheEvent;
import org.apache.jcs.engine.logging.behavior.ICacheEventLogger;

public class CacheEventLoggerDebugLogger
implements ICacheEventLogger {
    private String logCategoryName = CacheEventLoggerDebugLogger.class.getName();
    private Log log = LogFactory.getLog((String)this.logCategoryName);

    public ICacheEvent createICacheEvent(String source, String region, String eventName, String optionalDetails, Serializable key) {
        CacheEvent event = new CacheEvent();
        event.setSource(source);
        event.setRegion(region);
        event.setEventName(eventName);
        event.setOptionalDetails(optionalDetails);
        event.setKey(key);
        return event;
    }

    public void logApplicationEvent(String source, String eventName, String optionalDetails) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)(source + " | " + eventName + " | " + optionalDetails));
        }
    }

    public void logError(String source, String eventName, String errorMessage) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)(source + " | " + eventName + " | " + errorMessage));
        }
    }

    public void logICacheEvent(ICacheEvent event) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)event);
        }
    }

    public synchronized void setLogCategoryName(String logCategoryName) {
        if (logCategoryName != null && !logCategoryName.equals(this.logCategoryName)) {
            this.logCategoryName = logCategoryName;
            this.log = LogFactory.getLog((String)logCategoryName);
        }
    }
}

